/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.TypeAdapter;
import java.io.IOException;
import java.net.ProtocolException;

public enum FieldEncoding {
    VARINT(0),
    FIXED64(1),
    LENGTH_DELIMITED(2),
    FIXED32(5);

    private final int value;

    private FieldEncoding(int value) {
        this.value = value;
    }

    static FieldEncoding get(int value) throws IOException {
        switch (value) {
            case 0: {
                return VARINT;
            }
            case 1: {
                return FIXED64;
            }
            case 2: {
                return LENGTH_DELIMITED;
            }
            case 5: {
                return FIXED32;
            }
        }
        throw new ProtocolException("Unexpected FieldEncoding: " + value);
    }

    int value() {
        return this.value;
    }

    public TypeAdapter<?> rawTypeAdapter() {
        switch (this) {
            case VARINT: {
                return TypeAdapter.UINT64;
            }
            case FIXED32: {
                return TypeAdapter.FIXED32;
            }
            case FIXED64: {
                return TypeAdapter.FIXED64;
            }
            case LENGTH_DELIMITED: {
                return TypeAdapter.BYTES;
            }
        }
        throw new AssertionError();
    }
}

