/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.Message;
import java.util.Collections;
import java.util.List;

public abstract class ExtendableMessage<T extends ExtendableMessage<?>>
extends Message {
    transient ExtensionMap<T> extensionMap;

    protected ExtendableMessage() {
    }

    protected void setBuilder(ExtendableBuilder<T> builder) {
        super.setBuilder(builder);
        if (builder.extensionMap != null) {
            this.extensionMap = new ExtensionMap(builder.extensionMap);
        }
    }

    public List<Extension<T, ?>> getExtensions() {
        return this.extensionMap == null ? Collections.emptyList() : this.extensionMap.getExtensions();
    }

    public <E> E getExtension(Extension<T, E> extension) {
        return this.extensionMap == null ? null : (E)this.extensionMap.get(extension);
    }

    protected boolean extensionsEqual(ExtendableMessage<T> other) {
        if (this.extensionMap == null) {
            return other.extensionMap == null;
        }
        return this.extensionMap.equals(other.extensionMap);
    }

    protected int extensionsHashCode() {
        return this.extensionMap == null ? 0 : this.extensionMap.hashCode();
    }

    String extensionsToString() {
        return this.extensionMap == null ? "{}" : this.extensionMap.toString();
    }

    public static abstract class ExtendableBuilder<T extends ExtendableMessage<?>>
    extends Message.Builder<T> {
        ExtensionMap<T> extensionMap;

        protected ExtendableBuilder() {
        }

        protected ExtendableBuilder(ExtendableMessage<T> message) {
            super(message);
            if (message != null && message.extensionMap != null) {
                this.extensionMap = new ExtensionMap(message.extensionMap);
            }
        }

        public <E> E getExtension(Extension<T, E> extension) {
            return this.extensionMap == null ? null : (E)this.extensionMap.get(extension);
        }

        public <E> ExtendableBuilder<T> setExtension(Extension<T, E> extension, E value) {
            if (this.extensionMap == null) {
                this.extensionMap = new ExtensionMap<T>(extension, value);
            } else {
                this.extensionMap.put(extension, value);
            }
            return this;
        }
    }
}

