/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.TagMap;
import com.squareup.wire.Wire;
import com.squareup.wire.WireInput;
import com.squareup.wire.WireOutput;
import com.squareup.wire.WireType;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

final class MessageAdapter<M extends Message> {
    private final Wire wire;
    private final Class<M> messageType;
    private final Class<Message.Builder<M>> builderType;
    private final Map<String, Integer> tagMap = new LinkedHashMap<String, Integer>();
    private final TagMap<FieldInfo> fieldInfoMap;

    Message.Builder<M> newBuilder() {
        try {
            return this.builderType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    Collection<FieldInfo> getFields() {
        return this.fieldInfoMap.values();
    }

    FieldInfo getField(String name) {
        Integer key = this.tagMap.get(name);
        return key == null ? null : this.fieldInfoMap.get(key);
    }

    Object getFieldValue(M message, FieldInfo fieldInfo) {
        if (fieldInfo.messageField == null) {
            throw new AssertionError((Object)"Field is not of type \"Message\"");
        }
        try {
            return fieldInfo.messageField.get(message);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setBuilderField(Message.Builder<M> builder, int tag, Object value) {
        try {
            this.fieldInfoMap.get(tag).builderField.set(builder, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    MessageAdapter(Wire wire, Class<M> messageType) {
        this.wire = wire;
        this.messageType = messageType;
        this.builderType = this.getBuilderType(messageType);
        LinkedHashMap<Integer, FieldInfo> map = new LinkedHashMap<Integer, FieldInfo>();
        for (Field messageField : messageType.getDeclaredFields()) {
            ProtoField annotation = messageField.getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            int tag = annotation.tag();
            String name = messageField.getName();
            this.tagMap.put(name, tag);
            Class<Object> enumOrMessageType = null;
            Message.Datatype datatype = annotation.type();
            if (datatype == Message.Datatype.ENUM) {
                enumOrMessageType = this.getEnumType(messageField);
            } else if (datatype == Message.Datatype.MESSAGE) {
                enumOrMessageType = this.getMessageType(messageField);
            }
            map.put(tag, new FieldInfo(tag, name, datatype, annotation.label(), annotation.redacted(), enumOrMessageType, messageField, this.getBuilderField(name)));
        }
        this.fieldInfoMap = TagMap.of(map);
    }

    private Class<Message.Builder<M>> getBuilderType(Class<M> messageType) {
        try {
            return Class.forName(messageType.getName() + "$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }

    private Field getBuilderField(String name) {
        try {
            return this.builderType.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("No builder field " + this.builderType.getName() + "." + name));
        }
    }

    private Class<Message> getMessageType(Field field) {
        Type type;
        Class<Message> fieldType = field.getType();
        if (Message.class.isAssignableFrom(fieldType)) {
            return fieldType;
        }
        if (List.class.isAssignableFrom(fieldType) && (type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && Message.class.isAssignableFrom((Class)type)) {
            return (Class)type;
        }
        return null;
    }

    private Class<Enum> getEnumType(Field field) {
        Type type;
        Class<Enum> fieldType = field.getType();
        if (Enum.class.isAssignableFrom(fieldType)) {
            return fieldType;
        }
        if (List.class.isAssignableFrom(fieldType) && (type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && Enum.class.isAssignableFrom((Class)type)) {
            return (Class)type;
        }
        return null;
    }

    int getSerializedSize(M message) {
        int size = 0;
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            int tag = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    size += this.getPackedSize((List)value, tag, datatype);
                    continue;
                }
                size += this.getRepeatedSize((List)value, tag, datatype);
                continue;
            }
            size += this.getSerializedSize(tag, value, datatype);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            if (extendableMessage.extensionMap != null) {
                size += this.getExtensionsSerializedSize(extendableMessage.extensionMap);
            }
        }
        return size += ((Message)message).getUnknownFieldsSerializedSize();
    }

    private <T extends ExtendableMessage<?>> int getExtensionsSerializedSize(ExtensionMap<T> map) {
        int size = 0;
        for (int i = 0; i < map.size(); ++i) {
            Extension<T, ?> extension = map.getExtension(i);
            Object value = map.getExtensionValue(i);
            int tag = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    size += this.getPackedSize((List)value, tag, datatype);
                    continue;
                }
                size += this.getRepeatedSize((List)value, tag, datatype);
                continue;
            }
            size += this.getSerializedSize(tag, value, datatype);
        }
        return size;
    }

    private int getRepeatedSize(List<?> value, int tag, Message.Datatype datatype) {
        int size = 0;
        for (Object o : value) {
            size += this.getSerializedSize(tag, o, datatype);
        }
        return size;
    }

    private int getPackedSize(List<?> value, int tag, Message.Datatype datatype) {
        int packedLength = 0;
        for (Object o : value) {
            packedLength += this.getSerializedSizeNoTag(o, datatype);
        }
        int size = WireOutput.varint32Size(WireOutput.makeTag(tag, WireType.LENGTH_DELIMITED));
        size += WireOutput.varint32Size(packedLength);
        return size += packedLength;
    }

    void write(M message, WireOutput output) throws IOException {
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            int tag = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(output, (List)value, tag, datatype);
                    continue;
                }
                this.writeRepeated(output, (List)value, tag, datatype);
                continue;
            }
            this.writeValue(output, tag, value, datatype);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            if (extendableMessage.extensionMap != null) {
                this.writeExtensions(output, extendableMessage.extensionMap);
            }
        }
        ((Message)message).writeUnknownFieldMap(output);
    }

    private <T extends ExtendableMessage<?>> void writeExtensions(WireOutput output, ExtensionMap<T> extensionMap) throws IOException {
        for (int i = 0; i < extensionMap.size(); ++i) {
            Extension<T, ?> extension = extensionMap.getExtension(i);
            Object value = extensionMap.getExtensionValue(i);
            int tag = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(output, (List)value, tag, datatype);
                    continue;
                }
                this.writeRepeated(output, (List)value, tag, datatype);
                continue;
            }
            this.writeValue(output, tag, value, datatype);
        }
    }

    private void writeRepeated(WireOutput output, List<?> value, int tag, Message.Datatype datatype) throws IOException {
        for (Object o : value) {
            this.writeValue(output, tag, o, datatype);
        }
    }

    private void writePacked(WireOutput output, List<?> value, int tag, Message.Datatype datatype) throws IOException {
        int packedLength = 0;
        for (Object o : value) {
            packedLength += this.getSerializedSizeNoTag(o, datatype);
        }
        output.writeTag(tag, WireType.LENGTH_DELIMITED);
        output.writeVarint32(packedLength);
        for (Object o : value) {
            this.writeValueNoTag(output, o, datatype);
        }
    }

    byte[] toByteArray(M message) {
        byte[] result = new byte[this.getSerializedSize(message)];
        try {
            this.write(message, WireOutput.newInstance(result));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    String toString(M message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageType.getSimpleName());
        sb.append("{");
        String sep = "";
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null || fieldInfo.redacted) continue;
            sb.append(sep);
            sep = ", ";
            sb.append(fieldInfo.name);
            sb.append("=");
            sb.append(value);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            sb.append(sep);
            sb.append("{extensions=");
            sb.append(extendableMessage.extensionsToString());
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private int getSerializedSize(int tag, Object value, Message.Datatype datatype) {
        return WireOutput.varintTagSize(tag) + this.getSerializedSizeNoTag(value, datatype);
    }

    private int getSerializedSizeNoTag(Object value, Message.Datatype datatype) {
        switch (datatype) {
            case INT32: {
                return WireOutput.int32Size((Integer)value);
            }
            case INT64: 
            case UINT64: {
                return WireOutput.varint64Size((Long)value);
            }
            case UINT32: {
                return WireOutput.varint32Size((Integer)value);
            }
            case SINT32: {
                return WireOutput.varint32Size(WireOutput.zigZag32((Integer)value));
            }
            case SINT64: {
                return WireOutput.varint64Size(WireOutput.zigZag64((Long)value));
            }
            case BOOL: {
                return 1;
            }
            case ENUM: {
                return this.getEnumSize((ProtoEnum)value);
            }
            case STRING: {
                int utf8Length = this.utf8Length((String)value);
                return WireOutput.varint32Size(utf8Length) + utf8Length;
            }
            case BYTES: {
                int length = ((ByteString)value).size();
                return WireOutput.varint32Size(length) + length;
            }
            case MESSAGE: {
                return this.getMessageSize((Message)value);
            }
            case FIXED32: 
            case SFIXED32: 
            case FLOAT: {
                return 4;
            }
            case FIXED64: 
            case SFIXED64: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new RuntimeException();
    }

    private int utf8Length(String s) {
        int count = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    private <E extends ProtoEnum> int getEnumSize(E value) {
        EnumAdapter<?> adapter = this.wire.enumAdapter(value.getClass());
        return WireOutput.varint32Size(adapter.toInt(value));
    }

    private <M extends Message> int getMessageSize(M message) {
        int messageSize = message.getSerializedSize();
        return WireOutput.varint32Size(messageSize) + messageSize;
    }

    private void writeValue(WireOutput output, int tag, Object value, Message.Datatype datatype) throws IOException {
        output.writeTag(tag, datatype.wireType());
        this.writeValueNoTag(output, value, datatype);
    }

    private void writeValueNoTag(WireOutput output, Object value, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: {
                output.writeSignedVarint32((Integer)value);
                break;
            }
            case INT64: 
            case UINT64: {
                output.writeVarint64((Long)value);
                break;
            }
            case UINT32: {
                output.writeVarint32((Integer)value);
                break;
            }
            case SINT32: {
                output.writeVarint32(WireOutput.zigZag32((Integer)value));
                break;
            }
            case SINT64: {
                output.writeVarint64(WireOutput.zigZag64((Long)value));
                break;
            }
            case BOOL: {
                output.writeRawByte((Boolean)value != false ? 1 : 0);
                break;
            }
            case ENUM: {
                this.writeEnum((ProtoEnum)value, output);
                break;
            }
            case STRING: {
                byte[] bytes = ((String)value).getBytes("UTF-8");
                output.writeVarint32(bytes.length);
                output.writeRawBytes(bytes);
                break;
            }
            case BYTES: {
                ByteString byteString = (ByteString)value;
                output.writeVarint32(byteString.size());
                output.writeRawBytes(byteString.toByteArray());
                break;
            }
            case MESSAGE: {
                this.writeMessage((Message)value, output);
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                output.writeFixed32((Integer)value);
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                output.writeFixed64((Long)value);
                break;
            }
            case FLOAT: {
                output.writeFixed32(Float.floatToIntBits(((Float)value).floatValue()));
                break;
            }
            case DOUBLE: {
                output.writeFixed64(Double.doubleToLongBits((Double)value));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private <M extends Message> void writeMessage(M message, WireOutput output) throws IOException {
        output.writeVarint32(message.getSerializedSize());
        MessageAdapter<?> adapter = this.wire.messageAdapter(message.getClass());
        adapter.write(message, output);
    }

    private <E extends ProtoEnum> void writeEnum(E value, WireOutput output) throws IOException {
        EnumAdapter<?> adapter = this.wire.enumAdapter(value.getClass());
        output.writeVarint32(adapter.toInt(value));
    }

    M read(WireInput input) throws IOException {
        try {
            Message.Builder<M> builder = this.builderType.newInstance();
            Storage storage = new Storage();
            while (true) {
                Object value;
                Message.Label label;
                Message.Datatype datatype;
                Extension<ExtendableMessage<?>, ?> extension = null;
                int tagAndType = input.readTag();
                int tag = tagAndType >> 3;
                WireType wireType = WireType.valueOf(tagAndType);
                if (tag == 0) {
                    for (int storedTag : storage.getTags()) {
                        boolean hasField = this.fieldInfoMap.containsKey(storedTag);
                        if (hasField) {
                            this.setBuilderField(builder, storedTag, storage.get(storedTag));
                            continue;
                        }
                        this.setExtension((ExtendableMessage.ExtendableBuilder)builder, this.getExtension(storedTag), storage.get(storedTag));
                    }
                    return builder.build();
                }
                FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
                if (fieldInfo != null) {
                    datatype = fieldInfo.datatype;
                    label = fieldInfo.label;
                } else {
                    extension = this.getExtension(tag);
                    if (extension == null) {
                        this.readUnknownField(builder, input, tag, wireType);
                        continue;
                    }
                    datatype = extension.getDatatype();
                    label = extension.getLabel();
                }
                if (label.isPacked() && wireType == WireType.LENGTH_DELIMITED) {
                    int length = input.readVarint32();
                    long start = input.getPosition();
                    int oldLimit = input.pushLimit(length);
                    while (input.getPosition() < start + (long)length) {
                        value = this.readValue(input, tag, datatype);
                        if (datatype == Message.Datatype.ENUM && value instanceof Integer) {
                            builder.addVarint(tag, ((Integer)value).intValue());
                            continue;
                        }
                        storage.add(tag, value);
                    }
                    input.popLimit(oldLimit);
                    if (input.getPosition() == start + (long)length) continue;
                    throw new IOException("Packed data had wrong length!");
                }
                value = this.readValue(input, tag, datatype);
                if (datatype == Message.Datatype.ENUM && value instanceof Integer) {
                    builder.addVarint(tag, ((Integer)value).intValue());
                    continue;
                }
                if (label.isRepeated()) {
                    storage.add(tag, value);
                    continue;
                }
                if (extension != null) {
                    this.setExtension((ExtendableMessage.ExtendableBuilder)builder, extension, value);
                    continue;
                }
                this.setBuilderField(builder, tag, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Object readValue(WireInput input, int tag, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: 
            case UINT32: {
                return input.readVarint32();
            }
            case INT64: 
            case UINT64: {
                return input.readVarint64();
            }
            case SINT32: {
                return WireInput.decodeZigZag32(input.readVarint32());
            }
            case SINT64: {
                return WireInput.decodeZigZag64(input.readVarint64());
            }
            case BOOL: {
                return input.readVarint32() != 0;
            }
            case ENUM: {
                EnumAdapter<ProtoEnum> adapter = this.getEnumAdapter(tag);
                int value = input.readVarint32();
                try {
                    return adapter.fromInt(value);
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
            }
            case STRING: {
                return input.readString();
            }
            case BYTES: {
                return input.readBytes();
            }
            case MESSAGE: {
                return this.readMessage(input, tag);
            }
            case FIXED32: 
            case SFIXED32: {
                return input.readFixed32();
            }
            case FIXED64: 
            case SFIXED64: {
                return input.readFixed64();
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(input.readFixed32()));
            }
            case DOUBLE: {
                return Double.longBitsToDouble(input.readFixed64());
            }
        }
        throw new RuntimeException();
    }

    private Message readMessage(WireInput input, int tag) throws IOException {
        int length = input.readVarint32();
        if (input.recursionDepth >= 64) {
            throw new IOException("Wire recursion limit exceeded");
        }
        int oldLimit = input.pushLimit(length);
        ++input.recursionDepth;
        MessageAdapter<Message> adapter = this.getMessageAdapter(tag);
        Message message = adapter.read(input);
        input.checkLastTagWas(0);
        --input.recursionDepth;
        input.popLimit(oldLimit);
        return message;
    }

    private MessageAdapter<? extends Message> getMessageAdapter(int tag) {
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        if (fieldInfo != null && fieldInfo.messageAdapter != null) {
            return fieldInfo.messageAdapter;
        }
        MessageAdapter<Message> result = this.wire.messageAdapter(this.getMessageClass(tag));
        if (fieldInfo != null) {
            fieldInfo.messageAdapter = result;
        }
        return result;
    }

    private EnumAdapter<? extends ProtoEnum> getEnumAdapter(int tag) {
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        if (fieldInfo != null && fieldInfo.enumAdapter != null) {
            return fieldInfo.enumAdapter;
        }
        EnumAdapter<ProtoEnum> result = this.wire.enumAdapter(this.getEnumClass(tag));
        if (fieldInfo != null) {
            fieldInfo.enumAdapter = result;
        }
        return result;
    }

    private Class<Message> getMessageClass(int tag) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<Message> messageClass;
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        Class<Message> clazz = messageClass = fieldInfo == null ? null : fieldInfo.messageType;
        if (messageClass == null && (extension = this.getExtension(tag)) != null) {
            messageClass = extension.getMessageType();
        }
        return messageClass;
    }

    private void readUnknownField(Message.Builder builder, WireInput input, int tag, WireType type) throws IOException {
        switch (type) {
            case VARINT: {
                builder.addVarint(tag, input.readVarint64());
                break;
            }
            case FIXED32: {
                builder.addFixed32(tag, input.readFixed32());
                break;
            }
            case FIXED64: {
                builder.addFixed64(tag, input.readFixed64());
                break;
            }
            case LENGTH_DELIMITED: {
                int length = input.readVarint32();
                builder.addLengthDelimited(tag, input.readBytes(length));
                break;
            }
            case START_GROUP: {
                input.skipGroup();
                break;
            }
            case END_GROUP: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported wire type: " + (Object)((Object)type));
            }
        }
    }

    private Extension<ExtendableMessage<?>, ?> getExtension(int tag) {
        ExtensionRegistry registry = this.wire.registry;
        return registry == null ? null : registry.getExtension(this.messageType, tag);
    }

    Extension<ExtendableMessage<?>, ?> getExtension(String name) {
        ExtensionRegistry registry = this.wire.registry;
        return registry == null ? null : registry.getExtension(this.messageType, name);
    }

    private void setExtension(ExtendableMessage.ExtendableBuilder builder, Extension<?, ?> extension, Object value) {
        builder.setExtension(extension, value);
    }

    private Class<? extends ProtoEnum> getEnumClass(int tag) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<? extends ProtoEnum> enumType;
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        Class<? extends ProtoEnum> clazz = enumType = fieldInfo == null ? null : fieldInfo.enumType;
        if (enumType == null && (extension = this.getExtension(tag)) != null) {
            enumType = extension.getEnumType();
        }
        return enumType;
    }

    static class ImmutableList<T>
    implements List<T>,
    Cloneable,
    RandomAccess,
    Serializable {
        private final List<T> list;

        public ImmutableList() {
            this.list = new ArrayList<T>();
        }

        public ImmutableList(List<T> list) {
            this.list = list;
        }

        public Object clone() {
            return new ImmutableList<T>(this.list);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        @NotNull
        public java.util.Iterator<T> iterator() {
            return new Iterator<T>(this.list.iterator());
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        @NotNull
        public <A> A[] toArray(@NotNull A[] array) {
            return this.list.toArray(array);
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> objects) {
            return this.list.containsAll(objects);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i, @NotNull Collection<? extends T> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(int i) {
            return this.list.get(i);
        }

        @Override
        public T set(int i, T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i, T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        @NotNull
        public java.util.ListIterator<T> listIterator() {
            return new ListIterator<T>(this.list.listIterator());
        }

        @Override
        @NotNull
        public java.util.ListIterator<T> listIterator(int i) {
            return new ListIterator<T>(this.list.listIterator(i));
        }

        @Override
        @NotNull
        public List<T> subList(int i, int i2) {
            return new ImmutableList<T>(this.list.subList(i, i2));
        }

        public String toString() {
            return this.list.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ImmutableList) {
                return this.list.equals(((ImmutableList)o).list);
            }
            return this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        private void addPrivate(T t) {
            this.list.add(t);
        }

        private static class ListIterator<T>
        implements java.util.ListIterator<T> {
            private final java.util.ListIterator<T> iterator;

            public ListIterator(java.util.ListIterator<T> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.hasPrevious();
            }

            @Override
            public T previous() {
                return this.iterator.previous();
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.iterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException();
            }
        }

        private static class Iterator<T>
        implements java.util.Iterator<T> {
            private final java.util.Iterator<T> iterator;

            public Iterator(java.util.Iterator<T> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class Storage {
        private Map<Integer, ImmutableList<Object>> map;

        private Storage() {
        }

        void add(int tag, Object value) {
            ImmutableList<Object> list;
            ImmutableList<Object> immutableList = list = this.map == null ? null : this.map.get(tag);
            if (list == null) {
                list = new ImmutableList();
                if (this.map == null) {
                    this.map = new LinkedHashMap<Integer, ImmutableList<Object>>();
                }
                this.map.put(tag, list);
            }
            ((ImmutableList)list).addPrivate(value);
        }

        Set<Integer> getTags() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return this.map.keySet();
        }

        List<Object> get(int tag) {
            return this.map == null ? null : this.map.get(tag);
        }
    }

    public static final class FieldInfo {
        final int tag;
        final String name;
        final Message.Datatype datatype;
        final Message.Label label;
        final Class<? extends ProtoEnum> enumType;
        final Class<? extends Message> messageType;
        final boolean redacted;
        MessageAdapter<? extends Message> messageAdapter;
        EnumAdapter<? extends ProtoEnum> enumAdapter;
        private final Field messageField;
        private final Field builderField;

        private FieldInfo(int tag, String name, Message.Datatype datatype, Message.Label label, boolean redacted, Class<?> enumOrMessageType, Field messageField, Field builderField) {
            this.tag = tag;
            this.name = name;
            this.datatype = datatype;
            this.label = label;
            this.redacted = redacted;
            if (datatype == Message.Datatype.ENUM) {
                this.enumType = enumOrMessageType;
                this.messageType = null;
            } else if (datatype == Message.Datatype.MESSAGE) {
                this.messageType = enumOrMessageType;
                this.enumType = null;
            } else {
                this.enumType = null;
                this.messageType = null;
            }
            this.messageField = messageField;
            this.builderField = builderField;
        }
    }
}

