/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import java.nio.charset.Charset;

final class Stringer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private Stringer() {
    }

    public static byte[] decode(String str) {
        byte[] input = str.getBytes(UTF_8);
        Decoder decoder = new Decoder(new byte[input.length * 3 / 4]);
        if (!decoder.process(input, 0, input.length, true)) {
            throw new IllegalArgumentException("bad base-64");
        }
        if (decoder.op == decoder.output.length) {
            return decoder.output;
        }
        byte[] temp = new byte[decoder.op];
        System.arraycopy(decoder.output, 0, temp, 0, decoder.op);
        return temp;
    }

    public static String encode(byte[] input) {
        int outputLen = input.length / 3 * 4;
        if (input.length % 3 > 0) {
            outputLen += 4;
        }
        Encoder encoder = new Encoder(new byte[outputLen]);
        encoder.process(input, 0, input.length, true);
        return new String(encoder.output, UTF_8);
    }

    private static class Encoder {
        private static final byte[] ENCODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private final byte[] output;
        private final byte[] tail;
        private int tailLen;

        public Encoder(byte[] output) {
            this.output = output;
            this.tail = new byte[2];
            this.tailLen = 0;
        }

        public void process(byte[] input, int offset, int len, boolean finish) {
            byte[] alphabet = ENCODE;
            byte[] output = this.output;
            int op = 0;
            int p = offset;
            len += offset;
            int v = -1;
            switch (this.tailLen) {
                case 0: {
                    break;
                }
                case 1: {
                    if (p + 2 > len) break;
                    v = (this.tail[0] & 0xFF) << 16 | (input[p++] & 0xFF) << 8 | input[p++] & 0xFF;
                    this.tailLen = 0;
                    break;
                }
                case 2: {
                    if (p + 1 > len) break;
                    v = (this.tail[0] & 0xFF) << 16 | (this.tail[1] & 0xFF) << 8 | input[p++] & 0xFF;
                    this.tailLen = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("tailLen = " + this.tailLen));
                }
            }
            if (v != -1) {
                output[op++] = alphabet[v >> 18 & 0x3F];
                output[op++] = alphabet[v >> 12 & 0x3F];
                output[op++] = alphabet[v >> 6 & 0x3F];
                output[op++] = alphabet[v & 0x3F];
            }
            while (p + 3 <= len) {
                v = (input[p] & 0xFF) << 16 | (input[p + 1] & 0xFF) << 8 | input[p + 2] & 0xFF;
                output[op] = alphabet[v >> 18 & 0x3F];
                output[op + 1] = alphabet[v >> 12 & 0x3F];
                output[op + 2] = alphabet[v >> 6 & 0x3F];
                output[op + 3] = alphabet[v & 0x3F];
                p += 3;
                op += 4;
            }
            if (finish) {
                if (p - this.tailLen == len - 1) {
                    int t = 0;
                    v = ((this.tailLen > 0 ? this.tail[t++] : input[p]) & 0xFF) << 4;
                    this.tailLen -= t;
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    output[op++] = 61;
                    output[op] = 61;
                } else if (p - this.tailLen == len - 2) {
                    int t = 0;
                    v = ((this.tailLen > 1 ? this.tail[t++] : input[p++]) & 0xFF) << 10 | ((this.tailLen > 0 ? this.tail[t++] : input[p]) & 0xFF) << 2;
                    this.tailLen -= t;
                    output[op++] = alphabet[v >> 12 & 0x3F];
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    output[op] = 61;
                }
            } else if (p == len - 1) {
                this.tail[this.tailLen++] = input[p];
            } else if (p == len - 2) {
                this.tail[this.tailLen++] = input[p];
                this.tail[this.tailLen++] = input[p + 1];
            }
        }
    }

    private static class Decoder {
        private static final int[] DECODE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private final byte[] output;
        private int op;
        private static final int SKIP = -1;
        private static final int EQUALS = -2;
        private int state;
        private int value;

        public Decoder(byte[] output) {
            this.output = output;
            this.state = 0;
            this.value = 0;
        }

        public boolean process(byte[] input, int offset, int len, boolean finish) {
            if (this.state == 6) {
                return false;
            }
            int p = offset;
            len += offset;
            int state = this.state;
            int value = this.value;
            int op = 0;
            byte[] output = this.output;
            int[] alphabet = DECODE;
            block16: while (p < len) {
                if (state == 0) {
                    while (p + 4 <= len && (value = alphabet[input[p] & 0xFF] << 18 | alphabet[input[p + 1] & 0xFF] << 12 | alphabet[input[p + 2] & 0xFF] << 6 | alphabet[input[p + 3] & 0xFF]) >= 0) {
                        output[op + 2] = (byte)value;
                        output[op + 1] = (byte)(value >> 8);
                        output[op] = (byte)(value >> 16);
                        op += 3;
                        p += 4;
                    }
                    if (p >= len) break;
                }
                int d = alphabet[input[p++] & 0xFF];
                switch (state) {
                    case 0: {
                        if (d >= 0) {
                            value = d;
                            ++state;
                            continue block16;
                        }
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                    case 1: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            continue block16;
                        }
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                    case 2: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            continue block16;
                        }
                        if (d == -2) {
                            output[op++] = (byte)(value >> 4);
                            state = 4;
                            continue block16;
                        }
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                    case 3: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            output[op + 2] = (byte)value;
                            output[op + 1] = (byte)(value >> 8);
                            output[op] = (byte)(value >> 16);
                            op += 3;
                            state = 0;
                            continue block16;
                        }
                        if (d == -2) {
                            output[op + 1] = (byte)(value >> 2);
                            output[op] = (byte)(value >> 10);
                            op += 2;
                            state = 5;
                            continue block16;
                        }
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                    case 4: {
                        if (d == -2) {
                            ++state;
                            continue block16;
                        }
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                    case 5: {
                        if (d == -1) continue block16;
                        this.state = 6;
                        return false;
                    }
                }
                throw new AssertionError((Object)("state = " + state));
            }
            if (!finish) {
                this.state = state;
                this.value = value;
                this.op = op;
                return true;
            }
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 6;
                    return false;
                }
                case 2: {
                    output[op++] = (byte)(value >> 4);
                    break;
                }
                case 3: {
                    output[op++] = (byte)(value >> 10);
                    output[op++] = (byte)(value >> 2);
                    break;
                }
                case 4: {
                    this.state = 6;
                    return false;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("state = " + state));
                }
            }
            this.state = state;
            this.op = op;
            return true;
        }
    }
}

