/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.wire.AnyMessage;
import com.squareup.wire.AnyMessageJsonAdapter;
import com.squareup.wire.IdentityIfAbsent;
import com.squareup.wire.Message;
import com.squareup.wire.MessageJsonAdapter;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Uint64;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0002\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0018\u0010\u0011\u001a\u00020\u00002\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/squareup/wire/WireJsonAdapterFactory;", "Lcom/squareup/moshi/JsonAdapter$Factory;", "()V", "typeUrlToAdapter", "", "", "Lcom/squareup/wire/ProtoAdapter;", "(Ljava/util/Map;)V", "create", "Lcom/squareup/moshi/JsonAdapter;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "", "moshi", "Lcom/squareup/moshi/Moshi;", "plus", "adapter", "adapters", "", "Companion", "wire-moshi-adapter"})
public final class WireJsonAdapterFactory
implements JsonAdapter.Factory {
    private final Map<String, ProtoAdapter<?>> typeUrlToAdapter;
    private static final JsonAdapter<ByteString> BYTE_STRING_JSON_ADAPTER;
    private static final JsonAdapter<Long> UINT64_JSON_ADAPTER;
    private static final JsonAdapter<Integer> INT_JSON_ADAPTER;
    private static final JsonAdapter<String> STRING_JSON_ADAPTER;
    private static final JsonAdapter<List<Long>> LIST_OF_UINT64_JSON_ADAPTER;
    public static final Companion Companion;

    @NotNull
    public final WireJsonAdapterFactory plus(@NotNull List<? extends ProtoAdapter<?>> adapters) {
        Intrinsics.checkParameterIsNotNull(adapters, (String)"adapters");
        Map newMap = MapsKt.toMutableMap(this.typeUrlToAdapter);
        for (ProtoAdapter<?> adapter : adapters) {
            String key;
            if (adapter.getTypeUrl() == null) {
                throw (Throwable)new IllegalArgumentException("recompile " + adapter.getType() + " to use it with WireJsonAdapterFactory");
            }
            newMap.put(key, adapter);
        }
        return new WireJsonAdapterFactory(newMap);
    }

    @NotNull
    public final WireJsonAdapterFactory plus(@NotNull ProtoAdapter<?> adapter) {
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        return this.plus(CollectionsKt.listOf(adapter));
    }

    @Nullable
    public JsonAdapter<?> create(@NotNull Type type, @NotNull Set<? extends Annotation> annotations, @NotNull Moshi moshi) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)moshi, (String)"moshi");
        Class rawType = Types.getRawType((Type)type);
        Set nextAnnotations = Types.nextAnnotations(annotations, IdentityIfAbsent.class);
        if (nextAnnotations != null) {
            Type type2 = type;
            return Intrinsics.areEqual((Object)type2, Integer.class) ? INT_JSON_ADAPTER : (Intrinsics.areEqual((Object)type2, Integer.TYPE) ? INT_JSON_ADAPTER : (Intrinsics.areEqual((Object)type2, String.class) ? STRING_JSON_ADAPTER : moshi.adapter(type, nextAnnotations)));
        }
        if (Types.nextAnnotations(annotations, Uint64.class) != null) {
            object = rawType;
            if (Intrinsics.areEqual((Object)object, Long.class)) {
                return UINT64_JSON_ADAPTER;
            }
            if (Intrinsics.areEqual((Object)object, Long.TYPE)) {
                return UINT64_JSON_ADAPTER;
            }
            if (Intrinsics.areEqual((Object)object, List.class) && Intrinsics.areEqual((Object)((ParameterizedType)type).getActualTypeArguments()[0], Long.class)) {
                return LIST_OF_UINT64_JSON_ADAPTER;
            }
        }
        object = annotations;
        boolean bl = false;
        if (!object.isEmpty()) {
            return null;
        }
        if (Intrinsics.areEqual((Object)rawType, ByteString.class)) {
            return BYTE_STRING_JSON_ADAPTER;
        }
        if (Intrinsics.areEqual((Object)rawType, AnyMessage.class)) {
            return new AnyMessageJsonAdapter(moshi, this.typeUrlToAdapter);
        }
        return Message.class.isAssignableFrom(rawType) ? (JsonAdapter)new MessageJsonAdapter(moshi, type) : null;
    }

    private WireJsonAdapterFactory(Map<String, ? extends ProtoAdapter<?>> typeUrlToAdapter) {
        this.typeUrlToAdapter = typeUrlToAdapter;
    }

    public WireJsonAdapterFactory() {
        WireJsonAdapterFactory wireJsonAdapterFactory = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        wireJsonAdapterFactory(map);
    }

    static {
        Companion = new Companion(null);
        BYTE_STRING_JSON_ADAPTER = new JsonAdapter<ByteString>(){

            public void toJson(@NotNull JsonWriter out, @Nullable ByteString byteString) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                ByteString byteString2 = byteString;
                out.value(byteString2 != null ? byteString2.base64() : null);
            }

            @Nullable
            public ByteString fromJson(@NotNull JsonReader input) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                String string = input.nextString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.nextString()");
                return ByteString.Companion.decodeBase64(string);
            }
        }.nullSafe();
        UINT64_JSON_ADAPTER = new JsonAdapter<Long>(){
            private final BigInteger power64;
            private final BigInteger maxLong;

            @Nullable
            public Long fromJson(@NotNull JsonReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                BigInteger bigInteger = new BigInteger(reader.nextString());
                return bigInteger.compareTo(this.maxLong) > 0 ? Long.valueOf(bigInteger.subtract(this.power64).longValue()) : Long.valueOf(bigInteger.longValue());
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable Long value) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                Long l = value;
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                if (l < 0L) {
                    BigInteger unsigned = this.power64.add(BigInteger.valueOf(value));
                    writer.value((Number)unsigned);
                } else {
                    writer.value(value.longValue());
                }
            }
            {
                this.power64 = new BigInteger("18446744073709551616");
                this.maxLong = BigInteger.valueOf(Long.MAX_VALUE);
            }
        }.nullSafe();
        INT_JSON_ADAPTER = new JsonAdapter<Integer>(){

            @NotNull
            public Integer fromJson(@NotNull JsonReader reader) {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                return reader.nextInt();
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable Integer value) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                Integer n = value;
                if (n != null && n == 0) {
                    writer.nullValue();
                } else {
                    writer.value((Number)value);
                }
            }
        }.nullSafe();
        STRING_JSON_ADAPTER = new JsonAdapter<String>(){

            @NotNull
            public String fromJson(@NotNull JsonReader reader) {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                String string = reader.nextString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                return string;
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable String value) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                if (Intrinsics.areEqual((Object)value, (Object)"")) {
                    writer.nullValue();
                } else {
                    writer.value(value);
                }
            }
        }.nullSafe();
        LIST_OF_UINT64_JSON_ADAPTER = new JsonAdapter<List<? extends Long>>(){

            @Nullable
            public List<Long> fromJson(@NotNull JsonReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                ArrayList<Object> result = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    Object object = WireJsonAdapterFactory.Companion.getUINT64_JSON_ADAPTER$wire_moshi_adapter().fromJson(reader);
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    result.add(object);
                }
                reader.endArray();
                return result;
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable List<Long> value) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                writer.beginArray();
                List<Long> list = value;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                Iterator<Long> iterator = list.iterator();
                while (iterator.hasNext()) {
                    long v = ((Number)iterator.next()).longValue();
                    WireJsonAdapterFactory.Companion.getUINT64_JSON_ADAPTER$wire_moshi_adapter().toJson(writer, (Object)v);
                }
                writer.endArray();
            }
        }.nullSafe();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR8\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bRP\u0010\f\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u0006*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r \u0006*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u0006*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR8\u0010\u0010\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00110\u0011 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR8\u0010\u0013\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/WireJsonAdapterFactory$Companion;", "", "()V", "BYTE_STRING_JSON_ADAPTER", "Lcom/squareup/moshi/JsonAdapter;", "Lokio/ByteString;", "kotlin.jvm.PlatformType", "getBYTE_STRING_JSON_ADAPTER$wire_moshi_adapter", "()Lcom/squareup/moshi/JsonAdapter;", "INT_JSON_ADAPTER", "", "getINT_JSON_ADAPTER$wire_moshi_adapter", "LIST_OF_UINT64_JSON_ADAPTER", "", "", "getLIST_OF_UINT64_JSON_ADAPTER$wire_moshi_adapter", "STRING_JSON_ADAPTER", "", "getSTRING_JSON_ADAPTER$wire_moshi_adapter", "UINT64_JSON_ADAPTER", "getUINT64_JSON_ADAPTER$wire_moshi_adapter", "wire-moshi-adapter"})
    public static final class Companion {
        public final JsonAdapter<ByteString> getBYTE_STRING_JSON_ADAPTER$wire_moshi_adapter() {
            return BYTE_STRING_JSON_ADAPTER;
        }

        public final JsonAdapter<Long> getUINT64_JSON_ADAPTER$wire_moshi_adapter() {
            return UINT64_JSON_ADAPTER;
        }

        public final JsonAdapter<Integer> getINT_JSON_ADAPTER$wire_moshi_adapter() {
            return INT_JSON_ADAPTER;
        }

        public final JsonAdapter<String> getSTRING_JSON_ADAPTER$wire_moshi_adapter() {
            return STRING_JSON_ADAPTER;
        }

        public final JsonAdapter<List<Long>> getLIST_OF_UINT64_JSON_ADAPTER$wire_moshi_adapter() {
            return LIST_OF_UINT64_JSON_ADAPTER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

