/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.wire.FieldBinding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.Uint64;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class MessageJsonAdapter<M extends Message<M, B>, B extends Message.Builder<M, B>>
extends JsonAdapter<M> {
    private final RuntimeMessageAdapter<M, B> messageAdapter;
    private final FieldBinding<M, B>[] fieldBindings;
    private final JsonReader.Options options;
    private final JsonAdapter<?>[] jsonAdapters;

    MessageJsonAdapter(Moshi moshi, Type type) {
        int i;
        this.messageAdapter = RuntimeMessageAdapter.create((Class)((Class)type));
        this.fieldBindings = this.messageAdapter.fieldBindings().values().toArray(new FieldBinding[this.messageAdapter.fieldBindings().size()]);
        String[] names = new String[this.fieldBindings.length];
        for (i = 0; i < this.fieldBindings.length; ++i) {
            names[i] = this.fieldBindings[i].name;
        }
        this.options = JsonReader.Options.of((String[])names);
        this.jsonAdapters = new JsonAdapter[this.fieldBindings.length];
        for (i = 0; i < this.fieldBindings.length; ++i) {
            FieldBinding<M, B> fieldBinding = this.fieldBindings[i];
            Type fieldType = fieldBinding.singleAdapter().javaType;
            if (fieldBinding.isMap()) {
                Class keyType = fieldBinding.keyAdapter().javaType;
                fieldType = Types.newParameterizedType(Map.class, (Type[])new Type[]{keyType, fieldType});
            } else if (fieldBinding.label.isRepeated()) {
                fieldType = Types.newParameterizedType(List.class, (Type[])new Type[]{fieldType});
            }
            Class[] qualifiers = new Class[]{};
            if (fieldBinding.singleAdapter() == ProtoAdapter.UINT64) {
                qualifiers = new Class[]{Uint64.class};
            }
            this.jsonAdapters[i] = moshi.adapter(fieldType, qualifiers);
        }
    }

    public void toJson(JsonWriter out, @Nullable M message) throws IOException {
        if (message == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (int i = 0; i < this.fieldBindings.length; ++i) {
            FieldBinding<M, B> fieldBinding = this.fieldBindings[i];
            out.name(fieldBinding.name);
            Object value = fieldBinding.get(message);
            this.jsonAdapters[i].toJson(out, value);
        }
        out.endObject();
    }

    @Nullable
    public M fromJson(JsonReader in) throws IOException {
        if (in.peek() == JsonReader.Token.NULL) {
            in.nextNull();
            return null;
        }
        Message.Builder builder = this.messageAdapter.newBuilder();
        in.beginObject();
        while (in.hasNext()) {
            int index = in.selectName(this.options);
            if (index == -1) {
                in.skipName();
                in.skipValue();
                continue;
            }
            FieldBinding<M, B> fieldBinding = this.fieldBindings[index];
            if (fieldBinding == null) {
                in.skipValue();
                continue;
            }
            Object value = this.jsonAdapters[index].fromJson(in);
            if (value == null) continue;
            fieldBinding.set(builder, value);
        }
        in.endObject();
        return (M)builder.build();
    }
}

