/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireEnumConstant;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.java.AdapterConstant;
import com.squareup.wire.java.Profile;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.JvmLanguages;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public final class JavaGenerator {
    static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    static final ClassName STRING = ClassName.get(String.class);
    static final ClassName LIST = ClassName.get(List.class);
    static final ClassName MESSAGE = ClassName.get(Message.class);
    static final ClassName ANDROID_MESSAGE = MESSAGE.peerClass("AndroidMessage");
    static final ClassName ADAPTER = ClassName.get(ProtoAdapter.class);
    static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    static final ClassName ENUM_ADAPTER = ClassName.get(EnumAdapter.class);
    static final ClassName NULLABLE = ClassName.get((String)"androidx.annotation", (String)"Nullable", (String[])new String[0]);
    static final ClassName CREATOR = ClassName.get((String)"android.os", (String)"Parcelable", (String[])new String[]{"Creator"});
    private static final Ordering<Field> TAG_ORDERING = Ordering.from((Comparator)new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return Integer.compare(o1.getTag(), o2.getTag());
        }
    });
    private static final Map<ProtoType, TypeName> BUILT_IN_TYPES_MAP = ImmutableMap.builder().put((Object)ProtoType.BOOL, (Object)TypeName.BOOLEAN).put((Object)ProtoType.BYTES, (Object)ClassName.get(ByteString.class)).put((Object)ProtoType.DOUBLE, (Object)TypeName.DOUBLE).put((Object)ProtoType.FLOAT, (Object)TypeName.FLOAT).put((Object)ProtoType.FIXED32, (Object)TypeName.INT).put((Object)ProtoType.FIXED64, (Object)TypeName.LONG).put((Object)ProtoType.INT32, (Object)TypeName.INT).put((Object)ProtoType.INT64, (Object)TypeName.LONG).put((Object)ProtoType.SFIXED32, (Object)TypeName.INT).put((Object)ProtoType.SFIXED64, (Object)TypeName.LONG).put((Object)ProtoType.SINT32, (Object)TypeName.INT).put((Object)ProtoType.SINT64, (Object)TypeName.LONG).put((Object)ProtoType.STRING, (Object)ClassName.get(String.class)).put((Object)ProtoType.UINT32, (Object)TypeName.INT).put((Object)ProtoType.UINT64, (Object)TypeName.LONG).put((Object)ProtoType.ANY, (Object)ClassName.get((String)"com.squareup.wire", (String)"AnyMessage", (String[])new String[0])).put((Object)ProtoType.DURATION, (Object)ClassName.get((String)"java.time", (String)"Duration", (String[])new String[0])).put((Object)ProtoType.TIMESTAMP, (Object)ClassName.get((String)"java.time", (String)"Instant", (String[])new String[0])).put((Object)ProtoType.EMPTY, (Object)ClassName.get((String)"kotlin", (String)"Unit", (String[])new String[0])).put((Object)ProtoType.STRUCT_MAP, (Object)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]), WildcardTypeName.subtypeOf(Object.class)})).put((Object)ProtoType.STRUCT_VALUE, (Object)ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0])).put((Object)ProtoType.STRUCT_NULL, (Object)ClassName.get((String)"java.lang", (String)"Void", (String[])new String[0])).put((Object)ProtoType.STRUCT_LIST, (Object)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).put((Object)ProtoType.DOUBLE_VALUE, (Object)TypeName.DOUBLE).put((Object)ProtoType.FLOAT_VALUE, (Object)TypeName.FLOAT).put((Object)ProtoType.INT64_VALUE, (Object)TypeName.LONG).put((Object)ProtoType.UINT64_VALUE, (Object)TypeName.LONG).put((Object)ProtoType.INT32_VALUE, (Object)TypeName.INT).put((Object)ProtoType.UINT32_VALUE, (Object)TypeName.INT).put((Object)ProtoType.BOOL_VALUE, (Object)TypeName.BOOLEAN).put((Object)ProtoType.STRING_VALUE, (Object)ClassName.get(String.class)).put((Object)ProtoType.BYTES_VALUE, (Object)ClassName.get(ByteString.class)).put((Object)Options.FIELD_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"FieldOptions", (String[])new String[0])).put((Object)Options.ENUM_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"EnumOptions", (String[])new String[0])).put((Object)Options.MESSAGE_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"MessageOptions", (String[])new String[0])).build();
    private static final Map<ProtoType, CodeBlock> PROTOTYPE_TO_IDENTITY_VALUES = ImmutableMap.builder().put((Object)ProtoType.BOOL, (Object)CodeBlock.of((String)"false", (Object[])new Object[0])).put((Object)ProtoType.STRING, (Object)CodeBlock.of((String)"\"\"", (Object[])new Object[0])).put((Object)ProtoType.BYTES, (Object)CodeBlock.of((String)"$T.$L", (Object[])new Object[]{ByteString.class, "EMPTY"})).put((Object)ProtoType.DOUBLE, (Object)CodeBlock.of((String)"0.0", (Object[])new Object[0])).put((Object)ProtoType.FLOAT, (Object)CodeBlock.of((String)"0f", (Object[])new Object[0])).put((Object)ProtoType.FIXED64, (Object)CodeBlock.of((String)"0L", (Object[])new Object[0])).put((Object)ProtoType.INT64, (Object)CodeBlock.of((String)"0L", (Object[])new Object[0])).put((Object)ProtoType.SFIXED64, (Object)CodeBlock.of((String)"0L", (Object[])new Object[0])).put((Object)ProtoType.SINT64, (Object)CodeBlock.of((String)"0L", (Object[])new Object[0])).put((Object)ProtoType.UINT64, (Object)CodeBlock.of((String)"0L", (Object[])new Object[0])).put((Object)ProtoType.FIXED32, (Object)CodeBlock.of((String)"0", (Object[])new Object[0])).put((Object)ProtoType.INT32, (Object)CodeBlock.of((String)"0", (Object[])new Object[0])).put((Object)ProtoType.SFIXED32, (Object)CodeBlock.of((String)"0", (Object[])new Object[0])).put((Object)ProtoType.SINT32, (Object)CodeBlock.of((String)"0", (Object[])new Object[0])).put((Object)ProtoType.UINT32, (Object)CodeBlock.of((String)"0", (Object[])new Object[0])).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private static final int MAX_PARAMS_IN_CONSTRUCTOR = 16;
    private final LoadingCache<Type, NameAllocator> nameAllocators = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Type, NameAllocator>(){

        public NameAllocator load(Type type) throws Exception {
            NameAllocator nameAllocator;
            block4: {
                block3: {
                    nameAllocator = new NameAllocator();
                    if (!(type instanceof MessageType)) break block3;
                    nameAllocator.newName("serialVersionUID", (Object)"serialVersionUID");
                    nameAllocator.newName("ADAPTER", (Object)"ADAPTER");
                    nameAllocator.newName("MESSAGE_OPTIONS", (Object)"MESSAGE_OPTIONS");
                    if (JavaGenerator.this.emitAndroid) {
                        nameAllocator.newName("CREATOR", (Object)"CREATOR");
                    }
                    List fieldsAndOneOfFields = ((MessageType)type).getFieldsAndOneOfFields();
                    Set collidingNames = JavaGenerator.this.collidingFieldNames(fieldsAndOneOfFields);
                    for (Field field : fieldsAndOneOfFields) {
                        String suggestion = collidingNames.contains(field.getName()) || JavaGenerator.this.schema.getType(field.getQualifiedName()) != null ? field.getQualifiedName() : field.getName();
                        nameAllocator.newName(suggestion, (Object)field);
                    }
                    break block4;
                }
                if (!(type instanceof EnumType)) break block4;
                nameAllocator.newName("value", (Object)"value");
                nameAllocator.newName("i", (Object)"i");
                nameAllocator.newName("reader", (Object)"reader");
                nameAllocator.newName("writer", (Object)"writer");
                for (EnumConstant constant : ((EnumType)type).getConstants()) {
                    nameAllocator.newName(constant.getName(), (Object)constant);
                }
            }
            return nameAllocator;
        }
    });
    private final Schema schema;
    private final ImmutableMap<ProtoType, TypeName> typeToJavaName;
    private final ImmutableMap<ProtoMember, TypeName> memberToJavaName;
    private final Profile profile;
    private final boolean emitAndroid;
    private final boolean emitAndroidAnnotations;
    private final boolean emitCompact;
    private final boolean emitDeclaredOptions;
    private final boolean emitAppliedOptions;

    private JavaGenerator(Schema schema, Map<ProtoType, TypeName> typeToJavaName, Map<ProtoMember, TypeName> memberToJavaName, Profile profile, boolean emitAndroid, boolean emitAndroidAnnotations, boolean emitCompact, boolean emitDeclaredOptions, boolean emitAppliedOptions) {
        this.schema = schema;
        this.typeToJavaName = ImmutableMap.copyOf(typeToJavaName);
        this.memberToJavaName = ImmutableMap.copyOf(memberToJavaName);
        this.profile = profile;
        this.emitAndroid = emitAndroid;
        this.emitAndroidAnnotations = emitAndroidAnnotations;
        this.emitCompact = emitCompact;
        this.emitDeclaredOptions = emitDeclaredOptions;
        this.emitAppliedOptions = emitAppliedOptions;
    }

    public JavaGenerator withAndroid(boolean emitAndroid) {
        return new JavaGenerator(this.schema, (Map<ProtoType, TypeName>)this.typeToJavaName, (Map<ProtoMember, TypeName>)this.memberToJavaName, this.profile, emitAndroid, this.emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions);
    }

    public JavaGenerator withAndroidAnnotations(boolean emitAndroidAnnotations) {
        return new JavaGenerator(this.schema, (Map<ProtoType, TypeName>)this.typeToJavaName, (Map<ProtoMember, TypeName>)this.memberToJavaName, this.profile, this.emitAndroid, emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions);
    }

    public JavaGenerator withCompact(boolean emitCompact) {
        return new JavaGenerator(this.schema, (Map<ProtoType, TypeName>)this.typeToJavaName, (Map<ProtoMember, TypeName>)this.memberToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions);
    }

    public JavaGenerator withProfile(Profile profile) {
        return new JavaGenerator(this.schema, (Map<ProtoType, TypeName>)this.typeToJavaName, (Map<ProtoMember, TypeName>)this.memberToJavaName, profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions);
    }

    public JavaGenerator withOptions(boolean emitDeclaredOptions, boolean emitAppliedOptions) {
        return new JavaGenerator(this.schema, (Map<ProtoType, TypeName>)this.typeToJavaName, (Map<ProtoMember, TypeName>)this.memberToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact, emitDeclaredOptions, emitAppliedOptions);
    }

    public static JavaGenerator get(Schema schema) {
        LinkedHashMap<ProtoType, TypeName> nameToJavaName = new LinkedHashMap<ProtoType, TypeName>();
        LinkedHashMap<ProtoMember, TypeName> memberToJavaName = new LinkedHashMap<ProtoMember, TypeName>();
        for (ProtoFile protoFile : schema.getProtoFiles()) {
            String javaPackage = JvmLanguages.javaPackage((ProtoFile)protoFile);
            JavaGenerator.putAll(nameToJavaName, javaPackage, null, protoFile.getTypes());
            for (Service service : protoFile.getServices()) {
                ClassName className = ClassName.get((String)javaPackage, (String)service.type().getSimpleName(), (String[])new String[0]);
                nameToJavaName.put(service.type(), (TypeName)className);
            }
            for (Extend extend : protoFile.getExtendList()) {
                if (JvmLanguages.annotationTargetType((Extend)extend) == null) continue;
                for (Field field : extend.getFields()) {
                    if (!JvmLanguages.eligibleAsAnnotationMember((Schema)schema, (Field)field)) continue;
                    ProtoMember protoMember = field.getMember();
                    String simpleName = _PlatformKt.camelCase((String)protoMember.getSimpleName(), (boolean)true) + "Option";
                    ClassName className = ClassName.get((String)javaPackage, (String)simpleName, (String[])new String[0]);
                    memberToJavaName.put(protoMember, (TypeName)className);
                }
            }
        }
        nameToJavaName.putAll(BUILT_IN_TYPES_MAP);
        return new JavaGenerator(schema, nameToJavaName, memberToJavaName, new Profile(), false, false, false, false, false);
    }

    private static void putAll(Map<ProtoType, TypeName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.getType().getSimpleName()) : ClassName.get((String)javaPackage, (String)type.getType().getSimpleName(), (String[])new String[0]);
            wireToJava.put(type.getType(), (TypeName)className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, type.getNestedTypes());
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public TypeName typeName(ProtoType protoType) {
        TypeName profileJavaName = this.profile.javaTarget(protoType);
        if (profileJavaName != null) {
            return profileJavaName;
        }
        TypeName candidate = (TypeName)this.typeToJavaName.get((Object)protoType);
        Preconditions.checkArgument((candidate != null ? 1 : 0) != 0, (String)"unexpected type %s", (Object)protoType);
        return candidate;
    }

    @Nullable
    public ClassName abstractAdapterName(ProtoType protoType) {
        ClassName javaName;
        TypeName profileJavaName = this.profile.javaTarget(protoType);
        if (profileJavaName == null) {
            return null;
        }
        TypeName typeName = (TypeName)this.typeToJavaName.get((Object)protoType);
        Type type = this.schema.getType(protoType);
        if (typeName instanceof ClassName) {
            javaName = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            javaName = ((ParameterizedTypeName)typeName).rawType;
        } else {
            throw new IllegalArgumentException("Unexpected typeName :" + typeName);
        }
        return type instanceof EnumType ? javaName.peerClass(javaName.simpleName() + "Adapter") : javaName.peerClass("Abstract" + javaName.simpleName() + "Adapter");
    }

    private CodeBlock singleAdapterFor(Field field, NameAllocator nameAllocator) {
        return field.getType().isMap() ? CodeBlock.of((String)"$NAdapter()", (Object[])new Object[]{nameAllocator.get((Object)field)}) : this.singleAdapterFor(field.getType());
    }

    private CodeBlock singleAdapterFor(ProtoType type) {
        CodeBlock.Builder result = CodeBlock.builder();
        if (type.isScalar()) {
            result.add("$T.$L", new Object[]{ADAPTER, type.getSimpleName().toUpperCase(Locale.US)});
        } else if (type.equals((Object)ProtoType.DURATION)) {
            result.add("$T.$L", new Object[]{ADAPTER, "DURATION"});
        } else if (type.equals((Object)ProtoType.TIMESTAMP)) {
            result.add("$T.$L", new Object[]{ADAPTER, "INSTANT"});
        } else if (type.equals((Object)ProtoType.EMPTY)) {
            result.add("$T.$L", new Object[]{ADAPTER, "EMPTY"});
        } else if (type.equals((Object)ProtoType.STRUCT_MAP)) {
            result.add("$T.$L", new Object[]{ADAPTER, "STRUCT_MAP"});
        } else if (type.equals((Object)ProtoType.STRUCT_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "STRUCT_VALUE"});
        } else if (type.equals((Object)ProtoType.STRUCT_NULL)) {
            result.add("$T.$L", new Object[]{ADAPTER, "STRUCT_NULL"});
        } else if (type.equals((Object)ProtoType.STRUCT_LIST)) {
            result.add("$T.$L", new Object[]{ADAPTER, "STRUCT_LIST"});
        } else if (type.equals((Object)ProtoType.DOUBLE_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "DOUBLE_VALUE"});
        } else if (type.equals((Object)ProtoType.FLOAT_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "FLOAT_VALUE"});
        } else if (type.equals((Object)ProtoType.INT64_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "INT64_VALUE"});
        } else if (type.equals((Object)ProtoType.UINT64_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "UINT64_VALUE"});
        } else if (type.equals((Object)ProtoType.INT32_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "INT32_VALUE"});
        } else if (type.equals((Object)ProtoType.UINT32_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "UINT32_VALUE"});
        } else if (type.equals((Object)ProtoType.BOOL_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "BOOL_VALUE"});
        } else if (type.equals((Object)ProtoType.STRING_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "STRING_VALUE"});
        } else if (type.equals((Object)ProtoType.BYTES_VALUE)) {
            result.add("$T.$L", new Object[]{ADAPTER, "BYTES_VALUE"});
        } else {
            if (type.isMap()) {
                throw new IllegalArgumentException("Cannot create single adapter for map type " + type);
            }
            AdapterConstant adapterConstant = this.profile.getAdapter(type);
            if (adapterConstant != null) {
                result.add("$T.$L", new Object[]{adapterConstant.javaClassName, adapterConstant.memberName});
            } else {
                result.add("$T.ADAPTER", new Object[]{this.typeName(type)});
            }
        }
        return result.build();
    }

    private CodeBlock adapterFor(Field field, NameAllocator nameAllocator) {
        CodeBlock.Builder result = this.singleAdapterFor(field, nameAllocator).toBuilder();
        if (field.isPacked()) {
            result.add(".asPacked()", new Object[0]);
        } else if (field.isRepeated()) {
            result.add(".asRepeated()", new Object[0]);
        }
        return result.build();
    }

    public boolean isEnum(ProtoType type) {
        return this.schema.getType(type) instanceof EnumType;
    }

    EnumConstant enumDefault(ProtoType type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return (EnumConstant)wireEnum.getConstants().get(0);
    }

    static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{type});
    }

    static TypeName messageOf(ClassName messageType, TypeName type, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)messageType, (TypeName[])new TypeName[]{type, builderType});
    }

    static TypeName adapterOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)ADAPTER, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName builderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)BUILDER, (TypeName[])new TypeName[]{messageType, builderType});
    }

    static TypeName creatorOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)CREATOR, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName enumAdapterOf(TypeName enumType) {
        return ParameterizedTypeName.get((ClassName)ENUM_ADAPTER, (TypeName[])new TypeName[]{enumType});
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("\\*/", "&#42;/");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public ClassName generatedTypeName(Type type) {
        ClassName abstractAdapterName = this.abstractAdapterName(type.getType());
        return abstractAdapterName != null ? abstractAdapterName : (ClassName)this.typeName(type.getType());
    }

    public TypeSpec generateType(Type type) {
        AdapterConstant adapterConstant = this.profile.getAdapter(type.getType());
        if (adapterConstant != null) {
            return this.generateAdapterForCustomType(type);
        }
        if (type instanceof MessageType) {
            return this.generateMessage((MessageType)type);
        }
        if (type instanceof EnumType) {
            return this.generateEnum((EnumType)type);
        }
        if (type instanceof EnclosingType) {
            return this.generateEnclosingType((EnclosingType)type);
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    private TypeSpec generateEnum(EnumType type) {
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        String value = nameAllocator.get((Object)"value");
        ClassName javaType = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(WireEnum.class);
        if (!type.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.getDocumentation())});
        }
        for (AnnotationSpec annotation : this.optionAnnotations(type.getOptions())) {
            builder.addAnnotation(annotation);
        }
        if (type.isDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        builder.addField(TypeName.INT, value, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addMethod(MethodSpec.constructorBuilder().addStatement("this.$1N = $1N", new Object[]{value}).addParameter(TypeName.INT, value, new Modifier[0]).build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder((String)"fromValue").addJavadoc("Return the constant for {@code $N} or null.\n", new Object[]{value}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)javaType).addParameter(Integer.TYPE, value, new Modifier[0]).beginControlFlow("switch ($N)", new Object[]{value});
        LinkedHashSet<Integer> seenTags = new LinkedHashSet<Integer>();
        for (EnumConstant constant : type.getConstants()) {
            TypeSpec.Builder constantBuilder = TypeSpec.anonymousClassBuilder((String)"$L", (Object[])new Object[]{constant.getTag()});
            if (!constant.getDocumentation().isEmpty()) {
                constantBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.getDocumentation())});
            }
            for (AnnotationSpec annotation : this.optionAnnotations(constant.getOptions())) {
                constantBuilder.addAnnotation(annotation);
            }
            AnnotationSpec wireEnumConstantAnnotation = this.wireEnumConstantAnnotation(nameAllocator, constant);
            if (wireEnumConstantAnnotation != null) {
                constantBuilder.addAnnotation(wireEnumConstantAnnotation);
            }
            if (constant.isDeprecated()) {
                constantBuilder.addAnnotation(Deprecated.class);
            }
            builder.addEnumConstant(nameAllocator.get((Object)constant), constantBuilder.build());
            if (!seenTags.add(constant.getTag())) continue;
            fromValueBuilder.addStatement("case $L: return $L", new Object[]{constant.getTag(), nameAllocator.get((Object)constant)});
        }
        builder.addMethod(fromValueBuilder.addStatement("default: return null", new Object[0]).endControlFlow().build());
        FieldSpec.Builder adapterBuilder = FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)"ADAPTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        ClassName adapterJavaType = javaType.nestedClass("ProtoAdapter_" + javaType.simpleName());
        if (!this.emitCompact) {
            adapterBuilder.initializer("new $T()", new Object[]{adapterJavaType});
        } else {
            adapterBuilder.initializer("$T.newEnumAdapter($T.class)", new Object[]{ProtoAdapter.class, javaType});
        }
        builder.addField(adapterBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return $N", new Object[]{value}).build());
        if (!this.emitCompact) {
            builder.addType(this.enumAdapter(javaType, adapterJavaType, type));
        }
        return builder.build();
    }

    private TypeSpec generateMessage(MessageType type) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        ClassName javaType = (ClassName)this.typeName(type.getType());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!type.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.getDocumentation())});
        }
        for (AnnotationSpec annotation : this.optionAnnotations(type.getOptions())) {
            builder.addAnnotation(annotation);
        }
        if (type.isDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        ClassName messageType = this.emitAndroid ? ANDROID_MESSAGE : MESSAGE;
        builder.superclass(JavaGenerator.messageOf(messageType, (TypeName)javaType, builderJavaType));
        String adapterName = nameAllocator.get((Object)"ADAPTER");
        String protoAdapterName = "ProtoAdapter_" + javaType.simpleName();
        String protoAdapterClassName = nameAllocator.newName(protoAdapterName);
        ClassName adapterJavaType = javaType.nestedClass(protoAdapterClassName);
        builder.addField(this.messageAdapterField(adapterName, javaType, adapterJavaType, type.getType(), type.getSyntax()));
        if (this.emitAndroid) {
            TypeName creatorType = JavaGenerator.creatorOf((TypeName)javaType);
            String creatorName = nameAllocator.get((Object)"CREATOR");
            builder.addField(FieldSpec.builder((TypeName)creatorType, (String)creatorName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.newCreator($L)", new Object[]{ANDROID_MESSAGE, adapterName}).build());
        }
        builder.addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)nameAllocator.get((Object)"serialVersionUID"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$LL", new Object[]{0L}).build());
        for (Field field : type.getFieldsAndOneOfFields()) {
            TypeName fieldJavaType = this.fieldType(field);
            Field.EncodeMode encodeMode = field.getEncodeMode();
            if ((field.getType().isScalar() || this.isEnum(field.getType())) && !field.getType().equals((Object)ProtoType.STRUCT_NULL) && encodeMode != Field.EncodeMode.REPEATED && encodeMode != Field.EncodeMode.PACKED && encodeMode != Field.EncodeMode.OMIT_IDENTITY) {
                builder.addField(this.defaultField(nameAllocator, field, fieldJavaType));
            }
            String fieldName = nameAllocator.get((Object)field);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldJavaType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (!field.getDocumentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.getDocumentation())});
            }
            for (AnnotationSpec annotation : this.optionAnnotations(field.getOptions())) {
                fieldBuilder.addAnnotation(annotation);
            }
            fieldBuilder.addAnnotation(this.wireFieldAnnotation(nameAllocator, field, type));
            if (field.isExtension()) {
                fieldBuilder.addJavadoc("Extension source: $L\n", new Object[]{field.getLocation().withPathOnly()});
            }
            if (field.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            if (this.emitAndroidAnnotations && encodeMode == Field.EncodeMode.NULL_IF_ABSENT) {
                fieldBuilder.addAnnotation(NULLABLE);
            }
            builder.addField(fieldBuilder.build());
        }
        if (constructorTakesAllFields) {
            builder.addMethod(this.messageFieldsConstructor(nameAllocator, type));
        }
        builder.addMethod(this.messageConstructor(nameAllocator, type, builderJavaType));
        builder.addMethod(this.newBuilder(nameAllocator, type));
        builder.addMethod(this.messageEquals(nameAllocator, type));
        builder.addMethod(this.messageHashCode(nameAllocator, type));
        if (!this.emitCompact) {
            builder.addMethod(this.messageToString(nameAllocator, type));
        }
        builder.addType(this.builder(nameAllocator, type, javaType, builderJavaType));
        for (Type nestedType : type.getNestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        if (!this.emitCompact) {
            builder.addType(this.messageAdapter(nameAllocator, type, javaType, adapterJavaType, builderJavaType));
        }
        return builder.build();
    }

    private boolean constructorTakesAllFields(MessageType type) {
        return type.fields().size() < 16;
    }

    private TypeSpec generateEnclosingType(EnclosingType type) {
        String documentation;
        ClassName javaType = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!(documentation = type.getDocumentation()).isEmpty()) {
            documentation = documentation + "\n\n<p>";
        }
        documentation = documentation + "<b>NOTE:</b> This type only exists to maintain class structure for its nested types and is not an actual message.";
        builder.addJavadoc("$L\n", new Object[]{documentation});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("throw new $T()", new Object[]{AssertionError.class}).build());
        for (Type nestedType : type.getNestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        return builder.build();
    }

    public TypeSpec generateAdapterForCustomType(Type type) {
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        ClassName adapterTypeName = this.abstractAdapterName(type.getType());
        ClassName typeName = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder adapter = type instanceof MessageType ? this.messageAdapter(nameAllocator, (MessageType)type, typeName, adapterTypeName, null).toBuilder() : this.enumAdapter(nameAllocator, (EnumType)type, typeName, adapterTypeName).toBuilder();
        if (adapterTypeName.enclosingClassName() != null) {
            adapter.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        for (Type nestedType : type.getNestedTypes()) {
            if (this.profile.getAdapter(nestedType.getType()) == null) {
                throw new IllegalArgumentException("Missing custom proto adapter for " + nestedType.getType().getEnclosingTypeOrPackage() + "." + nestedType.getType().getSimpleName() + " when enclosing proto has custom proto adapter.");
            }
            adapter.addType(this.generateAdapterForCustomType(nestedType));
        }
        return adapter.build();
    }

    private Set<String> collidingFieldNames(List<Field> fields) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> collidingNames = new LinkedHashSet<String>();
        for (Field field : fields) {
            if (fieldNames.add(field.getName())) continue;
            collidingNames.add(field.getName());
        }
        return collidingNames;
    }

    private FieldSpec messageAdapterField(String adapterName, ClassName javaType, ClassName adapterJavaType, ProtoType protoType, Syntax syntax) {
        FieldSpec.Builder result = FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)adapterName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        if (this.emitCompact) {
            result.initializer("$T.newMessageAdapter($T.class, $S, $T.$L)", new Object[]{ProtoAdapter.class, javaType, protoType.getTypeUrl(), Syntax.class, syntax.name()});
        } else {
            result.initializer("new $T()", new Object[]{adapterJavaType});
        }
        return result.build();
    }

    private TypeSpec enumAdapter(NameAllocator nameAllocator, EnumType type, ClassName javaType, ClassName adapterJavaType) {
        String value = nameAllocator.get((Object)"value");
        String i = nameAllocator.get((Object)"i");
        String reader = nameAllocator.get((Object)"reader");
        String writer = nameAllocator.get((Object)"writer");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)adapterJavaType.simpleName());
        builder.superclass(JavaGenerator.adapterOf((TypeName)javaType));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($T.VARINT, $T.class)", new Object[]{FieldEncoding.class, javaType});
        for (Object constant : type.getConstants()) {
            String name = nameAllocator.get(constant);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)javaType, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL});
            if (!constant.getDocumentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.getDocumentation())});
            }
            if (constant.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            builder.addField(fieldBuilder.build());
            constructorBuilder.addParameter((TypeName)javaType, name, new Modifier[0]);
            constructorBuilder.addStatement("this.$N = $N", new Object[]{name, name});
        }
        builder.addMethod(constructorBuilder.build());
        MethodSpec.Builder toValueBuilder = MethodSpec.methodBuilder((String)"toValue").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Integer.TYPE).addParameter((TypeName)javaType, value, new Modifier[0]);
        for (EnumConstant constant : type.getConstants()) {
            String name = nameAllocator.get((Object)constant);
            toValueBuilder.addStatement("if ($N.equals($N)) return $L", new Object[]{value, name, constant.getTag()});
        }
        toValueBuilder.addStatement("return $L", new Object[]{-1});
        builder.addMethod(toValueBuilder.build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder((String)"fromValue").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)javaType).addParameter(Integer.TYPE, value, new Modifier[0]);
        fromValueBuilder.beginControlFlow("switch ($N)", new Object[]{value});
        for (EnumConstant constant : type.getConstants()) {
            String name = nameAllocator.get((Object)constant);
            fromValueBuilder.addStatement("case $L: return $N", new Object[]{constant.getTag(), name});
        }
        fromValueBuilder.addStatement("default: throw new $T($N, $T.class)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class, value, javaType});
        fromValueBuilder.endControlFlow();
        builder.addMethod(fromValueBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"encodedSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addParameter((TypeName)javaType, value, new Modifier[0]).addStatement("return $T.UINT32.encodedSize(toValue($N))", new Object[]{ProtoAdapter.class, value}).build());
        builder.addMethod(this.enumEncode(javaType, value, i, writer, false));
        builder.addMethod(this.enumEncode(javaType, value, i, writer, true));
        builder.addMethod(MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter(ProtoReader.class, reader, new Modifier[0]).addException(IOException.class).addStatement("int $N = $N.readVarint32()", new Object[]{value, reader}).addStatement("return fromValue($N)", new Object[]{value}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"redact").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter((TypeName)javaType, "value", new Modifier[0]).addStatement("return value", new Object[0]).build());
        return builder.build();
    }

    private MethodSpec enumEncode(ClassName javaType, String value, String localInt, String localWriter, boolean reverse) {
        return MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(reverse ? ReverseProtoWriter.class : ProtoWriter.class, localWriter, new Modifier[0]).addParameter((TypeName)javaType, value, new Modifier[0]).addException(IOException.class).addStatement("int $N = toValue($N)", new Object[]{localInt, value}).addStatement("if ($N == $L) throw new $T($S + $N)", new Object[]{localInt, -1, ProtocolException.class, "Unexpected enum constant: ", value}).addStatement("$N.writeVarint32($N)", new Object[]{localWriter, localInt}).build();
    }

    private TypeSpec enumAdapter(ClassName javaType, ClassName adapterJavaType, EnumType enumType) {
        return TypeSpec.classBuilder((String)adapterJavaType.simpleName()).superclass(JavaGenerator.enumAdapterOf((TypeName)javaType)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addStatement("super($T.class, $T.$L, $L)", new Object[]{javaType, Syntax.class, enumType.getSyntax().name(), this.identity(enumType)}).build()).addMethod(MethodSpec.methodBuilder((String)"fromValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)javaType).addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("return $T.fromValue(value)", new Object[]{javaType}).build()).build();
    }

    private TypeSpec messageAdapter(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName adapterJavaType, ClassName builderType) {
        boolean useBuilder = builderType != null;
        TypeSpec.Builder adapter = TypeSpec.classBuilder((String)adapterJavaType.simpleName()).superclass(JavaGenerator.adapterOf((TypeName)javaType));
        if (useBuilder) {
            adapter.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        } else {
            adapter.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        }
        adapter.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.LENGTH_DELIMITED, $T.class, $S, $T.$L, null)", new Object[]{FieldEncoding.class, javaType, type.getType().getTypeUrl(), Syntax.class, type.getSyntax().name()}).build());
        if (!useBuilder) {
            MethodSpec.Builder fromProto = MethodSpec.methodBuilder((String)"fromProto").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)javaType);
            for (Field field : type.getFieldsAndOneOfFields()) {
                TypeName fieldType = this.fieldType(field);
                String fieldName = nameAllocator.get((Object)field);
                fromProto.addParameter(fieldType, fieldName, new Modifier[0]);
                adapter.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)javaType, "value", new Modifier[0]).returns(fieldType).build());
            }
            adapter.addMethod(fromProto.build());
        }
        adapter.addMethod(this.messageAdapterEncodedSize(nameAllocator, type, (TypeName)javaType, useBuilder));
        adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, (TypeName)javaType, useBuilder, false));
        adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, (TypeName)javaType, useBuilder, true));
        adapter.addMethod(this.messageAdapterDecode(nameAllocator, type, (TypeName)javaType, useBuilder, builderType));
        adapter.addMethod(this.messageAdapterRedact(nameAllocator, type, javaType, useBuilder, builderType));
        for (Field field : type.getFieldsAndOneOfFields()) {
            if (!field.getType().isMap()) continue;
            TypeName adapterType = JavaGenerator.adapterOf(this.fieldType(field));
            String fieldName = nameAllocator.get((Object)field);
            adapter.addField(FieldSpec.builder((TypeName)adapterType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            adapter.addMethod(this.mapAdapter(nameAllocator, adapterType, fieldName, field.getType()));
        }
        return adapter.build();
    }

    private MethodSpec messageAdapterEncodedSize(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encodedSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addParameter(javaType, "value", new Modifier[0]);
        String resultName = nameAllocator.clone().newName("result");
        result.addStatement("int $L = 0", new Object[]{resultName});
        for (Field field : type.getFieldsAndOneOfFields()) {
            int fieldTag = field.getTag();
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock adapter = this.adapterFor(field, nameAllocator);
            boolean omitIdentity = field.getEncodeMode().equals((Object)Field.EncodeMode.OMIT_IDENTITY);
            if (omitIdentity) {
                result.beginControlFlow("if (!$T.equals(value.$L, $L))", new Object[]{ClassName.get(Objects.class), fieldName, this.identityValue(field)});
            }
            result.addCode("$L += ", new Object[]{resultName}).addCode("$L.encodedSizeWithTag($L, ", new Object[]{adapter, fieldTag}).addCode(useBuilder ? "value.$L" : "$L(value)", new Object[]{fieldName}).addCode(");\n", new Object[0]);
            if (!omitIdentity) continue;
            result.endControlFlow();
        }
        if (useBuilder) {
            result.addStatement("$L += value.unknownFields().size()", new Object[]{resultName});
        }
        result.addStatement("return $L", new Object[]{resultName});
        return result.build();
    }

    private MethodSpec messageAdapterEncode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder, boolean reverse) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(reverse ? ReverseProtoWriter.class : ProtoWriter.class, "writer", new Modifier[0]).addParameter(javaType, "value", new Modifier[0]).addException(IOException.class);
        ArrayList<CodeBlock> encodeCalls = new ArrayList<CodeBlock>();
        for (Field field : type.getFieldsAndOneOfFields()) {
            int fieldTag = field.getTag();
            CodeBlock adapter = this.adapterFor(field, nameAllocator);
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock.Builder encodeCall = CodeBlock.builder();
            if (field.getEncodeMode().equals((Object)Field.EncodeMode.OMIT_IDENTITY)) {
                encodeCall.add("if (!$T.equals(value.$L, $L)) ", new Object[]{ClassName.get(Objects.class), fieldName, this.identityValue(field)});
            }
            encodeCall.add("$L.encodeWithTag(writer, $L, ", new Object[]{adapter, fieldTag}).add(useBuilder ? "value.$L" : "$L(value)", new Object[]{fieldName}).add(");\n", new Object[0]);
            encodeCalls.add(encodeCall.build());
        }
        if (useBuilder) {
            encodeCalls.add(CodeBlock.builder().addStatement("writer.writeBytes(value.unknownFields())", new Object[0]).build());
        }
        if (reverse) {
            Collections.reverse(encodeCalls);
        }
        for (CodeBlock encodeCall : encodeCalls) {
            result.addCode(encodeCall);
        }
        return result.build();
    }

    private MethodSpec messageAdapterDecode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType).addParameter(ProtoReader.class, "reader", new Modifier[0]).addException(IOException.class);
        List fields = TAG_ORDERING.sortedCopy((Iterable)type.getFieldsAndOneOfFields());
        if (useBuilder) {
            result.addStatement("$1T builder = new $1T()", new Object[]{builderJavaType});
        } else {
            for (Field field : fields) {
                result.addStatement("$T $N = $L", new Object[]{this.fieldType(field), nameAllocator.get((Object)field), this.initialValue(field)});
            }
        }
        result.addStatement("long token = reader.beginMessage()", new Object[0]);
        result.beginControlFlow("for (int tag; (tag = reader.nextTag()) != -1;)", new Object[0]);
        result.beginControlFlow("switch (tag)", new Object[0]);
        for (Field field : fields) {
            int fieldTag = field.getTag();
            if (this.isEnum(field.getType()) && !field.getType().equals((Object)ProtoType.STRUCT_NULL)) {
                result.beginControlFlow("case $L:", new Object[]{fieldTag});
                result.beginControlFlow("try", new Object[0]);
                result.addCode(this.decodeAndAssign(field, nameAllocator, useBuilder));
                result.addCode(";\n", new Object[0]);
                if (useBuilder) {
                    result.nextControlFlow("catch ($T e)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class});
                    result.addStatement("builder.addUnknownField(tag, $T.VARINT, (long) e.value)", new Object[]{FieldEncoding.class});
                    result.endControlFlow();
                } else {
                    result.nextControlFlow("catch ($T ignored)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class});
                    result.endControlFlow();
                }
                result.addStatement("break", new Object[0]);
                result.endControlFlow();
                continue;
            }
            result.addCode("case $L: $L; break;\n", new Object[]{fieldTag, this.decodeAndAssign(field, nameAllocator, useBuilder)});
        }
        result.beginControlFlow("default:", new Object[0]);
        if (useBuilder) {
            result.addStatement("reader.readUnknownField(tag)", new Object[0]);
        } else {
            result.addStatement("reader.skip()", new Object[0]);
        }
        result.endControlFlow();
        result.endControlFlow();
        result.endControlFlow();
        if (useBuilder) {
            result.addStatement("builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token))", new Object[0]);
        } else {
            result.addStatement("reader.endMessageAndGetUnknownFields(token)", new Object[0]);
        }
        if (useBuilder) {
            result.addStatement("return builder.build()", new Object[0]);
        } else {
            result.addCode("return fromProto(", new Object[0]);
            boolean first = true;
            for (Field field : type.getFieldsAndOneOfFields()) {
                if (!first) {
                    result.addCode(", ", new Object[0]);
                }
                result.addCode("$N", new Object[]{nameAllocator.get((Object)field)});
                first = false;
            }
            result.addCode(");\n", new Object[0]);
        }
        return result.build();
    }

    private CodeBlock decodeAndAssign(Field field, NameAllocator nameAllocator, boolean useBuilder) {
        String fieldName = nameAllocator.get((Object)field);
        CodeBlock decode = CodeBlock.of((String)"$L.decode(reader)", (Object[])new Object[]{this.singleAdapterFor(field, nameAllocator)});
        if (field.isRepeated()) {
            return useBuilder ? (field.getType().equals((Object)ProtoType.STRUCT_NULL) ? CodeBlock.of((String)"builder.$L.add(($T) $L)", (Object[])new Object[]{fieldName, Void.class, decode}) : CodeBlock.of((String)"builder.$L.add($L)", (Object[])new Object[]{fieldName, decode})) : CodeBlock.of((String)"$L.add($L)", (Object[])new Object[]{fieldName, decode});
        }
        if (field.getType().isMap()) {
            return useBuilder ? CodeBlock.of((String)"builder.$L.putAll($L)", (Object[])new Object[]{fieldName, decode}) : CodeBlock.of((String)"$L.putAll($L)", (Object[])new Object[]{fieldName, decode});
        }
        return useBuilder ? (field.getType().equals((Object)ProtoType.STRUCT_NULL) ? CodeBlock.of((String)"builder.$L(($T) $L)", (Object[])new Object[]{fieldName, Void.class, decode}) : CodeBlock.of((String)"builder.$L($L)", (Object[])new Object[]{fieldName, decode})) : CodeBlock.of((String)"$L = $L", (Object[])new Object[]{fieldName, decode});
    }

    private MethodSpec messageAdapterRedact(NameAllocator nameAllocator, MessageType type, ClassName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"redact").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter((TypeName)javaType, "value", new Modifier[0]);
        int redactedFieldCount = 0;
        ArrayList<String> requiredRedacted = new ArrayList<String>();
        for (Field field : type.getFieldsAndOneOfFields()) {
            if (!field.isRedacted()) continue;
            ++redactedFieldCount;
            if (!field.isRequired()) continue;
            requiredRedacted.add(nameAllocator.get((Object)field));
        }
        if (!useBuilder) {
            result.addStatement(redactedFieldCount == 0 ? "return value" : "return null", new Object[0]);
            return result.build();
        }
        if (!requiredRedacted.isEmpty()) {
            boolean isPlural = requiredRedacted.size() != 1;
            result.addStatement("throw new $T($S)", new Object[]{UnsupportedOperationException.class, (isPlural ? "Fields" : "Field") + " '" + Joiner.on((String)"', '").join(requiredRedacted) + "' " + (isPlural ? "are" : "is") + " required and cannot be redacted."});
            return result.build();
        }
        result.addStatement("$1T builder = value.newBuilder()", new Object[]{builderJavaType});
        for (Field field : type.getFieldsAndOneOfFields()) {
            CodeBlock adapter;
            String fieldName = nameAllocator.get((Object)field);
            if (field.isRedacted()) {
                if (field.isRepeated()) {
                    result.addStatement("builder.$N = $T.emptyList()", new Object[]{fieldName, Collections.class});
                    continue;
                }
                if (field.getType().isMap()) {
                    result.addStatement("builder.$N = $T.emptyMap()", new Object[]{fieldName, Collections.class});
                    continue;
                }
                result.addStatement("builder.$N = null", new Object[]{fieldName});
                continue;
            }
            if (field.getType().isScalar() || this.isEnum(field.getType())) continue;
            if (field.isRepeated()) {
                adapter = this.singleAdapterFor(field, nameAllocator);
                result.addStatement("$T.redactElements(builder.$N, $L)", new Object[]{Internal.class, fieldName, adapter});
                continue;
            }
            if (field.getType().isMap()) {
                if (field.getType().getValueType().isScalar() || this.isEnum(field.getType().getValueType())) continue;
                adapter = this.singleAdapterFor(field.getType().getValueType());
                result.addStatement("$T.redactElements(builder.$N, $L)", new Object[]{Internal.class, fieldName, adapter});
                continue;
            }
            adapter = this.adapterFor(field, nameAllocator);
            if (!field.isRequired()) {
                result.addCode("if (builder.$N != null) ", new Object[]{fieldName});
            }
            result.addStatement("builder.$1N = $2L.redact(builder.$1N)", new Object[]{fieldName, adapter});
        }
        result.addStatement("builder.clearUnknownFields()", new Object[0]);
        result.addStatement("return builder.build()", new Object[0]);
        return result.build();
    }

    private String fieldName(ProtoType type, Field field) {
        MessageType messageType = (MessageType)this.schema.getType(type);
        NameAllocator names = (NameAllocator)this.nameAllocators.getUnchecked((Object)messageType);
        return names.get((Object)field);
    }

    private TypeName fieldType(Field field) {
        ProtoType type = field.getType();
        if (type.isMap()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.typeName(type.getKeyType()).box(), this.typeName(type.getValueType()).box()});
        }
        TypeName messageType = this.typeName(type);
        switch (field.getEncodeMode()) {
            case REPEATED: 
            case PACKED: {
                return JavaGenerator.listOf(messageType.box());
            }
            case NULL_IF_ABSENT: 
            case REQUIRED: {
                return messageType.box();
            }
        }
        if (this.isWrapper(field.getType())) {
            return messageType.box();
        }
        return messageType;
    }

    private FieldSpec defaultField(NameAllocator nameAllocator, Field field, TypeName fieldType) {
        String defaultFieldName = "DEFAULT_" + nameAllocator.get((Object)field).toUpperCase(Locale.US);
        return FieldSpec.builder((TypeName)fieldType, (String)defaultFieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(this.defaultValue(field)).build();
    }

    private AnnotationSpec wireFieldAnnotation(NameAllocator nameAllocator, Field field, MessageType message) {
        String generatedName;
        WireField.Label wireFieldLabel;
        AnnotationSpec.Builder result = AnnotationSpec.builder(WireField.class);
        NameAllocator localNameAllocator = nameAllocator.clone();
        int tag = field.getTag();
        result.addMember("tag", String.valueOf(tag), new Object[0]);
        if (field.getType().isMap()) {
            result.addMember("keyAdapter", "$S", new Object[]{this.adapterString(field.getType().getKeyType())});
            result.addMember("adapter", "$S", new Object[]{this.adapterString(field.getType().getValueType())});
        } else {
            result.addMember("adapter", "$S", new Object[]{this.adapterString(field.getType())});
        }
        switch (field.getEncodeMode()) {
            case REQUIRED: {
                wireFieldLabel = WireField.Label.REQUIRED;
                break;
            }
            case OMIT_IDENTITY: {
                wireFieldLabel = WireField.Label.OMIT_IDENTITY;
                break;
            }
            case REPEATED: {
                wireFieldLabel = WireField.Label.REPEATED;
                break;
            }
            case PACKED: {
                wireFieldLabel = WireField.Label.PACKED;
                break;
            }
            default: {
                wireFieldLabel = null;
            }
        }
        if (wireFieldLabel != null) {
            result.addMember("label", "$T.$L", new Object[]{WireField.Label.class, wireFieldLabel});
        }
        if (field.isRedacted()) {
            result.addMember("redacted", "true", new Object[0]);
        }
        if (!(generatedName = localNameAllocator.get((Object)field)).equals(field.getName())) {
            result.addMember("declaredName", "$S", new Object[]{field.getName()});
        }
        if (!field.getJsonName().equals(field.getName())) {
            result.addMember("jsonName", "$S", new Object[]{field.getJsonName()});
        }
        if (field.isOneOf()) {
            String oneofName = null;
            for (OneOf oneOf : message.getOneOfs()) {
                if (!oneOf.getFields().contains(field)) continue;
                oneofName = oneOf.getName();
                break;
            }
            if (oneofName == null) {
                throw new IllegalArgumentException("No oneof found for field: " + field.getQualifiedName());
            }
            result.addMember("oneofName", "$S", new Object[]{oneofName});
        }
        return result.build();
    }

    @Nullable
    private AnnotationSpec wireEnumConstantAnnotation(NameAllocator nameAllocator, EnumConstant constant) {
        AnnotationSpec.Builder result = AnnotationSpec.builder(WireEnumConstant.class);
        NameAllocator localNameAllocator = nameAllocator.clone();
        String generatedName = localNameAllocator.get((Object)constant);
        if (generatedName.equals(constant.getName())) {
            return null;
        }
        result.addMember("declaredName", "$S", new Object[]{constant.getName()});
        return result.build();
    }

    private String adapterString(ProtoType type) {
        String builtInAdapterString = JvmLanguages.builtInAdapterString((ProtoType)type);
        if (builtInAdapterString != null) {
            return builtInAdapterString;
        }
        AdapterConstant adapterConstant = this.profile.getAdapter(type);
        if (adapterConstant != null) {
            return this.reflectionName((TypeName)adapterConstant.javaClassName) + "#" + adapterConstant.memberName;
        }
        return this.reflectionName(this.typeName(type)) + "#ADAPTER";
    }

    private String reflectionName(TypeName typeName) {
        ClassName className = typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).rawType : (ClassName)typeName;
        return className.packageName().isEmpty() ? Joiner.on((char)'$').join((Iterable)className.simpleNames()) : className.packageName() + '.' + Joiner.on((char)'$').join((Iterable)className.simpleNames());
    }

    private MethodSpec messageFieldsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder();
        result.addModifiers(new Modifier[]{Modifier.PUBLIC});
        result.addCode("this(", new Object[0]);
        for (Field field : type.getFieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String fieldName = nameAllocator.get((Object)field);
            ParameterSpec.Builder param = ParameterSpec.builder((TypeName)javaType, (String)fieldName, (Modifier[])new Modifier[0]);
            if (this.emitAndroidAnnotations && field.getEncodeMode() == Field.EncodeMode.NULL_IF_ABSENT) {
                param.addAnnotation(NULLABLE);
            }
            result.addParameter(param.build());
            result.addCode("$L, ", new Object[]{fieldName});
        }
        result.addCode("$T.EMPTY);\n", new Object[]{BYTE_STRING});
        return result.build();
    }

    private MethodSpec messageConstructor(NameAllocator nameAllocator, MessageType type, ClassName builderJavaType) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator localNameAllocator = nameAllocator.clone();
        String adapterName = localNameAllocator.get((Object)"ADAPTER");
        String unknownFieldsName = localNameAllocator.newName("unknownFields");
        String builderName = localNameAllocator.newName("builder");
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($N, $N)", new Object[]{adapterName, unknownFieldsName});
        for (OneOf oneOf : type.getOneOfs()) {
            if (oneOf.getFields().size() < 2) continue;
            CodeBlock.Builder fieldNamesBuilder = CodeBlock.builder();
            boolean first = true;
            for (Field field : oneOf.getFields()) {
                if (!first) {
                    fieldNamesBuilder.add(", ", new Object[0]);
                }
                if (constructorTakesAllFields) {
                    fieldNamesBuilder.add("$N", new Object[]{localNameAllocator.get((Object)field)});
                } else {
                    fieldNamesBuilder.add("$N.$N", new Object[]{builderName, localNameAllocator.get((Object)field)});
                }
                first = false;
            }
            CodeBlock fieldNames = fieldNamesBuilder.build();
            result.beginControlFlow("if ($T.countNonNull($L) > 1)", new Object[]{Internal.class, fieldNames});
            result.addStatement("throw new IllegalArgumentException($S)", new Object[]{"at most one of " + fieldNames + " may be non-null"});
            result.endControlFlow();
        }
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldAccessName;
            TypeName javaType = this.fieldType(field);
            String fieldName = localNameAllocator.get((Object)field);
            String string = fieldAccessName = constructorTakesAllFields ? fieldName : builderName + "." + fieldName;
            if (constructorTakesAllFields) {
                ParameterSpec.Builder param = ParameterSpec.builder((TypeName)javaType, (String)fieldName, (Modifier[])new Modifier[0]);
                if (this.emitAndroidAnnotations && field.getEncodeMode() == Field.EncodeMode.NULL_IF_ABSENT) {
                    param.addAnnotation(NULLABLE);
                }
                result.addParameter(param.build());
            }
            if (field.getEncodeMode() == Field.EncodeMode.OMIT_IDENTITY && (field.getType().isScalar() && (field.getType() == ProtoType.STRING || field.getType() == ProtoType.BYTES) || this.isEnum(field.getType()) && !field.getType().equals((Object)ProtoType.STRUCT_NULL))) {
                result.beginControlFlow("if ($L == null)", new Object[]{fieldAccessName});
                result.addStatement("throw new IllegalArgumentException($S)", new Object[]{fieldAccessName + " == null"});
                result.endControlFlow();
            }
            if (field.getType().isMap() && this.isStruct(field.getType().getValueType())) {
                result.addStatement("this.$1L = $2T.immutableCopyOfMapWithStructValues($1S, $3L)", new Object[]{fieldName, Internal.class, fieldAccessName});
                continue;
            }
            if (this.isStruct(field.getType())) {
                result.addStatement("this.$1L = $2T.immutableCopyOfStruct($1S, $3L)", new Object[]{fieldName, Internal.class, fieldAccessName});
                continue;
            }
            if (field.isRepeated() || field.getType().isMap()) {
                result.addStatement("this.$1L = $2T.immutableCopyOf($1S, $3L)", new Object[]{fieldName, Internal.class, fieldAccessName});
                continue;
            }
            result.addStatement("this.$1L = $2L", new Object[]{fieldName, fieldAccessName});
        }
        if (!constructorTakesAllFields) {
            result.addParameter((TypeName)builderJavaType, builderName, new Modifier[0]);
        }
        result.addParameter((TypeName)BYTE_STRING, unknownFieldsName, new Modifier[0]);
        return result.build();
    }

    private boolean isStruct(ProtoType protoType) {
        return protoType.equals((Object)ProtoType.STRUCT_MAP) || protoType.equals((Object)ProtoType.STRUCT_LIST) || protoType.equals((Object)ProtoType.STRUCT_VALUE) || protoType.equals((Object)ProtoType.STRUCT_NULL);
    }

    private boolean isWrapper(ProtoType protoType) {
        return protoType.equals((Object)ProtoType.DOUBLE_VALUE) || protoType.equals((Object)ProtoType.FLOAT_VALUE) || protoType.equals((Object)ProtoType.INT64_VALUE) || protoType.equals((Object)ProtoType.UINT64_VALUE) || protoType.equals((Object)ProtoType.INT32_VALUE) || protoType.equals((Object)ProtoType.UINT32_VALUE) || protoType.equals((Object)ProtoType.BOOL_VALUE) || protoType.equals((Object)ProtoType.STRING_VALUE) || protoType.equals((Object)ProtoType.BYTES_VALUE);
    }

    private MethodSpec messageEquals(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String otherName = localNameAllocator.newName("other");
        String oName = localNameAllocator.newName("o");
        TypeName javaType = this.typeName(type.getType());
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, otherName, new Modifier[0]);
        result.addStatement("if ($N == this) return true", new Object[]{otherName});
        result.addStatement("if (!($N instanceof $T)) return false", new Object[]{otherName, javaType});
        result.addStatement("$T $N = ($T) $N", new Object[]{javaType, oName, javaType, otherName});
        result.addCode("$[return unknownFields().equals($N.unknownFields())", new Object[]{oName});
        List fields = type.getFieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            if (field.isRequired() || field.isRepeated() || field.getType().isMap()) {
                result.addCode("\n&& $1L.equals($2N.$1L)", new Object[]{fieldName, oName});
                continue;
            }
            result.addCode("\n&& $1T.equals($2L, $3N.$2L)", new Object[]{Internal.class, fieldName, oName});
        }
        result.addCode(";\n$]", new Object[0]);
        return result.build();
    }

    private MethodSpec messageHashCode(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String resultName = localNameAllocator.newName("result");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        List fields = type.getFieldsAndOneOfFields();
        if (fields.isEmpty()) {
            result.addStatement("return unknownFields().hashCode()", new Object[0]);
            return result.build();
        }
        result.addStatement("int $N = super.hashCode", new Object[]{resultName});
        result.beginControlFlow("if ($N == 0)", new Object[]{resultName});
        result.addStatement("$N = unknownFields().hashCode()", new Object[]{resultName});
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            TypeName typeName = this.fieldType(field);
            result.addCode("$1N = $1N * 37 + ", new Object[]{resultName});
            if (typeName == TypeName.BOOLEAN) {
                result.addStatement("$T.hashCode($N)", new Object[]{Boolean.class, fieldName});
                continue;
            }
            if (typeName == TypeName.INT) {
                result.addStatement("$T.hashCode($N)", new Object[]{Integer.class, fieldName});
                continue;
            }
            if (typeName == TypeName.LONG) {
                result.addStatement("$T.hashCode($N)", new Object[]{Long.class, fieldName});
                continue;
            }
            if (typeName == TypeName.FLOAT) {
                result.addStatement("$T.hashCode($N)", new Object[]{Float.class, fieldName});
                continue;
            }
            if (typeName == TypeName.DOUBLE) {
                result.addStatement("$T.hashCode($N)", new Object[]{Double.class, fieldName});
                continue;
            }
            if (field.isRequired() || field.isRepeated() || field.getType().isMap()) {
                result.addStatement("$L.hashCode()", new Object[]{fieldName});
                continue;
            }
            result.addStatement("($1L != null ? $1L.hashCode() : 0)", new Object[]{fieldName});
        }
        result.addStatement("super.hashCode = $N", new Object[]{resultName});
        result.endControlFlow();
        result.addStatement("return $N", new Object[]{resultName});
        return result.build();
    }

    private MethodSpec mapAdapter(NameAllocator nameAllocator, TypeName adapterType, String fieldName, ProtoType mapType) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String resultName = localNameAllocator.newName("result");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)(fieldName + "Adapter")).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(adapterType);
        result.addStatement("$T $N = $N", new Object[]{adapterType, resultName, fieldName});
        result.beginControlFlow("if ($N == null)", new Object[]{resultName});
        result.addStatement("$N = $T.newMapAdapter($L, $L)", new Object[]{resultName, ADAPTER, this.singleAdapterFor(mapType.getKeyType()), this.singleAdapterFor(mapType.getValueType())});
        result.addStatement("$N = $N", new Object[]{fieldName, resultName});
        result.endControlFlow();
        result.addStatement("return $N", new Object[]{resultName});
        return result.build();
    }

    private MethodSpec messageToString(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        String builderName = localNameAllocator.newName("builder");
        result.addStatement("$1T $2N = new $1T()", new Object[]{StringBuilder.class, builderName});
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            TypeName fieldType = this.fieldType(field);
            if (field.isRepeated() || field.getType().isMap()) {
                result.addCode("if (!$N.isEmpty()) ", new Object[]{fieldName});
            } else if (!field.isRequired() && !fieldType.isPrimitive()) {
                result.addCode("if ($N != null) ", new Object[]{fieldName});
            }
            if (field.isRedacted()) {
                result.addStatement("$N.append(\", $N=\u2588\u2588\")", new Object[]{builderName, field.getName()});
                continue;
            }
            if (field.getType().equals((Object)ProtoType.STRING)) {
                result.addStatement("$N.append(\", $N=\").append($T.sanitize($L))", new Object[]{builderName, field.getName(), Internal.class, fieldName});
                continue;
            }
            result.addStatement("$N.append(\", $N=\").append($L)", new Object[]{builderName, field.getName(), fieldName});
        }
        result.addStatement("return builder.replace(0, 2, \"$L{\").append('}').toString()", new Object[]{type.getType().getSimpleName()});
        return result.build();
    }

    private TypeSpec builder(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderType) {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        result.superclass(JavaGenerator.builderOf((TypeName)javaType, builderType));
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            result.addField(this.fieldType(field), fieldName, new Modifier[]{Modifier.PUBLIC});
        }
        result.addMethod(this.builderNoArgsConstructor(nameAllocator, type));
        for (Field field : type.fields()) {
            result.addMethod(this.setter(nameAllocator, (TypeName)builderType, null, field));
        }
        for (OneOf oneOf : type.getOneOfs()) {
            for (Field field : oneOf.getFields()) {
                result.addMethod(this.setter(nameAllocator, (TypeName)builderType, oneOf, field));
            }
        }
        result.addMethod(this.builderBuild(nameAllocator, type, javaType));
        return result.build();
    }

    private MethodSpec builderNoArgsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock initialValue = this.initialValue(field);
            if (initialValue == null) continue;
            result.addStatement("$L = $L", new Object[]{fieldName, initialValue});
        }
        return result.build();
    }

    @Nullable
    private CodeBlock initialValue(Field field) {
        if (field.isPacked() || field.isRepeated()) {
            return CodeBlock.of((String)"$T.newMutableList()", (Object[])new Object[]{Internal.class});
        }
        if (field.getType().isMap()) {
            return CodeBlock.of((String)"$T.newMutableMap()", (Object[])new Object[]{Internal.class});
        }
        if (field.getEncodeMode() == Field.EncodeMode.OMIT_IDENTITY) {
            CodeBlock identityValue = this.identityValue(field);
            if (identityValue.equals((Object)CodeBlock.of((String)"null", (Object[])new Object[0]))) {
                return null;
            }
            return this.identityValue(field);
        }
        return null;
    }

    private MethodSpec newBuilder(NameAllocator nameAllocator, MessageType message) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String builderName = localNameAllocator.newName("builder");
        ClassName javaType = (ClassName)this.typeName(message.getType());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"newBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderJavaType).addStatement("$1T $2L = new $1T()", new Object[]{builderJavaType, builderName});
        List fields = message.getFieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            if (field.isRepeated() || field.getType().isMap()) {
                result.addStatement("$1L.$2L = $3T.copyOf($2L)", new Object[]{builderName, fieldName, Internal.class});
                continue;
            }
            result.addStatement("$1L.$2L = $2L", new Object[]{builderName, fieldName});
        }
        result.addStatement("$L.addUnknownFields(unknownFields())", new Object[]{builderName});
        result.addStatement("return $L", new Object[]{builderName});
        return result.build();
    }

    private MethodSpec setter(NameAllocator nameAllocator, TypeName builderType, OneOf oneOf, Field field) {
        TypeName javaType = this.fieldType(field);
        String fieldName = nameAllocator.get((Object)field);
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(javaType, fieldName, new Modifier[0]).returns(builderType);
        if (!field.getDocumentation().isEmpty()) {
            result.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.getDocumentation())});
        }
        if (field.isDeprecated()) {
            result.addAnnotation(Deprecated.class);
        }
        if (field.isRepeated() || field.getType().isMap()) {
            result.addStatement("$T.checkElementsNotNull($L)", new Object[]{Internal.class, fieldName});
        }
        result.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
        if (oneOf != null) {
            for (Field other : oneOf.getFields()) {
                if (field == other) continue;
                result.addStatement("this.$L = null", new Object[]{nameAllocator.get((Object)other)});
            }
        }
        result.addStatement("return this", new Object[0]);
        return result.build();
    }

    private MethodSpec builderBuild(NameAllocator nameAllocator, MessageType message, ClassName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType);
        List requiredFields = message.getRequiredFields();
        if (!requiredFields.isEmpty()) {
            CodeBlock.Builder conditionals = CodeBlock.builder().add("$[", new Object[0]);
            CodeBlock.Builder missingArgs = CodeBlock.builder();
            for (int i = 0; i < requiredFields.size(); ++i) {
                Field requiredField = (Field)requiredFields.get(i);
                if (i > 0) {
                    conditionals.add("\n|| ", new Object[0]);
                }
                conditionals.add("$L == null", new Object[]{nameAllocator.get((Object)requiredField)});
                if (i > 0) {
                    missingArgs.add(",\n", new Object[0]);
                }
                missingArgs.add("$1L, $2S", new Object[]{nameAllocator.get((Object)requiredField), requiredField.getName()});
            }
            result.beginControlFlow("if ($L)", new Object[]{conditionals.add("$]", new Object[0]).build()}).addStatement("throw $T.missingRequiredFields($L)", new Object[]{Internal.class, missingArgs.build()}).endControlFlow();
        }
        boolean constructorTakesAllFields = this.constructorTakesAllFields(message);
        result.addCode("return new $T(", new Object[]{javaType});
        if (constructorTakesAllFields) {
            for (Field field : message.getFieldsAndOneOfFields()) {
                result.addCode("$L, ", new Object[]{nameAllocator.get((Object)field)});
            }
        } else {
            result.addCode("this, ", new Object[0]);
        }
        result.addCode("super.buildUnknownFields());\n", new Object[0]);
        return result.build();
    }

    private CodeBlock defaultValue(Field field) {
        String defaultValue = field.getDefault();
        if (defaultValue == null && this.isEnum(field.getType())) {
            defaultValue = this.enumDefault(field.getType()).getName();
        }
        if (field.getType().isScalar() || defaultValue != null) {
            return this.fieldInitializer(field.getType(), defaultValue);
        }
        throw new IllegalStateException("Field " + field + " cannot have default value");
    }

    private CodeBlock fieldInitializer(ProtoType type, @Nullable Object value) {
        TypeName javaType = this.typeName(type);
        if (value instanceof List) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.asList(", new Object[]{Arrays.class});
            boolean first = true;
            for (Object o : (List)value) {
                if (!first) {
                    builder.add(",", new Object[0]);
                }
                first = false;
                builder.add("\n$>$>$L$<$<", new Object[]{this.fieldInitializer(type, o)});
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
        if (value instanceof Map) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T.Builder()", new Object[]{javaType});
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ProtoMember protoMember = (ProtoMember)entry.getKey();
                Field field = this.schema.getField(protoMember);
                CodeBlock valueInitializer = this.fieldInitializer(field.getType(), entry.getValue());
                builder.add("\n$>$>.$L($L)$<$<", new Object[]{this.fieldName(type, field), valueInitializer});
            }
            builder.add("\n$>$>.build()$<$<", new Object[0]);
            return builder.build();
        }
        if (javaType.equals((Object)TypeName.BOOLEAN)) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{value != null ? value : Boolean.valueOf(false)});
        }
        if (javaType.equals((Object)TypeName.INT)) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{JvmLanguages.optionValueToInt((Object)value)});
        }
        if (javaType.equals((Object)TypeName.LONG)) {
            return CodeBlock.of((String)"$LL", (Object[])new Object[]{JvmLanguages.optionValueToLong((Object)value)});
        }
        if (javaType.equals((Object)TypeName.FLOAT)) {
            if (value == null) {
                return CodeBlock.of((String)"0.0f", (Object[])new Object[0]);
            }
            if ("inf".equals(value)) {
                return CodeBlock.of((String)"Float.POSITIVE_INFINITY", (Object[])new Object[0]);
            }
            if ("-inf".equals(value)) {
                return CodeBlock.of((String)"Float.NEGATIVE_INFINITY", (Object[])new Object[0]);
            }
            if ("nan".equals(value) || "-nan".equals(value)) {
                return CodeBlock.of((String)"Float.NaN", (Object[])new Object[0]);
            }
            return CodeBlock.of((String)"$Lf", (Object[])new Object[]{String.valueOf(value)});
        }
        if (javaType.equals((Object)TypeName.DOUBLE)) {
            if (value == null) {
                return CodeBlock.of((String)"0.0d", (Object[])new Object[0]);
            }
            if ("inf".equals(value)) {
                return CodeBlock.of((String)"Double.POSITIVE_INFINITY", (Object[])new Object[0]);
            }
            if ("-inf".equals(value)) {
                return CodeBlock.of((String)"Double.NEGATIVE_INFINITY", (Object[])new Object[0]);
            }
            if ("nan".equals(value) || "-nan".equals(value)) {
                return CodeBlock.of((String)"Double.NaN", (Object[])new Object[0]);
            }
            return CodeBlock.of((String)"$Ld", (Object[])new Object[]{String.valueOf(value)});
        }
        if (javaType.equals((Object)STRING)) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value != null ? value : ""});
        }
        if (javaType.equals((Object)BYTE_STRING)) {
            if (value == null) {
                return CodeBlock.of((String)"$T.EMPTY", (Object[])new Object[]{ByteString.class});
            }
            return CodeBlock.of((String)"$T.decodeBase64($S)", (Object[])new Object[]{ByteString.class, ByteString.encodeString((String)String.valueOf(value), (Charset)Charsets.ISO_8859_1).base64()});
        }
        if (this.isEnum(type) && value != null) {
            return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{javaType, value});
        }
        throw new IllegalStateException(type + " is not an allowed scalar type");
    }

    private CodeBlock identityValue(Field field) {
        switch (field.getEncodeMode()) {
            case MAP: {
                return CodeBlock.of((String)"$T.emptyMap()", (Object[])new Object[]{Collections.class});
            }
            case REPEATED: 
            case PACKED: {
                return CodeBlock.of((String)"$T.emptyList()", (Object[])new Object[]{Collections.class});
            }
            case NULL_IF_ABSENT: {
                return CodeBlock.of((String)"null", (Object[])new Object[0]);
            }
            case OMIT_IDENTITY: {
                ProtoType protoType = field.getType();
                Type type = this.schema.getType(protoType);
                if (protoType.equals((Object)ProtoType.STRUCT_NULL)) {
                    return CodeBlock.of((String)"null", (Object[])new Object[0]);
                }
                if (field.isOneOf()) {
                    return CodeBlock.of((String)"null", (Object[])new Object[0]);
                }
                if (protoType.isScalar()) {
                    CodeBlock value = PROTOTYPE_TO_IDENTITY_VALUES.get(protoType);
                    if (value == null) {
                        throw new IllegalArgumentException("Unexpected scalar proto type: " + protoType);
                    }
                    return value;
                }
                if (type instanceof MessageType) {
                    return CodeBlock.of((String)"null", (Object[])new Object[0]);
                }
                if (!(type instanceof EnumType)) break;
                return this.identity((EnumType)type);
            }
        }
        throw new IllegalArgumentException("No identity value for field: " + field + "(" + field.getEncodeMode() + ")");
    }

    private CodeBlock identity(EnumType enumType) {
        EnumConstant constantZero = enumType.constant(0);
        if (constantZero == null) {
            return CodeBlock.of((String)"null", (Object[])new Object[0]);
        }
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{this.typeName(enumType.getType()), ((NameAllocator)this.nameAllocators.getUnchecked((Object)enumType)).get((Object)constantZero)});
    }

    public ClassName generatedTypeName(Field field) {
        return (ClassName)this.memberToJavaName.get((Object)field.getMember());
    }

    @Nullable
    public TypeSpec generateOptionType(Extend extend, Field field) {
        Preconditions.checkArgument((boolean)extend.getFields().contains(field));
        if (!this.emitDeclaredOptions) {
            return null;
        }
        ElementType elementType = JvmLanguages.annotationTargetType((Extend)extend);
        if (elementType == null) {
            return null;
        }
        if (!JvmLanguages.eligibleAsAnnotationMember((Schema)this.schema, (Field)field)) {
            return null;
        }
        TypeName returnType = this.typeName(field.getType());
        ClassName javaType = this.generatedTypeName(field);
        TypeSpec.Builder builder = TypeSpec.annotationBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, RetentionPolicy.RUNTIME}).build()).addAnnotation(AnnotationSpec.builder(Target.class).addMember("value", "$T.$L", new Object[]{ElementType.class, elementType}).build());
        if (!field.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{field.getDocumentation()});
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"value").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        return builder.build();
    }

    private List<AnnotationSpec> optionAnnotations(Options options) {
        ArrayList<AnnotationSpec> result = new ArrayList<AnnotationSpec>();
        for (Map.Entry entry : options.getMap().entrySet()) {
            AnnotationSpec annotationSpec = this.optionAnnotation((ProtoMember)entry.getKey(), entry.getValue());
            if (annotationSpec == null) continue;
            result.add(annotationSpec);
        }
        return result;
    }

    @Nullable
    private AnnotationSpec optionAnnotation(ProtoMember protoMember, Object value) {
        if (!this.emitAppliedOptions) {
            return null;
        }
        Field field = this.schema.getField(protoMember);
        if (field == null) {
            return null;
        }
        if (!JvmLanguages.eligibleAsAnnotationMember((Schema)this.schema, (Field)field)) {
            return null;
        }
        ProtoFile protoFile = this.schema.protoFile(field.getLocation().getPath());
        String simpleName = _PlatformKt.camelCase((String)field.getName(), (boolean)true) + "Option";
        ClassName type = ClassName.get((String)JvmLanguages.javaPackage((ProtoFile)protoFile), (String)simpleName, (String[])new String[0]);
        CodeBlock fieldValue = this.fieldInitializer(field.getType(), value);
        return AnnotationSpec.builder((ClassName)type).addMember("value", fieldValue).build();
    }
}

