/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public final class JavaGenerator {
    static final ProtoMember FIELD_DEPRECATED = ProtoMember.get((ProtoType)Options.FIELD_OPTIONS, (String)"deprecated");
    static final ProtoMember ENUM_DEPRECATED = ProtoMember.get((ProtoType)Options.ENUM_VALUE_OPTIONS, (String)"deprecated");
    static final ProtoMember PACKED = ProtoMember.get((ProtoType)Options.FIELD_OPTIONS, (String)"packed");
    static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    static final ClassName STRING = ClassName.get(String.class);
    static final ClassName LIST = ClassName.get(List.class);
    static final ClassName MESSAGE = ClassName.get(Message.class);
    static final ClassName ADAPTER = ClassName.get(ProtoAdapter.class);
    static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    static final ClassName PARCEL = ClassName.get((String)"android.os", (String)"Parcel", (String[])new String[0]);
    static final ClassName PARCELABLE = ClassName.get((String)"android.os", (String)"Parcelable", (String[])new String[0]);
    static final ClassName CREATOR = PARCELABLE.nestedClass("Creator");
    private static final Map<ProtoType, TypeName> BUILT_IN_TYPES_MAP = ImmutableMap.builder().put((Object)ProtoType.BOOL, (Object)TypeName.BOOLEAN.box()).put((Object)ProtoType.BYTES, (Object)ClassName.get(ByteString.class)).put((Object)ProtoType.DOUBLE, (Object)TypeName.DOUBLE.box()).put((Object)ProtoType.FLOAT, (Object)TypeName.FLOAT.box()).put((Object)ProtoType.FIXED32, (Object)TypeName.INT.box()).put((Object)ProtoType.FIXED64, (Object)TypeName.LONG.box()).put((Object)ProtoType.INT32, (Object)TypeName.INT.box()).put((Object)ProtoType.INT64, (Object)TypeName.LONG.box()).put((Object)ProtoType.SFIXED32, (Object)TypeName.INT.box()).put((Object)ProtoType.SFIXED64, (Object)TypeName.LONG.box()).put((Object)ProtoType.SINT32, (Object)TypeName.INT.box()).put((Object)ProtoType.SINT64, (Object)TypeName.LONG.box()).put((Object)ProtoType.STRING, (Object)ClassName.get(String.class)).put((Object)ProtoType.UINT32, (Object)TypeName.INT.box()).put((Object)ProtoType.UINT64, (Object)TypeName.LONG.box()).put((Object)Options.FIELD_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"MessageOptions", (String[])new String[0])).put((Object)Options.ENUM_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"FieldOptions", (String[])new String[0])).put((Object)Options.MESSAGE_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"EnumOptions", (String[])new String[0])).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private final LoadingCache<MessageType, NameAllocator> typeToNameAllocator = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MessageType, NameAllocator>(){

        public NameAllocator load(MessageType type) throws Exception {
            NameAllocator nameAllocator = new NameAllocator();
            nameAllocator.newName("serialVersionUID", (Object)"serialVersionUID");
            nameAllocator.newName("ADAPTER", (Object)"ADAPTER");
            nameAllocator.newName("MESSAGE_OPTIONS", (Object)"MESSAGE_OPTIONS");
            if (JavaGenerator.this.emitAndroid) {
                nameAllocator.newName("CREATOR", (Object)"CREATOR");
            }
            Set collidingNames = JavaGenerator.this.collidingFieldNames((ImmutableList<Field>)type.fieldsAndOneOfFields());
            for (Field field : type.fieldsAndOneOfFields()) {
                String suggestion = collidingNames.contains(field.name()) ? field.qualifiedName() : field.name();
                nameAllocator.newName(suggestion, (Object)field);
            }
            nameAllocator.newName("unknownFields", (Object)"unknownFields");
            nameAllocator.newName("result", (Object)"result");
            nameAllocator.newName("message", (Object)"message");
            nameAllocator.newName("other", (Object)"other");
            nameAllocator.newName("o", (Object)"o");
            nameAllocator.newName("builder", (Object)"builder");
            return nameAllocator;
        }
    });
    private final Schema schema;
    private final ImmutableMap<ProtoType, TypeName> nameToJavaName;
    private final boolean emitAndroid;
    private final boolean emitCompact;

    private JavaGenerator(Schema schema, ImmutableMap<ProtoType, TypeName> nameToJavaName, boolean emitAndroid, boolean emitCompact) {
        this.schema = schema;
        this.nameToJavaName = nameToJavaName;
        this.emitAndroid = emitAndroid;
        this.emitCompact = emitCompact;
    }

    public JavaGenerator withAndroid(boolean emitAndroid) {
        return new JavaGenerator(this.schema, this.nameToJavaName, emitAndroid, this.emitCompact);
    }

    public JavaGenerator withCompact(boolean compactGeneration) {
        return new JavaGenerator(this.schema, this.nameToJavaName, this.emitAndroid, compactGeneration);
    }

    public static JavaGenerator get(Schema schema) {
        LinkedHashMap<ProtoType, TypeName> nameToJavaName = new LinkedHashMap<ProtoType, TypeName>();
        nameToJavaName.putAll(BUILT_IN_TYPES_MAP);
        for (ProtoFile protoFile : schema.protoFiles()) {
            String javaPackage = JavaGenerator.javaPackage(protoFile);
            JavaGenerator.putAll(nameToJavaName, javaPackage, null, (List<Type>)protoFile.types());
            for (Service service : protoFile.services()) {
                ClassName className = ClassName.get((String)javaPackage, (String)service.type().simpleName(), (String[])new String[0]);
                nameToJavaName.put(service.type(), (TypeName)className);
            }
        }
        return new JavaGenerator(schema, (ImmutableMap<ProtoType, TypeName>)ImmutableMap.copyOf(nameToJavaName), false, false);
    }

    private static void putAll(Map<ProtoType, TypeName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.type().simpleName()) : ClassName.get((String)javaPackage, (String)type.type().simpleName(), (String[])new String[0]);
            wireToJava.put(type.type(), (TypeName)className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, (List<Type>)type.nestedTypes());
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public TypeName typeName(ProtoType protoType) {
        TypeName candidate = (TypeName)this.nameToJavaName.get((Object)protoType);
        Preconditions.checkArgument((candidate != null ? 1 : 0) != 0, (String)"unexpected type %s", (Object[])new Object[]{protoType});
        return candidate;
    }

    private CodeBlock singleAdapterFor(Field field) {
        ProtoType type = field.type();
        CodeBlock.Builder result = CodeBlock.builder();
        if (type.isScalar()) {
            result.add("$T.$L", new Object[]{ADAPTER, type.simpleName().toUpperCase(Locale.US)});
        } else {
            result.add("$T.ADAPTER", new Object[]{this.typeName(type)});
        }
        return result.build();
    }

    private CodeBlock adapterFor(Field field) {
        CodeBlock.Builder result = this.singleAdapterFor(field).toBuilder();
        if (field.isPacked()) {
            result.add(".asPacked()", new Object[0]);
        } else if (field.isRepeated()) {
            result.add(".asRepeated()", new Object[0]);
        }
        return result.build();
    }

    private static String javaPackage(ProtoFile protoFile) {
        String javaPackage = protoFile.javaPackage();
        if (javaPackage != null) {
            return javaPackage;
        }
        if (protoFile.packageName() != null) {
            return protoFile.packageName();
        }
        return "";
    }

    public boolean isEnum(ProtoType type) {
        return this.schema.getType(type) instanceof EnumType;
    }

    EnumConstant enumDefault(ProtoType type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return (EnumConstant)wireEnum.constants().get(0);
    }

    static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{type});
    }

    static TypeName messageOf(TypeName type, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)MESSAGE, (TypeName[])new TypeName[]{type, builderType});
    }

    static TypeName adapterOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)ADAPTER, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName builderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)BUILDER, (TypeName[])new TypeName[]{messageType, builderType});
    }

    static TypeName creatorOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)CREATOR, (TypeName[])new TypeName[]{messageType});
    }

    private static boolean isRedacted(Field field) {
        return field.options().optionMatches(".*\\.redacted", "true");
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("\\*/", "&#42;/");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public TypeSpec generateEnum(EnumType type) {
        ClassName javaType = (ClassName)this.typeName(type.type());
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(WireEnum.class);
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        builder.addField(TypeName.INT, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addStatement("this.value = value", new Object[0]);
        constructorBuilder.addParameter(TypeName.INT, "value", new Modifier[0]);
        LinkedHashSet<ProtoMember> allOptionFieldsBuilder = new LinkedHashSet<ProtoMember>();
        for (EnumConstant constant : type.constants()) {
            for (ProtoMember protoMember : constant.options().map().keySet()) {
                Field optionField = this.schema.getField(protoMember);
                if (!allOptionFieldsBuilder.add(protoMember)) continue;
                TypeName optionJavaType = this.typeName(optionField.type());
                builder.addField(optionJavaType, optionField.name(), new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                constructorBuilder.addParameter(optionJavaType, optionField.name(), new Modifier[0]);
                constructorBuilder.addStatement("this.$L = $L", new Object[]{optionField.name(), optionField.name()});
            }
        }
        ImmutableList allOptionMembers = ImmutableList.copyOf(allOptionFieldsBuilder);
        String enumArgsFormat = "$L" + Strings.repeat((String)", $L", (int)allOptionMembers.size());
        builder.addMethod(constructorBuilder.build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder((String)"fromValue").addJavadoc("Return the constant for {@code value} or null.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)javaType).addParameter(Integer.TYPE, "value", new Modifier[0]).beginControlFlow("switch (value)", new Object[0]);
        LinkedHashSet<Integer> seenTags = new LinkedHashSet<Integer>();
        for (EnumConstant constant : type.constants()) {
            Object[] enumArgs = new Object[allOptionMembers.size() + 1];
            enumArgs[0] = constant.tag();
            for (int i = 0; i < allOptionMembers.size(); ++i) {
                ProtoMember protoMember = (ProtoMember)allOptionMembers.get(i);
                Field field = this.schema.getField(protoMember);
                Object value = constant.options().map().get(protoMember);
                enumArgs[i + 1] = value != null ? this.fieldInitializer(field.type(), value) : null;
            }
            TypeSpec.Builder constantBuilder = TypeSpec.anonymousClassBuilder((String)enumArgsFormat, (Object[])enumArgs);
            if (!constant.documentation().isEmpty()) {
                constantBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.documentation())});
            }
            if ("true".equals(constant.options().get(ENUM_DEPRECATED))) {
                constantBuilder.addAnnotation(Deprecated.class);
            }
            builder.addEnumConstant(constant.name(), constantBuilder.build());
            if (!seenTags.add(constant.tag())) continue;
            fromValueBuilder.addStatement("case $L: return $L", new Object[]{constant.tag(), constant.name()});
        }
        builder.addMethod(fromValueBuilder.addStatement("default: return null", new Object[0]).endControlFlow().build());
        builder.addField(FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)"ADAPTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.newEnumAdapter($T.class)", new Object[]{ProtoAdapter.class, javaType}).build());
        FieldSpec options = this.optionsField(Options.ENUM_OPTIONS, "ENUM_OPTIONS", type.options());
        if (options != null) {
            builder.addField(options);
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"getValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return value", new Object[0]).build());
        return builder.build();
    }

    public TypeSpec generateMessage(MessageType type) {
        NameAllocator nameAllocator = (NameAllocator)this.typeToNameAllocator.getUnchecked((Object)type);
        ClassName javaType = (ClassName)this.typeName(type.type());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        builder.superclass(JavaGenerator.messageOf((TypeName)javaType, builderJavaType));
        builder.addField(this.messageAdapter(nameAllocator, type, javaType, builderJavaType));
        builder.addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)nameAllocator.get((Object)"serialVersionUID"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$LL", new Object[]{0L}).build());
        FieldSpec messageOptions = this.optionsField(Options.MESSAGE_OPTIONS, nameAllocator.get((Object)"MESSAGE_OPTIONS"), type.options());
        if (messageOptions != null) {
            builder.addField(messageOptions);
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            String optionsFieldName = "FIELD_OPTIONS_" + fieldName.toUpperCase(Locale.US);
            FieldSpec fieldOptions = this.optionsField(Options.FIELD_OPTIONS, optionsFieldName, field.options());
            if (fieldOptions == null) continue;
            builder.addField(fieldOptions);
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName fieldJavaType = this.fieldType(field);
            if ((field.type().isScalar() || this.isEnum(field.type())) && !field.isRepeated() && !field.isPacked()) {
                builder.addField(this.defaultField(nameAllocator, field, fieldJavaType));
            }
            String fieldName = nameAllocator.get((Object)field);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldJavaType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (this.emitCompact) {
                fieldBuilder.addAnnotation(this.wireFieldAnnotation(field));
            }
            if (!field.documentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
            }
            if (field.isExtension()) {
                fieldBuilder.addJavadoc("Extension source: $L\n", new Object[]{field.location().withoutBase()});
            }
            if (field.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            builder.addField(fieldBuilder.build());
        }
        builder.addMethod(this.messageFieldsConstructor(nameAllocator, type));
        builder.addMethod(this.messageFieldsAndUnknownFieldsConstructor(nameAllocator, type));
        builder.addMethod(this.newBuilder(nameAllocator, type));
        builder.addMethod(this.messageEquals(nameAllocator, type));
        builder.addMethod(this.messageHashCode(nameAllocator, type));
        if (this.emitAndroid) {
            String adapterName = nameAllocator.get((Object)"ADAPTER");
            builder.addSuperinterface((TypeName)PARCELABLE);
            builder.addMethod(MethodSpec.methodBuilder((String)"writeToParcel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)PARCEL, "out", new Modifier[0]).addParameter(Integer.TYPE, "flags", new Modifier[0]).addStatement("out.writeByteArray($N.encode(this))", new Object[]{adapterName}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"describeContents").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return 0", new Object[0]).build());
            TypeName creatorType = JavaGenerator.creatorOf((TypeName)javaType);
            builder.addField(FieldSpec.builder((TypeName)creatorType, (String)nameAllocator.get((Object)"CREATOR"), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass(creatorType).addMethod(MethodSpec.methodBuilder((String)"createFromParcel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter((TypeName)PARCEL, "in", new Modifier[0]).beginControlFlow("try", new Object[0]).addStatement("return $N.decode(in.createByteArray())", new Object[]{adapterName}).nextControlFlow("catch ($T e)", new Object[]{IOException.class}).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow().build()).addMethod(MethodSpec.methodBuilder((String)"newArray").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of((TypeName)javaType)).addParameter(Integer.TYPE, "size", new Modifier[0]).addStatement("return new $T[size]", new Object[]{javaType}).build()).build()}).build());
        }
        if (!this.emitCompact) {
            builder.addMethod(this.messageToString(nameAllocator, type));
        }
        builder.addType(this.builder(nameAllocator, type, javaType, builderJavaType));
        for (Type nestedType : type.nestedTypes()) {
            TypeSpec typeSpec = nestedType instanceof MessageType ? this.generateMessage((MessageType)nestedType) : this.generateEnum((EnumType)nestedType);
            builder.addType(typeSpec);
        }
        return builder.build();
    }

    private Set<String> collidingFieldNames(ImmutableList<Field> fields) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> collidingNames = new LinkedHashSet<String>();
        for (Field field : fields) {
            if (fieldNames.add(field.name())) continue;
            collidingNames.add(field.name());
        }
        return collidingNames;
    }

    private FieldSpec messageAdapter(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderJavaType) {
        FieldSpec.Builder result = FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)nameAllocator.get((Object)"ADAPTER"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        if (this.emitCompact) {
            result.initializer("$T.newMessageAdapter($T.class)", new Object[]{ProtoAdapter.class, javaType});
        } else {
            TypeSpec.Builder adapter = TypeSpec.anonymousClassBuilder((String)"$T.LENGTH_DELIMITED, $T.class", (Object[])new Object[]{FieldEncoding.class, javaType}).superclass(JavaGenerator.adapterOf((TypeName)javaType));
            adapter.addMethod(this.messageAdapterEncodedSize(nameAllocator, type, (TypeName)javaType));
            adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, (TypeName)javaType));
            adapter.addMethod(this.messageAdapterDecode(nameAllocator, type, (TypeName)javaType, builderJavaType));
            adapter.addMethod(this.messageAdapterRedact(nameAllocator, type, javaType, builderJavaType));
            result.initializer("$L", new Object[]{adapter.build()});
        }
        return result.build();
    }

    private MethodSpec messageAdapterEncodedSize(NameAllocator nameAllocator, MessageType type, TypeName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encodedSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addParameter(javaType, "value", new Modifier[0]);
        result.addCode("$[", new Object[0]);
        String leading = "return";
        for (Field field : type.fieldsAndOneOfFields()) {
            int fieldTag = field.tag();
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock adapter = this.adapterFor(field);
            if (field.isRequired() || field.isRepeated()) {
                result.addCode("$L $L.encodedSizeWithTag($L, value.$L)", new Object[]{leading, adapter, fieldTag, fieldName});
            } else {
                result.addCode("$1L (value.$4L != null ? $2L.encodedSizeWithTag($3L, value.$4L) : 0)", new Object[]{leading, adapter, fieldTag, fieldName});
            }
            leading = "\n+";
        }
        result.addCode("$L value.unknownFields().size();$]\n", new Object[]{leading});
        return result.build();
    }

    private MethodSpec messageAdapterEncode(NameAllocator nameAllocator, MessageType type, TypeName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProtoWriter.class, "writer", new Modifier[0]).addParameter(javaType, "value", new Modifier[0]).addException(IOException.class);
        for (Field field : type.fieldsAndOneOfFields()) {
            int fieldTag = field.tag();
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock adapter = this.adapterFor(field);
            if (field.isRequired()) {
                result.addStatement("$L.encodeWithTag(writer, $L, value.$L)", new Object[]{adapter, fieldTag, fieldName});
                continue;
            }
            result.addStatement("if (value.$3L != null) $1L.encodeWithTag(writer, $2L, value.$3L)", new Object[]{adapter, fieldTag, fieldName});
        }
        result.addStatement("writer.writeBytes(value.unknownFields())", new Object[0]);
        return result.build();
    }

    private MethodSpec messageAdapterDecode(NameAllocator nameAllocator, MessageType type, TypeName javaType, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType).addParameter(ProtoReader.class, "reader", new Modifier[0]).addException(IOException.class);
        result.addStatement("$1T builder = new $1T()", new Object[]{builderJavaType});
        result.addStatement("long token = reader.beginMessage()", new Object[0]);
        result.beginControlFlow("for (int tag; (tag = reader.nextTag()) != -1;)", new Object[0]);
        result.beginControlFlow("switch (tag)", new Object[0]);
        for (Field field : type.fieldsAndOneOfFields()) {
            int fieldTag = field.tag();
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock adapter = this.singleAdapterFor(field);
            if (this.isEnum(field.type())) {
                result.beginControlFlow("case $L:", new Object[]{fieldTag});
                result.beginControlFlow("try", new Object[0]);
                if (field.isRepeated()) {
                    result.addStatement("builder.$L.add($L.decode(reader))", new Object[]{fieldName, adapter});
                } else {
                    result.addStatement("builder.$L($L.decode(reader))", new Object[]{fieldName, adapter});
                }
                result.nextControlFlow("catch ($T e)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class});
                result.addStatement("builder.addUnknownField(tag, $T.VARINT, (long) e.value)", new Object[]{FieldEncoding.class});
                result.endControlFlow();
                result.addStatement("break", new Object[0]);
                result.endControlFlow();
                continue;
            }
            if (field.isRepeated()) {
                result.addStatement("case $L: builder.$L.add($L.decode(reader)); break", new Object[]{fieldTag, fieldName, adapter});
                continue;
            }
            result.addStatement("case $L: builder.$L($L.decode(reader)); break", new Object[]{fieldTag, fieldName, adapter});
        }
        result.beginControlFlow("default:", new Object[0]);
        result.addStatement("$T fieldEncoding = reader.peekFieldEncoding()", new Object[]{FieldEncoding.class});
        result.addStatement("$T value = fieldEncoding.rawProtoAdapter().decode(reader)", new Object[]{Object.class});
        result.addStatement("builder.addUnknownField(tag, fieldEncoding, value)", new Object[0]);
        result.endControlFlow();
        result.endControlFlow();
        result.endControlFlow();
        result.addStatement("reader.endMessage(token)", new Object[0]);
        result.addStatement("return builder.build()", new Object[0]);
        return result.build();
    }

    private MethodSpec messageAdapterRedact(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"redact").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter((TypeName)javaType, "value", new Modifier[0]);
        ArrayList<String> requiredRedacted = new ArrayList<String>();
        for (Field field : type.fieldsAndOneOfFields()) {
            if (!field.isRequired() || !JavaGenerator.isRedacted(field)) continue;
            requiredRedacted.add(nameAllocator.get((Object)field));
        }
        if (!requiredRedacted.isEmpty()) {
            boolean isPlural = requiredRedacted.size() != 1;
            result.addStatement("throw new $T($S)", new Object[]{UnsupportedOperationException.class, (isPlural ? "Fields" : "Field") + " '" + Joiner.on((String)"', '").join(requiredRedacted) + "' " + (isPlural ? "are" : "is") + " required and cannot be redacted."});
            return result.build();
        }
        result.addStatement("$1T builder = value.newBuilder()", new Object[]{builderJavaType});
        for (Field field : type.fieldsAndOneOfFields()) {
            CodeBlock adapter;
            String fieldName = nameAllocator.get((Object)field);
            if (JavaGenerator.isRedacted(field)) {
                if (field.isRepeated()) {
                    result.addStatement("builder.$N = $T.emptyList()", new Object[]{fieldName, Collections.class});
                    continue;
                }
                result.addStatement("builder.$N = null", new Object[]{fieldName});
                continue;
            }
            if (field.type().isScalar() || this.isEnum(field.type())) continue;
            if (field.isRepeated()) {
                adapter = this.singleAdapterFor(field);
                result.addStatement("redactElements(builder.$N, $L)", new Object[]{fieldName, adapter});
                continue;
            }
            adapter = this.adapterFor(field);
            result.addStatement("if (builder.$1N != null) builder.$1N = $2L.redact(builder.$1N)", new Object[]{fieldName, adapter});
        }
        result.addStatement("builder.clearUnknownFields()", new Object[0]);
        result.addStatement("return builder.build()", new Object[0]);
        return result.build();
    }

    private FieldSpec optionsField(ProtoType optionsType, String fieldName, Options options) {
        TypeName optionsJavaType = this.typeName(optionsType);
        CodeBlock.Builder initializer = CodeBlock.builder();
        initializer.add("$[new $T.Builder()", new Object[]{optionsJavaType});
        boolean empty = true;
        for (Map.Entry entry : options.map().entrySet()) {
            if (((ProtoMember)entry.getKey()).equals((Object)FIELD_DEPRECATED) || ((ProtoMember)entry.getKey()).equals((Object)PACKED)) continue;
            Field optionField = this.schema.getField((ProtoMember)entry.getKey());
            initializer.add("\n.$L($L)", new Object[]{this.fieldName(optionsType, optionField), this.fieldInitializer(optionField.type(), entry.getValue())});
            empty = false;
        }
        initializer.add("\n.build()$]", new Object[0]);
        if (empty) {
            return null;
        }
        return FieldSpec.builder((TypeName)optionsJavaType, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer.build()).build();
    }

    private String fieldName(ProtoType type, Field field) {
        MessageType messageType = (MessageType)this.schema.getType(type);
        NameAllocator names = (NameAllocator)this.typeToNameAllocator.getUnchecked((Object)messageType);
        return names.get((Object)field);
    }

    private TypeName fieldType(Field field) {
        TypeName messageType = this.typeName(field.type());
        return field.isRepeated() ? JavaGenerator.listOf(messageType) : messageType;
    }

    private FieldSpec defaultField(NameAllocator nameAllocator, Field field, TypeName fieldType) {
        String defaultFieldName = "DEFAULT_" + nameAllocator.get((Object)field).toUpperCase(Locale.US);
        return FieldSpec.builder((TypeName)fieldType, (String)defaultFieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(this.defaultValue(field)).build();
    }

    private AnnotationSpec wireFieldAnnotation(Field field) {
        AnnotationSpec.Builder result = AnnotationSpec.builder(WireField.class);
        int tag = field.tag();
        result.addMember("tag", String.valueOf(tag), new Object[0]);
        result.addMember("adapter", "$S", new Object[]{this.adapterString(field.type())});
        if (!field.isOptional()) {
            if (field.isPacked()) {
                result.addMember("label", "$T.PACKED", new Object[]{WireField.Label.class});
            } else if (field.label() != null) {
                result.addMember("label", "$T.$L", new Object[]{WireField.Label.class, field.label()});
            }
        }
        if (JavaGenerator.isRedacted(field)) {
            result.addMember("redacted", "true", new Object[0]);
        }
        return result.build();
    }

    private String adapterString(ProtoType type) {
        return type.isScalar() ? ProtoAdapter.class.getName() + '#' + type.toString().toUpperCase(Locale.US) : this.reflectionName((ClassName)this.typeName(type)) + "#ADAPTER";
    }

    private String reflectionName(ClassName className) {
        return className.packageName() + '.' + Joiner.on((char)'$').join((Iterable)className.simpleNames());
    }

    private MethodSpec messageFieldsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder();
        result.addModifiers(new Modifier[]{Modifier.PUBLIC});
        result.addCode("this(", new Object[0]);
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String fieldName = nameAllocator.get((Object)field);
            result.addParameter(javaType, fieldName, new Modifier[0]);
            result.addCode("$L, ", new Object[]{fieldName});
        }
        result.addCode("$T.EMPTY);\n", new Object[]{BYTE_STRING});
        return result.build();
    }

    private MethodSpec messageFieldsAndUnknownFieldsConstructor(NameAllocator nameAllocator, MessageType type) {
        String unknownFieldsName = nameAllocator.get((Object)"unknownFields");
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($N)", new Object[]{unknownFieldsName});
        for (OneOf oneOf : type.oneOfs()) {
            if (oneOf.fields().size() < 2) continue;
            CodeBlock.Builder fieldNamesBuilder = CodeBlock.builder();
            boolean first = true;
            for (Field field : oneOf.fields()) {
                if (!first) {
                    fieldNamesBuilder.add(", ", new Object[0]);
                }
                fieldNamesBuilder.add("$N", new Object[]{nameAllocator.get((Object)field)});
                first = false;
            }
            CodeBlock fieldNames = fieldNamesBuilder.build();
            result.beginControlFlow("if (countNonNull($L) > 1)", new Object[]{fieldNames});
            result.addStatement("throw new IllegalArgumentException($S)", new Object[]{"at most one of " + fieldNames + " may be non-null"});
            result.endControlFlow();
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String fieldName = nameAllocator.get((Object)field);
            result.addParameter(javaType, fieldName, new Modifier[0]);
            if (field.isRepeated()) {
                result.addStatement("this.$1L = immutableCopyOf($1S, $1L)", new Object[]{fieldName});
                continue;
            }
            result.addStatement("this.$1L = $1L", new Object[]{fieldName});
        }
        result.addParameter((TypeName)BYTE_STRING, unknownFieldsName, new Modifier[0]);
        return result.build();
    }

    private MethodSpec messageEquals(NameAllocator nameAllocator, MessageType type) {
        String otherName = nameAllocator.get((Object)"other");
        String oName = nameAllocator.get((Object)"o");
        TypeName javaType = this.typeName(type.type());
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, otherName, new Modifier[0]);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.isEmpty()) {
            result.addStatement("return $N instanceof $T", new Object[]{otherName, javaType});
            return result.build();
        }
        result.addStatement("if ($N == this) return true", new Object[]{otherName});
        result.addStatement("if (!($N instanceof $T)) return false", new Object[]{otherName, javaType});
        result.addStatement("$T $N = ($T) $N", new Object[]{javaType, oName, javaType, otherName});
        result.addCode("$[return equals(unknownFields(), $N.unknownFields())", new Object[]{oName});
        for (Field field : fields) {
            String fieldName = nameAllocator.get((Object)field);
            result.addCode("\n&& equals($L, $N.$L)", new Object[]{fieldName, oName, fieldName});
        }
        result.addCode(";\n$]", new Object[0]);
        return result.build();
    }

    private MethodSpec messageHashCode(NameAllocator nameAllocator, MessageType type) {
        String resultName = nameAllocator.get((Object)"result");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.isEmpty()) {
            result.addStatement("return unknownFields().hashCode()", new Object[0]);
            return result.build();
        }
        result.addStatement("int $N = super.hashCode", new Object[]{resultName});
        result.beginControlFlow("if ($N == 0)", new Object[]{resultName});
        result.addStatement("$N = unknownFields().hashCode()", new Object[]{resultName});
        for (Field field : fields) {
            String fieldName = nameAllocator.get((Object)field);
            result.addStatement("$N = $N * 37 + ($L != null ? $L.hashCode() : $L)", new Object[]{resultName, resultName, fieldName, fieldName, this.nullHashValue(field)});
        }
        result.addStatement("super.hashCode = $N", new Object[]{resultName});
        result.endControlFlow();
        result.addStatement("return $N", new Object[]{resultName});
        return result.build();
    }

    private MethodSpec messageToString(NameAllocator nameAllocator, MessageType type) {
        String builderName = nameAllocator.get((Object)"builder");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        result.addStatement("$1T $2N = new $1T()", new Object[]{StringBuilder.class, builderName});
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            if (JavaGenerator.isRedacted(field)) {
                result.addStatement("if ($L != null) $N.append(\", $N=\u2588\u2588\")", new Object[]{fieldName, builderName, field.name()});
                continue;
            }
            result.addStatement("if ($1L != null) $2N.append(\", $3N=\").append($1L)", new Object[]{fieldName, builderName, field.name()});
        }
        result.addStatement("return builder.replace(0, 2, \"$L{\").append('}').toString()", new Object[]{type.type().simpleName()});
        return result.build();
    }

    private TypeSpec builder(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderType) {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        result.superclass(JavaGenerator.builderOf((TypeName)javaType, builderType));
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            result.addField(this.fieldType(field), fieldName, new Modifier[]{Modifier.PUBLIC});
        }
        result.addMethod(this.builderNoArgsConstructor(nameAllocator, type));
        for (Field field : type.fields()) {
            result.addMethod(this.setter(nameAllocator, (TypeName)builderType, null, field));
        }
        for (OneOf oneOf : type.oneOfs()) {
            for (Field field : oneOf.fields()) {
                result.addMethod(this.setter(nameAllocator, (TypeName)builderType, oneOf, field));
            }
        }
        result.addMethod(this.builderBuild(nameAllocator, type, javaType));
        return result.build();
    }

    private MethodSpec builderNoArgsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Field field : type.fieldsAndOneOfFields()) {
            if (!field.isPacked() && !field.isRepeated()) continue;
            String fieldName = nameAllocator.get((Object)field);
            result.addStatement("$L = newMutableList()", new Object[]{fieldName});
        }
        return result.build();
    }

    private MethodSpec newBuilder(NameAllocator nameAllocator, MessageType message) {
        String builderName = nameAllocator.get((Object)"builder");
        ClassName javaType = (ClassName)this.typeName(message.type());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"newBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderJavaType).addStatement("$1T $2L = new $1T()", new Object[]{builderJavaType, builderName});
        ImmutableList fields = message.fieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldName = nameAllocator.get((Object)field);
            if (field.isRepeated()) {
                result.addStatement("$1L.$2L = copyOf($2S, $2L)", new Object[]{builderName, fieldName});
                continue;
            }
            result.addStatement("$1L.$2L = $2L", new Object[]{builderName, fieldName});
        }
        result.addStatement("$L.addUnknownFields(unknownFields())", new Object[]{builderName});
        result.addStatement("return $L", new Object[]{builderName});
        return result.build();
    }

    private MethodSpec setter(NameAllocator nameAllocator, TypeName builderType, OneOf oneOf, Field field) {
        TypeName javaType = this.fieldType(field);
        String fieldName = nameAllocator.get((Object)field);
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(javaType, fieldName, new Modifier[0]).returns(builderType);
        if (!field.documentation().isEmpty()) {
            result.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
        }
        if (field.isDeprecated()) {
            result.addAnnotation(Deprecated.class);
        }
        if (field.isRepeated()) {
            result.addStatement("checkElementsNotNull($L)", new Object[]{fieldName});
        }
        result.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
        if (oneOf != null) {
            for (Field other : oneOf.fields()) {
                if (field == other) continue;
                result.addStatement("this.$L = null", new Object[]{nameAllocator.get((Object)other)});
            }
        }
        result.addStatement("return this", new Object[0]);
        return result.build();
    }

    private MethodSpec builderBuild(NameAllocator nameAllocator, MessageType message, ClassName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType);
        ImmutableList requiredFields = message.getRequiredFields();
        if (!requiredFields.isEmpty()) {
            CodeBlock.Builder conditionals = CodeBlock.builder().add("$[", new Object[0]);
            CodeBlock.Builder missingArgs = CodeBlock.builder();
            for (int i = 0; i < requiredFields.size(); ++i) {
                Field requiredField = (Field)requiredFields.get(i);
                if (i > 0) {
                    conditionals.add("\n|| ", new Object[0]);
                }
                conditionals.add("$L == null", new Object[]{requiredField.name()});
                if (i > 0) {
                    missingArgs.add(",\n", new Object[0]);
                }
                missingArgs.add("$1L, $1S", new Object[]{requiredField.name()});
            }
            result.beginControlFlow("if ($L)", new Object[]{conditionals.add("$]", new Object[0]).build()}).addStatement("throw missingRequiredFields($L)", new Object[]{missingArgs.build()}).endControlFlow();
        }
        result.addCode("return new $T(", new Object[]{javaType});
        for (Field field : message.fieldsAndOneOfFields()) {
            result.addCode("$L, ", new Object[]{nameAllocator.get((Object)field)});
        }
        result.addCode("buildUnknownFields());\n", new Object[0]);
        return result.build();
    }

    private CodeBlock defaultValue(Field field) {
        String defaultValue = field.getDefault();
        if (defaultValue == null && this.isEnum(field.type())) {
            defaultValue = this.enumDefault(field.type()).name();
        }
        if (field.type().isScalar() || defaultValue != null) {
            return this.fieldInitializer(field.type(), defaultValue);
        }
        throw new IllegalStateException("Field " + field + " cannot have default value");
    }

    private CodeBlock fieldInitializer(ProtoType type, Object value) {
        TypeName javaType = this.typeName(type);
        if (value instanceof List) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.asList(", new Object[]{Arrays.class});
            boolean first = true;
            for (Object o : (List)value) {
                if (!first) {
                    builder.add(",", new Object[0]);
                }
                first = false;
                builder.add("\n$>$>$L$<$<", new Object[]{this.fieldInitializer(type, o)});
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
        if (value instanceof Map) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T.Builder()", new Object[]{javaType});
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ProtoMember protoMember = (ProtoMember)entry.getKey();
                Field field = this.schema.getField(protoMember);
                CodeBlock valueInitializer = this.fieldInitializer(field.type(), entry.getValue());
                builder.add("\n$>$>.$L($L)$<$<", new Object[]{this.fieldName(type, field), valueInitializer});
            }
            builder.add("\n$>$>.build()$<$<", new Object[0]);
            return builder.build();
        }
        if (javaType.equals(TypeName.BOOLEAN.box())) {
            return JavaGenerator.codeBlock("$L", value != null ? value : Boolean.valueOf(false));
        }
        if (javaType.equals(TypeName.INT.box())) {
            return JavaGenerator.codeBlock("$L", value != null ? new BigDecimal(String.valueOf(value)).intValue() : 0);
        }
        if (javaType.equals(TypeName.LONG.box())) {
            return JavaGenerator.codeBlock("$LL", value != null ? Long.toString(new BigDecimal(String.valueOf(value)).longValue()) : Long.valueOf(0L));
        }
        if (javaType.equals(TypeName.FLOAT.box())) {
            return JavaGenerator.codeBlock("$Lf", value != null ? String.valueOf(value) : Float.valueOf(0.0f));
        }
        if (javaType.equals(TypeName.DOUBLE.box())) {
            return JavaGenerator.codeBlock("$Ld", value != null ? String.valueOf(value) : Double.valueOf(0.0));
        }
        if (javaType.equals(STRING)) {
            return JavaGenerator.codeBlock("$S", value != null ? (String)value : "");
        }
        if (javaType.equals(BYTE_STRING)) {
            if (value == null) {
                return JavaGenerator.codeBlock("$T.EMPTY", ByteString.class);
            }
            return JavaGenerator.codeBlock("$T.decodeBase64($S)", ByteString.class, ByteString.of((byte[])String.valueOf(value).getBytes(Charsets.ISO_8859_1)).base64());
        }
        if (this.isEnum(type) && value != null) {
            return JavaGenerator.codeBlock("$T.$L", javaType, value);
        }
        throw new IllegalStateException(type + " is not an allowed scalar type");
    }

    private static CodeBlock codeBlock(String format, Object ... args) {
        return CodeBlock.builder().add(format, args).build();
    }

    private int nullHashValue(Field field) {
        return field.isRepeated() ? 1 : 0;
    }
}

