/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.internal.FieldBinding;
import com.squareup.wire.internal.JsonIntegration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J \u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J(\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0003\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0003\u00a8\u0006\u0017"}, d2={"Lcom/squareup/wire/GsonJsonIntegration;", "Lcom/squareup/wire/internal/JsonIntegration;", "Lcom/google/gson/Gson;", "Lcom/google/gson/TypeAdapter;", "", "()V", "formatterAdapter", "jsonFormatter", "Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;", "frameworkAdapter", "framework", "type", "Ljava/lang/reflect/Type;", "listAdapter", "elementAdapter", "mapAdapter", "keyType", "valueType", "structAdapter", "serializeNulls", "T", "FormatterJsonAdapter", "ListJsonAdapter", "wire-gson-support"})
public final class GsonJsonIntegration
extends JsonIntegration<Gson, TypeAdapter<Object>> {
    public static final GsonJsonIntegration INSTANCE;

    @NotNull
    public TypeAdapter<Object> frameworkAdapter(@NotNull Gson framework, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        TypeAdapter typeAdapter = framework.getAdapter(TypeToken.get((Type)type)).nullSafe();
        if (typeAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public TypeAdapter<Object> listAdapter(@NotNull TypeAdapter<Object> elementAdapter) {
        Intrinsics.checkParameterIsNotNull(elementAdapter, (String)"elementAdapter");
        TypeAdapter typeAdapter = new ListJsonAdapter<Object>(elementAdapter).nullSafe();
        if (typeAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public TypeAdapter<Object> mapAdapter(@NotNull Gson framework, @NotNull Type keyType, @NotNull Type valueType) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        TypeToken mapType = TypeToken.getParameterized((Type)((Type)((Object)Map.class)), (Type[])new Type[]{keyType, valueType});
        TypeAdapter typeAdapter = framework.getAdapter(mapType);
        if (typeAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public final <T> TypeAdapter<T> serializeNulls(@NotNull TypeAdapter<T> $this$serializeNulls) {
        Intrinsics.checkParameterIsNotNull($this$serializeNulls, (String)"$this$serializeNulls");
        TypeAdapter<T> delegate = $this$serializeNulls;
        return new TypeAdapter<T>(delegate){
            final /* synthetic */ TypeAdapter $delegate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@NotNull JsonWriter writer, T value) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                boolean oldSerializeNulls = writer.getSerializeNulls();
                writer.setSerializeNulls(true);
                try {
                    this.$delegate.write(writer, value);
                }
                finally {
                    writer.setSerializeNulls(oldSerializeNulls);
                }
            }

            public T read(@NotNull JsonReader reader) {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                return (T)this.$delegate.read(reader);
            }
            {
                this.$delegate = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public TypeAdapter<Object> structAdapter(@NotNull Gson framework) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        TypeAdapter typeAdapter = framework.getAdapter(Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeAdapter, (String)"framework.getAdapter(Object::class.java)");
        TypeAdapter typeAdapter2 = this.serializeNulls(typeAdapter).nullSafe();
        if (typeAdapter2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter2;
    }

    @NotNull
    public TypeAdapter<Object> formatterAdapter(@NotNull FieldBinding.JsonFormatter<?> jsonFormatter) {
        Intrinsics.checkParameterIsNotNull(jsonFormatter, (String)"jsonFormatter");
        TypeAdapter typeAdapter = new FormatterJsonAdapter(jsonFormatter).nullSafe();
        if (typeAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    private GsonJsonIntegration() {
    }

    static {
        GsonJsonIntegration gsonJsonIntegration;
        INSTANCE = gsonJsonIntegration = new GsonJsonIntegration();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/GsonJsonIntegration$FormatterJsonAdapter;", "T", "", "Lcom/google/gson/TypeAdapter;", "formatter", "Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;", "(Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V", "wire-gson-support"})
    private static final class FormatterJsonAdapter<T>
    extends TypeAdapter<T> {
        private final FieldBinding.JsonFormatter<T> formatter;

        public void write(@NotNull JsonWriter writer, @NotNull T value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Object stringOrNumber = this.formatter.toStringOrNumber(value);
            if (stringOrNumber instanceof Number) {
                writer.value((Number)stringOrNumber);
            } else {
                Object object = stringOrNumber;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.value((String)object);
            }
        }

        @Nullable
        public T read(@NotNull JsonReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            String string = reader.nextString();
            try {
                String string2 = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
                return (T)this.formatter.fromString(string2);
            }
            catch (RuntimeException _) {
                throw (Throwable)new JsonSyntaxException("decode failed: " + string + " at path " + reader.getPath());
            }
        }

        public FormatterJsonAdapter(@NotNull FieldBinding.JsonFormatter<T> formatter) {
            Intrinsics.checkParameterIsNotNull(formatter, (String)"formatter");
            this.formatter = formatter;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/GsonJsonIntegration$ListJsonAdapter;", "T", "Lcom/google/gson/TypeAdapter;", "", "single", "(Lcom/google/gson/TypeAdapter;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "value", "wire-gson-support"})
    private static final class ListJsonAdapter<T>
    extends TypeAdapter<List<? extends T>> {
        private final TypeAdapter<T> single;

        @NotNull
        public List<T> read(@NotNull JsonReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            boolean bl = false;
            List result = new ArrayList();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.single.read(reader));
            }
            reader.endArray();
            return result;
        }

        public void write(@NotNull JsonWriter writer, @Nullable List<? extends T> value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            writer.beginArray();
            List<T> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (T v : list) {
                this.single.write(writer, v);
            }
            writer.endArray();
        }

        public ListJsonAdapter(@NotNull TypeAdapter<T> single) {
            Intrinsics.checkParameterIsNotNull(single, (String)"single");
            this.single = single;
        }
    }
}

