/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.FieldBinding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.WireField;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class MessageTypeAdapter<M extends Message<M, B>, B extends Message.Builder<M, B>>
extends TypeAdapter<M> {
    private static final BigInteger POWER_64 = new BigInteger("18446744073709551616");
    private final Gson gson;
    private final RuntimeMessageAdapter<M, B> messageAdapter;
    private final Map<String, FieldBinding<M, B>> fieldBindings;

    MessageTypeAdapter(Gson gson, TypeToken<M> type) {
        this.gson = gson;
        this.messageAdapter = RuntimeMessageAdapter.create((Class)type.getRawType());
        LinkedHashMap<String, FieldBinding> fieldBindings = new LinkedHashMap<String, FieldBinding>();
        for (FieldBinding binding : this.messageAdapter.fieldBindings().values()) {
            fieldBindings.put(binding.name, binding);
        }
        this.fieldBindings = Collections.unmodifiableMap(fieldBindings);
    }

    public void write(JsonWriter out, @Nullable M message) throws IOException {
        if (message == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (FieldBinding tagBinding : this.messageAdapter.fieldBindings().values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            out.name(tagBinding.name);
            this.emitJson(out, value, tagBinding.singleAdapter(), tagBinding.label);
        }
        out.endObject();
    }

    private void emitJson(JsonWriter out, Object value, ProtoAdapter<?> adapter, WireField.Label label) throws IOException {
        if (adapter == ProtoAdapter.UINT64) {
            if (label.isRepeated()) {
                List longs = (List)value;
                out.beginArray();
                int count = longs.size();
                for (int i = 0; i < count; ++i) {
                    this.emitUint64((Long)longs.get(i), out);
                }
                out.endArray();
            } else {
                this.emitUint64((Long)value, out);
            }
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    private void emitUint64(Long value, JsonWriter out) throws IOException {
        if (value < 0L) {
            BigInteger unsigned = POWER_64.add(BigInteger.valueOf(value));
            out.value((Number)unsigned);
        } else {
            out.value((Number)value);
        }
    }

    @Nullable
    public M read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        TypeAdapter elementAdapter = this.gson.getAdapter(JsonElement.class);
        Message.Builder builder = this.messageAdapter.newBuilder();
        in.beginObject();
        while (in.peek() != JsonToken.END_OBJECT) {
            String name = in.nextName();
            FieldBinding<M, B> fieldBinding = this.fieldBindings.get(name);
            if (fieldBinding == null) {
                in.skipValue();
                continue;
            }
            JsonElement element = (JsonElement)elementAdapter.read(in);
            Object value = this.parseValue(fieldBinding, element);
            fieldBinding.set(builder, value);
        }
        in.endObject();
        return (M)builder.build();
    }

    private Object parseValue(FieldBinding<?, ?> fieldBinding, JsonElement element) {
        if (fieldBinding.label.isRepeated()) {
            if (element.isJsonNull()) {
                return Collections.emptyList();
            }
            Class itemType = fieldBinding.singleAdapter().javaType;
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> result = new ArrayList<Object>(array.size());
            for (JsonElement item : array) {
                result.add(this.gson.fromJson(item, itemType));
            }
            return result;
        }
        if (fieldBinding.isMap()) {
            if (element.isJsonNull()) {
                return Collections.emptyMap();
            }
            Class keyType = fieldBinding.keyAdapter().javaType;
            Class valueType = fieldBinding.singleAdapter().javaType;
            JsonObject object = element.getAsJsonObject();
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(object.size());
            for (Map.Entry entry : object.entrySet()) {
                Object key = this.gson.fromJson((String)entry.getKey(), keyType);
                Object value = this.gson.fromJson((JsonElement)entry.getValue(), valueType);
                result.put(key, value);
            }
            return result;
        }
        Class elementType = fieldBinding.singleAdapter().javaType;
        return this.gson.fromJson(element, elementType);
    }
}

