/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcDecoder;
import com.squareup.wire.GrpcDecoderKt;
import com.squareup.wire.MessageSource;
import com.squareup.wire.ProtoAdapter;
import java.io.Closeable;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\rH\u0096\u0001J\u000f\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/GrpcMessageSource;", "T", "", "Lcom/squareup/wire/MessageSource;", "Ljava/io/Closeable;", "source", "Lokio/BufferedSource;", "messageAdapter", "Lcom/squareup/wire/ProtoAdapter;", "grpcEncoding", "", "(Lokio/BufferedSource;Lcom/squareup/wire/ProtoAdapter;Ljava/lang/String;)V", "close", "", "read", "()Ljava/lang/Object;", "wire-grpc-client"})
public final class GrpcMessageSource<T>
implements MessageSource<T>,
Closeable {
    private final BufferedSource source;
    private final ProtoAdapter<T> messageAdapter;
    private final String grpcEncoding;

    @Nullable
    public T read() {
        Object object;
        if (this.source.exhausted()) {
            return null;
        }
        byte compressedFlag = this.source.readByte();
        if (compressedFlag == 0) {
            object = GrpcDecoder.IdentityGrpcDecoder.INSTANCE;
        } else if (compressedFlag == 1) {
            object = this.grpcEncoding;
            if (object == null || (object = GrpcDecoderKt.toGrpcDecoding((String)object)) == null) {
                throw (Throwable)new ProtocolException("message is encoded but message-encoding header was omitted");
            }
        } else {
            throw (Throwable)new ProtocolException("unexpected compressed-flag: " + compressedFlag);
        }
        GrpcDecoder messageDecoding = object;
        long encodedLength = (long)this.source.readInt() & 0xFFFFFFFFL;
        Buffer encodedMessage = new Buffer();
        encodedMessage.write((Source)this.source, encodedLength);
        return (T)this.messageAdapter.decode(Okio.buffer((Source)messageDecoding.decode((BufferedSource)encodedMessage)));
    }

    public GrpcMessageSource(@NotNull BufferedSource source, @NotNull ProtoAdapter<T> messageAdapter, @Nullable String grpcEncoding) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(messageAdapter, (String)"messageAdapter");
        this.source = source;
        this.messageAdapter = messageAdapter;
        this.grpcEncoding = grpcEncoding;
    }

    public /* synthetic */ GrpcMessageSource(BufferedSource bufferedSource, ProtoAdapter protoAdapter, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(bufferedSource, protoAdapter, string);
    }

    @Override
    public void close() {
        this.source.close();
    }
}

