/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.MessageSource;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.internal.GrpcKt;
import com.squareup.wire.internal.GrpcMessageSource;
import com.squareup.wire.internal.RealGrpcStreamingCall;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u001a\u001bB/\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/squareup/wire/internal/BlockingMessageSource;", "R", "", "Lcom/squareup/wire/MessageSource;", "grpcCall", "Lcom/squareup/wire/internal/RealGrpcStreamingCall;", "responseAdapter", "Lcom/squareup/wire/ProtoAdapter;", "call", "Lokhttp3/Call;", "<init>", "(Lcom/squareup/wire/internal/RealGrpcStreamingCall;Lcom/squareup/wire/ProtoAdapter;Lokhttp3/Call;)V", "getGrpcCall", "()Lcom/squareup/wire/internal/RealGrpcStreamingCall;", "getResponseAdapter", "()Lcom/squareup/wire/ProtoAdapter;", "getCall", "()Lokhttp3/Call;", "queue", "Ljava/util/concurrent/LinkedBlockingDeque;", "read", "()Ljava/lang/Object;", "close", "", "readFromResponseBodyCallback", "Lokhttp3/Callback;", "Complete", "Failure", "wire-grpc-client"})
public final class BlockingMessageSource<R>
implements MessageSource<R> {
    @NotNull
    private final RealGrpcStreamingCall<?, R> grpcCall;
    @NotNull
    private final ProtoAdapter<R> responseAdapter;
    @NotNull
    private final Call call;
    @NotNull
    private final LinkedBlockingDeque<Object> queue;

    public BlockingMessageSource(@NotNull RealGrpcStreamingCall<?, R> grpcCall, @NotNull ProtoAdapter<R> responseAdapter, @NotNull Call call) {
        Intrinsics.checkNotNullParameter(grpcCall, (String)"grpcCall");
        Intrinsics.checkNotNullParameter(responseAdapter, (String)"responseAdapter");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.grpcCall = grpcCall;
        this.responseAdapter = responseAdapter;
        this.call = call;
        this.queue = new LinkedBlockingDeque(1);
    }

    @NotNull
    public final RealGrpcStreamingCall<?, R> getGrpcCall() {
        return this.grpcCall;
    }

    @NotNull
    public final ProtoAdapter<R> getResponseAdapter() {
        return this.responseAdapter;
    }

    @NotNull
    public final Call getCall() {
        return this.call;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public R read() {
        R r;
        Object result = this.queue.take();
        if (result instanceof Complete) {
            this.queue.put(result);
            r = null;
        } else {
            void var1_1;
            if (result instanceof Failure) {
                this.queue.put(result);
                throw ((Failure)result).getE();
            }
            Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type R of com.squareup.wire.internal.BlockingMessageSource");
            r = var1_1;
        }
        return r;
    }

    public void close() {
        this.call.cancel();
    }

    @NotNull
    public final Callback readFromResponseBodyCallback() {
        return new Callback(this){
            final /* synthetic */ BlockingMessageSource<R> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BlockingMessageSource.access$getQueue$p(this.this$0).put(new Failure(e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    this.this$0.getGrpcCall().setResponseMetadata$wire_grpc_client(MapsKt.toMap((Iterable)((Iterable)response.headers())));
                    Closeable closeable = (Closeable)response;
                    BlockingMessageSource<R> blockingMessageSource = this.this$0;
                    Throwable throwable = null;
                    try {
                        Response it = (Response)closeable;
                        boolean bl = false;
                        Closeable closeable2 = (Closeable)((Object)GrpcKt.messageSource(response, blockingMessageSource.getResponseAdapter()));
                        Throwable throwable2 = null;
                        try {
                            IOException exception;
                            GrpcMessageSource reader = (GrpcMessageSource)((Object)closeable2);
                            boolean bl2 = false;
                            while (reader.read() != null) {
                                T message;
                                BlockingMessageSource.access$getQueue$p(blockingMessageSource).put(message);
                            }
                            IOException iOException = exception = GrpcKt.grpcResponseToException$default(response, null, 1, null);
                            if (iOException != null) {
                                throw iOException;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    BlockingMessageSource.access$getQueue$p(this.this$0).put(Complete.INSTANCE);
                }
                catch (IOException e) {
                    call.cancel();
                    BlockingMessageSource.access$getQueue$p(this.this$0).put(new Failure(e));
                }
            }
        };
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getQueue$p(BlockingMessageSource $this) {
        return $this.queue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/squareup/wire/internal/BlockingMessageSource$Complete;", "", "<init>", "()V", "wire-grpc-client"})
    private static final class Complete {
        @NotNull
        public static final Complete INSTANCE = new Complete();

        private Complete() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/BlockingMessageSource$Failure;", "", "e", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "(Ljava/io/IOException;)V", "getE", "()Ljava/io/IOException;", "wire-grpc-client"})
    private static final class Failure {
        @NotNull
        private final IOException e;

        public Failure(@NotNull IOException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.e = e;
        }

        @NotNull
        public final IOException getE() {
            return this.e;
        }
    }
}

