/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CoreLoaderKt;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaHandler;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J4\u0010\u0013\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/squareup/wire/schema/ProtoTarget;", "Lcom/squareup/wire/schema/Target;", "outDirectory", "", "(Ljava/lang/String;)V", "excludes", "", "getExcludes", "()Ljava/util/List;", "exclusive", "", "getExclusive", "()Z", "includes", "getIncludes", "getOutDirectory", "()Ljava/lang/String;", "component1", "copy", "copyTarget", "equals", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/SchemaHandler;", "toString", "wire-compiler"})
public final class ProtoTarget
extends Target {
    @NotNull
    private final String outDirectory;
    @NotNull
    private final List<String> includes;
    @NotNull
    private final List<String> excludes;
    private final boolean exclusive;

    public ProtoTarget(@NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter((Object)outDirectory, (String)"outDirectory");
        this.outDirectory = outDirectory;
        this.includes = CollectionsKt.emptyList();
        this.excludes = CollectionsKt.emptyList();
    }

    @NotNull
    public String getOutDirectory() {
        return this.outDirectory;
    }

    @NotNull
    public List<String> getIncludes() {
        return this.includes;
    }

    @NotNull
    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean getExclusive() {
        return this.exclusive;
    }

    @NotNull
    public SchemaHandler newHandler() {
        return new SchemaHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void handle(@NotNull Schema schema, @NotNull SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                context.getFileSystem().createDirectories(context.getOutDirectory());
                Path outDirectory = context.getOutDirectory();
                for (ProtoFile protoFile : schema.getProtoFiles()) {
                    if (!context.inSourcePath(protoFile) || this.isEmpty(protoFile) || CoreLoaderKt.isWireRuntimeProto((String)protoFile.getLocation().getPath())) continue;
                    String relativePath = StringsKt.substringBeforeLast((String)protoFile.getLocation().getPath(), (String)"/", (String)".");
                    Path outputDirectory = outDirectory.resolve(relativePath);
                    Path outputFilePath = outputDirectory.resolve(protoFile.name() + ".proto");
                    context.getLogger().artifactHandled(outputDirectory, protoFile.getLocation().getPath(), "Proto");
                    try {
                        BufferedSink bufferedSink;
                        Throwable thrown$iv$iv;
                        block17: {
                            FileSystem fileSystem = context.getFileSystem();
                            Path path = outputFilePath.parent();
                            Intrinsics.checkNotNull((Object)path);
                            fileSystem.createDirectories(path);
                            FileSystem $this$iv = context.getFileSystem();
                            boolean mustCreate$iv = false;
                            boolean bl = false;
                            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(outputFilePath, mustCreate$iv));
                            boolean $i$f$use = false;
                            thrown$iv$iv = null;
                            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                            boolean bl2 = false;
                            BufferedSink $this$handle_u24lambda_u240 = it$iv;
                            boolean bl3 = false;
                            bufferedSink = $this$handle_u24lambda_u240.writeUtf8(protoFile.toSchema());
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                                break block17;
                            }
                            catch (Throwable t$iv$iv) {
                                thrown$iv$iv = t$iv$iv;
                            }
                            break block17;
                            catch (Throwable t$iv$iv) {
                                try {
                                    thrown$iv$iv = t$iv$iv;
                                    bufferedSink = null;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    block18: {
                                        try {
                                            Closeable closeable = $this$use$iv$iv;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv$iv2) {
                                            if (thrown$iv$iv == null) {
                                                thrown$iv$iv = t$iv$iv2;
                                                break block18;
                                            }
                                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                        }
                                    }
                                }
                            }
                        }
                        BufferedSink result$iv$iv = bufferedSink;
                        Throwable throwable = thrown$iv$iv;
                        if (throwable == null) continue;
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOException("Error emitting " + outputFilePath + " to " + outDirectory, e);
                    }
                }
            }

            private final boolean isEmpty(ProtoFile $this$isEmpty) {
                return $this$isEmpty.getTypes().isEmpty() && $this$isEmpty.getServices().isEmpty() && $this$isEmpty.getExtendList().isEmpty();
            }

            @Nullable
            public Path handle(@NotNull Type type, @NotNull SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return null;
            }

            @NotNull
            public List<Path> handle(@NotNull Service service, @NotNull SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return CollectionsKt.emptyList();
            }

            @Nullable
            public Path handle(@NotNull Extend extend, @NotNull Field field, @NotNull SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter((Object)extend, (String)"extend");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return null;
            }
        };
    }

    @NotNull
    public Target copyTarget(@NotNull List<String> includes, @NotNull List<String> excludes, boolean exclusive, @NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)outDirectory, (String)"outDirectory");
        return this.copy(outDirectory);
    }

    @NotNull
    public final String component1() {
        return this.outDirectory;
    }

    @NotNull
    public final ProtoTarget copy(@NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter((Object)outDirectory, (String)"outDirectory");
        return new ProtoTarget(outDirectory);
    }

    public static /* synthetic */ ProtoTarget copy$default(ProtoTarget protoTarget, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = protoTarget.outDirectory;
        }
        return protoTarget.copy(string);
    }

    @NotNull
    public String toString() {
        return "ProtoTarget(outDirectory=" + this.outDirectory + ')';
    }

    public int hashCode() {
        return this.outDirectory.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtoTarget)) {
            return false;
        }
        ProtoTarget protoTarget = (ProtoTarget)((Object)other);
        return Intrinsics.areEqual((Object)this.outDirectory, (Object)protoTarget.outDirectory);
    }
}

