/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.schema.ClaimedDefinitions;
import com.squareup.wire.schema.EmittingRules;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProfileLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003Jo\u0010$\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001JK\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00042\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u0004002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0010\u00a2\u0006\u0002\b8J\t\u00109\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006:"}, d2={"Lcom/squareup/wire/schema/JavaTarget;", "Lcom/squareup/wire/schema/Target;", "includes", "", "", "excludes", "exclusive", "", "outDirectory", "android", "androidAnnotations", "compact", "emitDeclaredOptions", "emitAppliedOptions", "(Ljava/util/List;Ljava/util/List;ZLjava/lang/String;ZZZZZ)V", "getAndroid", "()Z", "getAndroidAnnotations", "getCompact", "getEmitAppliedOptions", "getEmitDeclaredOptions", "getExcludes", "()Ljava/util/List;", "getExclusive", "getIncludes", "getOutDirectory", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "moduleName", "upstreamTypes", "", "Lcom/squareup/wire/schema/ProtoType;", "fs", "Lokio/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "profileLoader", "Lcom/squareup/wire/schema/ProfileLoader;", "newHandler$wire_compiler", "toString", "wire-compiler"})
public final class JavaTarget
extends Target {
    @NotNull
    private final List<String> includes;
    @NotNull
    private final List<String> excludes;
    private final boolean exclusive;
    @NotNull
    private final String outDirectory;
    private final boolean android;
    private final boolean androidAnnotations;
    private final boolean compact;
    private final boolean emitDeclaredOptions;
    private final boolean emitAppliedOptions;

    @Override
    @NotNull
    public Target.SchemaHandler newHandler$wire_compiler(@NotNull Schema schema, @Nullable String moduleName, @NotNull Map<ProtoType, String> upstreamTypes, @NotNull FileSystem fs, @NotNull WireLogger logger, @NotNull ProfileLoader profileLoader) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(upstreamTypes, (String)"upstreamTypes");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)profileLoader, (String)"profileLoader");
        String profileName = this.android ? "android" : "java";
        Profile profile = profileLoader.loadProfile(profileName, schema);
        JavaTarget javaTarget = this;
        boolean bl = false;
        boolean bl2 = false;
        JavaTarget $this$run = javaTarget;
        boolean bl3 = false;
        Path outPath = Path.Companion.get($this$run.getOutDirectory());
        Path modulePath = moduleName != null ? outPath.resolve(moduleName) : outPath;
        fs.createDirectories(modulePath);
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withProfile(profile).withAndroid(this.android).withAndroidAnnotations(this.androidAnnotations).withCompact(this.compact).withOptions(this.emitDeclaredOptions, this.emitAppliedOptions);
        return new Target.SchemaHandler(this, javaGenerator, modulePath, logger, fs){
            final /* synthetic */ JavaTarget this$0;
            final /* synthetic */ JavaGenerator $javaGenerator;
            final /* synthetic */ Path $modulePath;
            final /* synthetic */ WireLogger $logger;
            final /* synthetic */ FileSystem $fs;

            @NotNull
            public Path handle(@NotNull Type type) {
                ClassName javaTypeName;
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                TypeSpec typeSpec = this.$javaGenerator.generateType(type);
                ClassName className = javaTypeName = this.$javaGenerator.generatedTypeName(type);
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"javaTypeName");
                TypeSpec typeSpec2 = typeSpec;
                Intrinsics.checkNotNullExpressionValue((Object)typeSpec2, (String)"typeSpec");
                return this.write(className, typeSpec2, type.getType(), type.getLocation());
            }

            @NotNull
            public List<Path> handle(@NotNull Service service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                return CollectionsKt.emptyList();
            }

            @Nullable
            public Path handle(@NotNull Extend extend, @NotNull Field field) {
                ClassName javaTypeName;
                Intrinsics.checkNotNullParameter((Object)extend, (String)"extend");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                TypeSpec typeSpec = this.$javaGenerator.generateOptionType(extend, field);
                if (typeSpec == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"javaGenerator.generateOp\u2026nd, field) ?: return null");
                TypeSpec typeSpec2 = typeSpec;
                ClassName className = javaTypeName = this.$javaGenerator.generatedTypeName(field);
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"javaTypeName");
                return this.write(className, typeSpec2, field.getQualifiedName(), field.getLocation());
            }

            private final Path write(ClassName javaTypeName, TypeSpec typeSpec, Object source, Location location) {
                JavaFile javaFile = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{"Code generated by Wire protocol buffer compiler, do not edit."}).addFileComment("\nSource: $L in $L", new Object[]{source, location.withPathOnly()}).build();
                String string = javaFile.packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaFile.packageName");
                Path filePath = this.$modulePath.resolve(StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null)).resolve(javaTypeName.simpleName() + ".java");
                JavaFile javaFile2 = javaFile;
                Intrinsics.checkNotNullExpressionValue((Object)javaFile2, (String)"javaFile");
                this.$logger.artifact(this.$modulePath, javaFile2);
                try {
                    Path path = filePath.parent();
                    Intrinsics.checkNotNull((Object)path);
                    this.$fs.createDirectories(path);
                    FileSystem this_$iv = this.$fs;
                    boolean $i$f$write = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(filePath));
                    boolean $i$f$use = false;
                    BufferedSink result$iv$iv = null;
                    Throwable thrown$iv$iv = null;
                    try {
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean bl = false;
                        BufferedSink $this$write = it$iv;
                        boolean bl2 = false;
                        String string2 = javaFile.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaFile.toString()");
                        result$iv$iv = $this$write.writeUtf8(string2);
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                    }
                    if (thrown$iv$iv != null) {
                        throw thrown$iv$iv;
                    }
                    Intrinsics.checkNotNull(result$iv$iv);
                }
                catch (IOException e) {
                    throw (Throwable)new IOException("Error emitting " + javaFile.packageName + '.' + javaFile.typeSpec.name + ' ' + "to " + this.this$0.getOutDirectory(), e);
                }
                return filePath;
            }
            {
                this.this$0 = this$0;
                this.$javaGenerator = $captured_local_variable$1;
                this.$modulePath = $captured_local_variable$2;
                this.$logger = $captured_local_variable$3;
                this.$fs = $captured_local_variable$4;
            }

            public void handle(@NotNull ProtoFile protoFile, @NotNull EmittingRules emittingRules, @NotNull ClaimedDefinitions claimedDefinitions, @NotNull Map<Path, String> claimedPaths, boolean isExclusive) {
                Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
                Intrinsics.checkNotNullParameter((Object)emittingRules, (String)"emittingRules");
                Intrinsics.checkNotNullParameter((Object)claimedDefinitions, (String)"claimedDefinitions");
                Intrinsics.checkNotNullParameter(claimedPaths, (String)"claimedPaths");
                Target.SchemaHandler.DefaultImpls.handle(this, protoFile, emittingRules, claimedDefinitions, claimedPaths, isExclusive);
            }
        };
    }

    @Override
    @NotNull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    @NotNull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean getExclusive() {
        return this.exclusive;
    }

    @Override
    @NotNull
    public String getOutDirectory() {
        return this.outDirectory;
    }

    public final boolean getAndroid() {
        return this.android;
    }

    public final boolean getAndroidAnnotations() {
        return this.androidAnnotations;
    }

    public final boolean getCompact() {
        return this.compact;
    }

    public final boolean getEmitDeclaredOptions() {
        return this.emitDeclaredOptions;
    }

    public final boolean getEmitAppliedOptions() {
        return this.emitAppliedOptions;
    }

    public JavaTarget(@NotNull List<String> includes, @NotNull List<String> excludes, boolean exclusive, @NotNull String outDirectory, boolean android, boolean androidAnnotations, boolean compact, boolean emitDeclaredOptions, boolean emitAppliedOptions) {
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)outDirectory, (String)"outDirectory");
        super(null);
        this.includes = includes;
        this.excludes = excludes;
        this.exclusive = exclusive;
        this.outDirectory = outDirectory;
        this.android = android;
        this.androidAnnotations = androidAnnotations;
        this.compact = compact;
        this.emitDeclaredOptions = emitDeclaredOptions;
        this.emitAppliedOptions = emitAppliedOptions;
    }

    public /* synthetic */ JavaTarget(List list, List list2, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)"*");
        }
        if ((n & 2) != 0) {
            boolean bl7 = false;
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        if ((n & 0x80) != 0) {
            bl5 = true;
        }
        if ((n & 0x100) != 0) {
            bl6 = false;
        }
        this(list, list2, bl, string, bl2, bl3, bl4, bl5, bl6);
    }

    @NotNull
    public final List<String> component1() {
        return this.getIncludes();
    }

    @NotNull
    public final List<String> component2() {
        return this.getExcludes();
    }

    public final boolean component3() {
        return this.getExclusive();
    }

    @NotNull
    public final String component4() {
        return this.getOutDirectory();
    }

    public final boolean component5() {
        return this.android;
    }

    public final boolean component6() {
        return this.androidAnnotations;
    }

    public final boolean component7() {
        return this.compact;
    }

    public final boolean component8() {
        return this.emitDeclaredOptions;
    }

    public final boolean component9() {
        return this.emitAppliedOptions;
    }

    @NotNull
    public final JavaTarget copy(@NotNull List<String> includes, @NotNull List<String> excludes, boolean exclusive, @NotNull String outDirectory, boolean android, boolean androidAnnotations, boolean compact, boolean emitDeclaredOptions, boolean emitAppliedOptions) {
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)outDirectory, (String)"outDirectory");
        return new JavaTarget(includes, excludes, exclusive, outDirectory, android, androidAnnotations, compact, emitDeclaredOptions, emitAppliedOptions);
    }

    public static /* synthetic */ JavaTarget copy$default(JavaTarget javaTarget, List list, List list2, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, Object object) {
        if ((n & 1) != 0) {
            list = javaTarget.getIncludes();
        }
        if ((n & 2) != 0) {
            list2 = javaTarget.getExcludes();
        }
        if ((n & 4) != 0) {
            bl = javaTarget.getExclusive();
        }
        if ((n & 8) != 0) {
            string = javaTarget.getOutDirectory();
        }
        if ((n & 0x10) != 0) {
            bl2 = javaTarget.android;
        }
        if ((n & 0x20) != 0) {
            bl3 = javaTarget.androidAnnotations;
        }
        if ((n & 0x40) != 0) {
            bl4 = javaTarget.compact;
        }
        if ((n & 0x80) != 0) {
            bl5 = javaTarget.emitDeclaredOptions;
        }
        if ((n & 0x100) != 0) {
            bl6 = javaTarget.emitAppliedOptions;
        }
        return javaTarget.copy(list, list2, bl, string, bl2, bl3, bl4, bl5, bl6);
    }

    @NotNull
    public String toString() {
        return "JavaTarget(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", exclusive=" + this.getExclusive() + ", outDirectory=" + this.getOutDirectory() + ", android=" + this.android + ", androidAnnotations=" + this.androidAnnotations + ", compact=" + this.compact + ", emitDeclaredOptions=" + this.emitDeclaredOptions + ", emitAppliedOptions=" + this.emitAppliedOptions + ")";
    }

    public int hashCode() {
        List<String> list = this.getIncludes();
        List<String> list2 = this.getExcludes();
        int n = ((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31;
        int n2 = this.getExclusive() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        String string = this.getOutDirectory();
        int n3 = ((n + n2) * 31 + (string != null ? string.hashCode() : 0)) * 31;
        int n4 = this.android ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        int n5 = (n3 + n4) * 31;
        int n6 = this.androidAnnotations ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        int n7 = (n5 + n6) * 31;
        int n8 = this.compact ? 1 : 0;
        if (n8 != 0) {
            n8 = 1;
        }
        int n9 = (n7 + n8) * 31;
        int n10 = this.emitDeclaredOptions ? 1 : 0;
        if (n10 != 0) {
            n10 = 1;
        }
        int n11 = (n9 + n10) * 31;
        int n12 = this.emitAppliedOptions ? 1 : 0;
        if (n12 != 0) {
            n12 = 1;
        }
        return n11 + n12;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JavaTarget)) break block3;
                JavaTarget javaTarget = (JavaTarget)object;
                if (!Intrinsics.areEqual(this.getIncludes(), javaTarget.getIncludes()) || !Intrinsics.areEqual(this.getExcludes(), javaTarget.getExcludes()) || this.getExclusive() != javaTarget.getExclusive() || !Intrinsics.areEqual((Object)this.getOutDirectory(), (Object)javaTarget.getOutDirectory()) || this.android != javaTarget.android || this.androidAnnotations != javaTarget.androidAnnotations || this.compact != javaTarget.compact || this.emitDeclaredOptions != javaTarget.emitDeclaredOptions || this.emitAppliedOptions != javaTarget.emitAppliedOptions) break block3;
            }
            return true;
        }
        return false;
    }
}

