/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.io.Closer;
import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.DirectoryRoot;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0002\u001a>\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001a\b\u0002\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0012H\u0000\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"UNICODE_BOMS", "Lokio/Options;", "endsWithDotProto", "", "Ljava/nio/file/Path;", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "roots", "", "Lcom/squareup/wire/schema/Root;", "Lcom/squareup/wire/schema/Location;", "fs", "Ljava/nio/file/FileSystem;", "closer", "Lcom/google/common/io/Closer;", "baseToRoots", "", "", "location", "wire-compiler"})
public final class RootKt {
    private static final Options UNICODE_BOMS = Options.Companion.of(new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")});

    @NotNull
    public static final List<Root> roots(@NotNull Location $this$roots, @NotNull FileSystem fs, @NotNull Closer closer, @NotNull Map<String, List<Root>> baseToRoots) {
        Intrinsics.checkParameterIsNotNull((Object)$this$roots, (String)"$this$roots");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        Intrinsics.checkParameterIsNotNull(baseToRoots, (String)"baseToRoots");
        if (CoreLoader.INSTANCE.isWireRuntimeProto($this$roots)) {
            Path path = Paths.get($this$roots.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(path)");
            return CollectionsKt.listOf((Object)new ProtoFilePath($this$roots, path));
        }
        CharSequence charSequence = $this$roots.getBase();
        boolean bl = false;
        if (charSequence.length() > 0) {
            List<Root> list = baseToRoots.computeIfAbsent($this$roots.getBase(), (Function<String, List<Root>>)new Function<String, List<? extends Root>>(fs, closer){
                final /* synthetic */ FileSystem $fs;
                final /* synthetic */ Closer $closer;

                @NotNull
                public final List<Root> apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return RootKt.roots$default(Location.Companion.get(it), this.$fs, this.$closer, null, 4, null);
                }
                {
                    this.$fs = fileSystem;
                    this.$closer = closer;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"baseToRoots.computeIfAbs\u2026).roots(fs, closer)\n    }");
            List<Root> roots2 = list;
            for (Root root : roots2) {
                ProtoFilePath protoFilePath = root.resolve($this$roots.getPath());
                if (protoFilePath == null) {
                    continue;
                }
                ProtoFilePath resolved = protoFilePath;
                return CollectionsKt.listOf((Object)resolved);
            }
            throw (Throwable)new IllegalArgumentException("unable to resolve " + $this$roots);
        }
        Path path = fs.getPath($this$roots.getPath(), new String[0]);
        List<Root> list = baseToRoots.computeIfAbsent($this$roots.getPath(), (Function<String, List<Root>>)new Function<String, List<? extends Root>>($this$roots, path, closer){
            final /* synthetic */ Location $this_roots;
            final /* synthetic */ Path $path;
            final /* synthetic */ Closer $closer;

            @NotNull
            public final List<Root> apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Path path = this.$path;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"path");
                return RootKt.access$roots(path, this.$closer, this.$this_roots);
            }
            {
                this.$this_roots = location;
                this.$path = path;
                this.$closer = closer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"baseToRoots.computeIfAbs\u2026roots(closer, this)\n    }");
        return list;
    }

    public static /* synthetic */ List roots$default(Location location, FileSystem fileSystem, Closer closer, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        return RootKt.roots(location, fileSystem, closer, map);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Root> roots(@NotNull Path $this$roots, Closer closer, Location location) {
        List list;
        if (Files.isDirectory($this$roots, new LinkOption[0])) {
            CharSequence charSequence = location.getBase();
            boolean bl = false;
            boolean bl2 = charSequence.length() == 0;
            bl = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            list = CollectionsKt.listOf((Object)new DirectoryRoot(location.getPath(), $this$roots));
        } else if (RootKt.endsWithDotProto($this$roots)) {
            list = CollectionsKt.listOf((Object)new ProtoFilePath(location, $this$roots));
        } else {
            List list2;
            CharSequence charSequence = location.getBase();
            boolean bl = false;
            boolean bl6 = charSequence.length() == 0;
            bl = false;
            boolean bl7 = false;
            bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            try {
                void $this$mapTo$iv$iv;
                FileSystem sourceFs = FileSystems.newFileSystem($this$roots, $this$roots.getClass().getClassLoader());
                closer.register((Closeable)sourceFs);
                FileSystem fileSystem = sourceFs;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"sourceFs");
                Iterable<Path> iterable = fileSystem.getRootDirectories();
                Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"sourceFs.rootDirectories");
                Iterable<Path> $this$map$iv = iterable;
                boolean $i$f$map = false;
                Iterable<Path> iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl10 = false;
                    String string = location.getPath();
                    void v4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                    DirectoryRoot directoryRoot = new DirectoryRoot(string, (Path)v4);
                    collection.add(directoryRoot);
                }
                list2 = (List)destination$iv$iv;
            }
            catch (ProviderNotFoundException e) {
                throw (Throwable)new IllegalArgumentException("expected a directory, archive (.zip / .jar / etc.), or .proto: " + $this$roots);
            }
            list = list2;
        }
        return list;
    }

    private static final boolean endsWithDotProto(@NotNull Path $this$endsWithDotProto) {
        return StringsKt.endsWith$default((String)((Object)$this$endsWithDotProto.getFileName()).toString(), (String)".proto", (boolean)false, (int)2, null);
    }

    private static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, Charset charset) {
        Charset charset2;
        switch ($this$readBomAsCharset.select(UNICODE_BOMS)) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        return charset2;
    }

    static /* synthetic */ Charset readBomAsCharset$default(BufferedSource bufferedSource, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return RootKt.readBomAsCharset(bufferedSource, charset);
    }

    public static final /* synthetic */ boolean access$endsWithDotProto(Path $this$access_u24endsWithDotProto) {
        return RootKt.endsWithDotProto($this$access_u24endsWithDotProto);
    }

    public static final /* synthetic */ List access$roots(Path $this$access_u24roots, Closer closer, Location location) {
        return RootKt.roots($this$access_u24roots, closer, location);
    }
}

