/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.PendingTypeFileSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/JavaFileWriter;", "Ljava/util/concurrent/Callable;", "", "destination", "", "javaGenerator", "Lcom/squareup/wire/java/JavaGenerator;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/squareup/wire/PendingTypeFileSpec;", "dryRun", "", "fs", "Ljava/nio/file/FileSystem;", "log", "Lcom/squareup/wire/WireLogger;", "(Ljava/lang/String;Lcom/squareup/wire/java/JavaGenerator;Ljava/util/concurrent/ConcurrentLinkedQueue;ZLjava/nio/file/FileSystem;Lcom/squareup/wire/WireLogger;)V", "call", "wire-compiler"})
public final class JavaFileWriter
implements Callable<Unit> {
    private final String destination;
    private final JavaGenerator javaGenerator;
    private final ConcurrentLinkedQueue<PendingTypeFileSpec> queue;
    private final boolean dryRun;
    private final FileSystem fs;
    private final WireLogger log;

    @Override
    public void call() throws IOException {
        PendingTypeFileSpec pendingTypeFileSpec;
        while ((pendingTypeFileSpec = this.queue.poll()) != null && (pendingTypeFileSpec = pendingTypeFileSpec.getType()) != null) {
            Path path;
            PendingTypeFileSpec type = pendingTypeFileSpec;
            TypeSpec typeSpec = this.javaGenerator.generateType((Type)type);
            ClassName javaTypeName = this.javaGenerator.generatedTypeName((Type)type);
            JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{"Code generated by Wire protocol buffer compiler, do not edit."});
            boolean bl = false;
            boolean bl2 = false;
            JavaFile.Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addFileComment("\nSource file: $L", new Object[]{type.getLocation().withPathOnly()});
            JavaFile javaFile = builder.build();
            Path path2 = path = this.fs.getPath(this.destination, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
            JavaFile javaFile2 = javaFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaFile2, (String)"javaFile");
            this.log.artifact(path2, javaFile2);
            if (this.dryRun) {
                return;
            }
            try {
                javaFile.writeTo(path);
            }
            catch (IOException e) {
                throw (Throwable)new IOException("Error emitting " + javaFile.packageName + '.' + javaFile.typeSpec.name + " to " + this.destination, e);
            }
        }
        return;
    }

    public JavaFileWriter(@NotNull String destination, @NotNull JavaGenerator javaGenerator, @NotNull ConcurrentLinkedQueue<PendingTypeFileSpec> queue, boolean dryRun, @NotNull FileSystem fs, @NotNull WireLogger log) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)javaGenerator, (String)"javaGenerator");
        Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.destination = destination;
        this.javaGenerator = javaGenerator;
        this.queue = queue;
        this.dryRun = dryRun;
        this.fs = fs;
        this.log = log;
    }
}

