/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.TypeConfigElement;
import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.NewProfileLoader;
import com.squareup.wire.schema.NewSchemaLoaderKt;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.RootKt;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0002J$\u0010#\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\n2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\nJ\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\tH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020.J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0000\u00a2\u0006\u0002\b1J)\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c032\u0006\u0010,\u001a\u00020\t2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c0\nH\u0000\u00a2\u0006\u0002\b5J\r\u00106\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b7J\u001e\u00108\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\nH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/squareup/wire/schema/NewSchemaLoader;", "Ljava/io/Closeable;", "Lcom/squareup/wire/schema/Loader;", "Lcom/squareup/wire/schema/NewProfileLoader;", "fs", "Ljava/nio/file/FileSystem;", "(Ljava/nio/file/FileSystem;)V", "baseToRoots", "", "", "", "Lcom/squareup/wire/schema/Root;", "closer", "Lcom/google/common/io/Closer;", "kotlin.jvm.PlatformType", "errors", "", "missingImports", "Ljava/util/TreeSet;", "protoPathRoots", "<set-?>", "Lcom/squareup/wire/schema/ProtoFile;", "sourcePathFiles", "getSourcePathFiles", "()Ljava/util/List;", "sourcePathRoots", "allRoots", "locations", "Lcom/squareup/wire/schema/Location;", "checkForErrors", "", "close", "importedType", "Lcom/squareup/wire/schema/ProtoType;", "type", "initRoots", "sourcePath", "protoPath", "load", "protoFilePath", "Lcom/squareup/wire/schema/ProtoFilePath;", "path", "loadProfile", "Lcom/squareup/wire/java/Profile;", "name", "schema", "Lcom/squareup/wire/schema/Schema;", "loadSchema", "loadSourcePathFiles", "loadSourcePathFiles$wire_compiler", "locationsToCheck", "", "input", "locationsToCheck$wire_compiler", "reportLoadingErrors", "reportLoadingErrors$wire_compiler", "validate", "profileFiles", "Lcom/squareup/wire/java/internal/ProfileFileElement;", "wire-compiler"})
public final class NewSchemaLoader
implements Closeable,
Loader,
NewProfileLoader {
    private final Closer closer;
    private final List<String> errors;
    private final TreeSet<String> missingImports;
    private List<? extends Root> sourcePathRoots;
    private List<? extends Root> protoPathRoots;
    @NotNull
    private List<ProtoFile> sourcePathFiles;
    private final Map<String, List<Root>> baseToRoots;
    private final FileSystem fs;

    @NotNull
    public final List<ProtoFile> getSourcePathFiles() {
        List<ProtoFile> list = this.sourcePathFiles;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourcePathFiles");
        }
        return list;
    }

    public final void initRoots(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath) {
        Intrinsics.checkParameterIsNotNull(sourcePath, (String)"sourcePath");
        Intrinsics.checkParameterIsNotNull(protoPath, (String)"protoPath");
        boolean bl = this.sourcePathRoots == null && this.protoPathRoots == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Closer closer = this.closer;
        Intrinsics.checkExpressionValueIsNotNull((Object)closer, (String)"closer");
        this.sourcePathRoots = this.allRoots(closer, sourcePath);
        Closer closer2 = this.closer;
        Intrinsics.checkExpressionValueIsNotNull((Object)closer2, (String)"closer");
        this.protoPathRoots = this.allRoots(closer2, protoPath);
    }

    public static /* synthetic */ void initRoots$default(NewSchemaLoader newSchemaLoader, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        newSchemaLoader.initRoots(list, list2);
    }

    @NotNull
    public final Schema loadSchema() throws IOException {
        Schema schema;
        this.sourcePathFiles = this.loadSourcePathFiles$wire_compiler();
        try {
            List<ProtoFile> list = this.sourcePathFiles;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourcePathFiles");
            }
            schema = Schema.fromFiles((Iterable)list, (Loader)this);
        }
        catch (Exception e) {
            this.reportLoadingErrors$wire_compiler();
            throw (Throwable)e;
        }
        Schema result = schema;
        this.reportLoadingErrors$wire_compiler();
        Schema schema2 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"result");
        return schema2;
    }

    @NotNull
    public final List<ProtoFile> loadSourcePathFiles$wire_compiler() throws IOException {
        boolean bl = this.sourcePathRoots != null && this.protoPathRoots != null;
        boolean bl2 = false;
        boolean string = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "call initRoots() before calling loadSourcePathFiles()";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        boolean bl3 = false;
        List result = new ArrayList();
        List<? extends Root> list = this.sourcePathRoots;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (Root collection : list) {
            for (ProtoFilePath locationAndPath : collection.allProtoFiles()) {
                Collection collection2 = result;
                ProtoFile protoFile = this.load(locationAndPath);
                boolean bl4 = false;
                collection2.add(protoFile);
            }
        }
        if (result.isEmpty()) {
            Collection collection = this.errors;
            String string3 = "no sources";
            boolean bl5 = false;
            collection.add(string3);
        }
        this.checkForErrors();
        return result;
    }

    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ProtoFilePath loadFrom = null;
        List<? extends Root> list = this.protoPathRoots;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (Root collection : list) {
            ProtoFilePath locationAndPath;
            if (collection.resolve(path) == null) {
                continue;
            }
            if (loadFrom != null) {
                Collection collection2 = this.errors;
                String string = path + " is ambiguous:\n  " + locationAndPath + "\n  " + loadFrom;
                boolean bl = false;
                collection2.add(string);
                continue;
            }
            loadFrom = locationAndPath;
        }
        if (loadFrom != null) {
            return this.load(loadFrom);
        }
        if (Intrinsics.areEqual((Object)path, (Object)"google/protobuf/descriptor.proto") || Intrinsics.areEqual((Object)path, (Object)"wire/extensions.proto")) {
            return CoreLoader.INSTANCE.load(path);
        }
        Collection collection = this.missingImports;
        boolean bl = false;
        collection.add(path);
        return ProtoFile.Companion.get(ProtoFileElement.Companion.empty(path));
    }

    private final ProtoFile load(ProtoFilePath protoFilePath) {
        ProtoFile protoFile = protoFilePath.parse();
        String importPath = NewSchemaLoaderKt.importPath(protoFile, protoFilePath.getLocation());
        Object object = protoFilePath.getLocation().getBase();
        boolean bl = false;
        if (object.length() == 0 && Intrinsics.areEqual((Object)protoFilePath.getLocation().getPath(), (Object)importPath) ^ true && !StringsKt.endsWith$default((String)protoFilePath.getLocation().getPath(), (String)('/' + importPath), (boolean)false, (int)2, null)) {
            object = this.errors;
            String string = "expected " + protoFilePath.getLocation().getPath() + " to have a path ending with " + importPath;
            boolean bl2 = false;
            object.add(string);
        }
        return protoFile;
    }

    private final List<Root> allRoots(Closer closer, List<Location> locations) {
        boolean bl = false;
        List result = new ArrayList();
        for (Location location : locations) {
            Iterable<String> iterable;
            try {
                Collection collection = result;
                iterable = RootKt.roots(location, this.fs, closer, this.baseToRoots);
                boolean bl2 = false;
                CollectionsKt.addAll((Collection)collection, iterable);
            }
            catch (IllegalArgumentException e) {
                String string;
                iterable = this.errors;
                if (e.getMessage() == null) {
                    Intrinsics.throwNpe();
                }
                boolean bl3 = false;
                iterable.add(string);
            }
        }
        return result;
    }

    public final void reportLoadingErrors$wire_compiler() {
        Collection collection = this.missingImports;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = this.errors;
            StringBuilder stringBuilder = new StringBuilder().append("\n          |unable to resolve ").append(this.missingImports.size()).append(" imports:\n          |  ").append(CollectionsKt.joinToString$default((Iterable)this.missingImports, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).append("\n          |searching ");
            List<? extends Root> list = this.protoPathRoots;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder2 = stringBuilder.append(list.size()).append(" proto paths:\n          |  ");
            List<? extends Root> list2 = this.protoPathRoots;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            String string = StringsKt.trimMargin$default((String)stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).append("\n          ").toString(), null, (int)1, null);
            boolean bl2 = false;
            collection.add(string);
        }
        this.checkForErrors();
    }

    private final void checkForErrors() {
        boolean bl = this.errors.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void close() {
        this.closer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Profile loadProfile(@NotNull String name, @NotNull Schema schema) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        ImmutableList immutableList = schema.getProtoFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"schema.protoFiles");
        Iterable $this$map$iv = (Iterable)immutableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ProtoFile protoFile = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Location location = it.getLocation();
            collection.add(location);
        }
        List allLocations = (List)destination$iv$iv;
        Set<Location> locationsToCheck = this.locationsToCheck$wire_compiler(name, allLocations);
        boolean $this$mapTo$iv$iv2 = false;
        List profileElements = new ArrayList();
        for (Location location : locationsToCheck) {
            List<Root> roots2;
            if (this.baseToRoots.get(location.getBase()) == null) {
                continue;
            }
            for (Root root : roots2) {
                ProtoFilePath resolved;
                if (root.resolve(location.getPath()) == null) {
                    continue;
                }
                Collection collection = profileElements;
                ProfileFileElement profileFileElement = resolved.parseProfile();
                boolean bl = false;
                collection.add(profileFileElement);
            }
        }
        Profile profile = new Profile(profileElements);
        this.validate(schema, profileElements);
        return profile;
    }

    private final void validate(Schema schema, List<ProfileFileElement> profileFiles) {
        for (ProfileFileElement profileFile : profileFiles) {
            for (TypeConfigElement typeConfig : profileFile.getTypeConfigs()) {
                String string;
                List<String> list;
                Object[] objectArray;
                String string2;
                ProtoType type;
                if (this.importedType(ProtoType.Companion.get(typeConfig.getType())) == null) {
                    continue;
                }
                Type resolvedType = schema.getType(type);
                if (resolvedType == null) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    string2 = "unable to resolve %s (%s)";
                    objectArray = new Object[]{type, typeConfig.getLocation()};
                    list = this.errors;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    list.add(string);
                    continue;
                }
                String requiredImport = resolvedType.getLocation().getPath();
                if (profileFile.getImports().contains(requiredImport)) continue;
                string2 = StringCompanionObject.INSTANCE;
                objectArray = "%s needs to import %s (%s)";
                Object[] objectArray2 = new Object[]{typeConfig.getLocation().getPath(), requiredImport, typeConfig.getLocation()};
                list = this.errors;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
                list.add(string);
            }
        }
        this.checkForErrors();
    }

    private final ProtoType importedType(ProtoType type) {
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            if (protoType == null) {
                Intrinsics.throwNpe();
            }
            type2 = protoType;
        }
        return type2.isScalar() ? null : type2;
    }

    @NotNull
    public final Set<Location> locationsToCheck$wire_compiler(@NotNull String name, @NotNull List<Location> input) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        ArrayDeque queue = new ArrayDeque(input);
        boolean bl = false;
        Set result = new LinkedHashSet();
        while ((Location)queue.poll() != null) {
            String parentPath;
            Location protoLocation;
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)protoLocation.getPath(), (String)"/", (int)0, (boolean)false, (int)6, null);
            String string = protoLocation.getPath();
            int n = 0;
            int n2 = lastSlash + 1;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Location profileLocation = Location.copy$default((Location)protoLocation, null, (String)(parentPath + name + ".wire"), (int)0, (int)0, (int)13, null);
            if (!result.add(profileLocation)) continue;
            Object object = parentPath;
            n2 = 0;
            if (!(object.length() > 0)) continue;
            object = queue;
            Location location = Location.copy$default((Location)protoLocation, null, (String)StringsKt.dropLast((String)parentPath, (int)1), (int)0, (int)0, (int)13, null);
            bl2 = false;
            object.add(location);
        }
        return result;
    }

    public NewSchemaLoader(@NotNull FileSystem fs) {
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        this.fs = fs;
        this.closer = Closer.create();
        NewSchemaLoader newSchemaLoader = this;
        boolean bl = false;
        Object object = new ArrayList();
        newSchemaLoader.errors = object;
        this.missingImports = new TreeSet();
        newSchemaLoader = this;
        bl = false;
        newSchemaLoader.baseToRoots = object = (Map)new LinkedHashMap();
    }
}

