/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.io.Closer;
import com.squareup.wire.schema.DirectoryRoot;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\fH\u0000\u001a\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"endsWithDotProto", "", "Ljava/nio/file/Path;", "roots", "", "Lcom/squareup/wire/schema/Root;", "Lcom/squareup/wire/schema/Location;", "fs", "Ljava/nio/file/FileSystem;", "closer", "Lcom/google/common/io/Closer;", "baseToRoots", "", "", "location", "wire-compiler"})
public final class RootKt {
    @NotNull
    public static final List<Root> roots(@NotNull Location $receiver, @NotNull FileSystem fs, @NotNull Closer closer, @NotNull Map<String, List<Root>> baseToRoots) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        Intrinsics.checkParameterIsNotNull(baseToRoots, (String)"baseToRoots");
        CharSequence charSequence = $receiver.getBase();
        if (charSequence.length() > 0) {
            List<Root> list = baseToRoots.computeIfAbsent($receiver.getBase(), (Function<String, List<Root>>)new Function<String, List<? extends Root>>(fs, closer){
                final /* synthetic */ FileSystem $fs;
                final /* synthetic */ Closer $closer;

                @NotNull
                public final List<Root> apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return RootKt.roots$default(Location.Companion.get(it), this.$fs, this.$closer, null, 4, null);
                }
                {
                    this.$fs = fileSystem;
                    this.$closer = closer;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"baseToRoots.computeIfAbs\u2026).roots(fs, closer)\n    }");
            List<Root> roots2 = list;
            for (Root root : roots2) {
                ProtoFilePath protoFilePath = root.resolve($receiver.getPath());
                if (protoFilePath == null) {
                    continue;
                }
                ProtoFilePath resolved = protoFilePath;
                return CollectionsKt.listOf((Object)resolved);
            }
            throw (Throwable)new IllegalArgumentException("unable to resolve " + $receiver);
        }
        Path path2 = path = fs.getPath($receiver.getPath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        return RootKt.roots(path2, closer, $receiver);
    }

    @NotNull
    public static /* synthetic */ List roots$default(Location location, FileSystem fileSystem, Closer closer, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        return RootKt.roots(location, fileSystem, closer, map);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Root> roots(@NotNull Path $receiver, Closer closer, Location location) {
        List list;
        if (Files.isDirectory($receiver, new LinkOption[0])) {
            boolean bl;
            CharSequence charSequence = location.getBase();
            boolean bl2 = bl = charSequence.length() == 0;
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            list = CollectionsKt.listOf((Object)new DirectoryRoot(location.getPath(), $receiver));
        } else if (RootKt.endsWithDotProto($receiver)) {
            list = CollectionsKt.listOf((Object)new ProtoFilePath(location, $receiver));
        } else {
            List list2;
            boolean bl;
            CharSequence charSequence = location.getBase();
            boolean bl3 = bl = charSequence.length() == 0;
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            try {
                void $receiver$iv$iv;
                Iterable<Path> $receiver$iv;
                FileSystem sourceFs = FileSystems.newFileSystem($receiver, $receiver.getClass().getClassLoader());
                closer.register((Closeable)sourceFs);
                FileSystem fileSystem = sourceFs;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"sourceFs");
                Iterable<Path> iterable = fileSystem.getRootDirectories();
                Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"sourceFs.rootDirectories");
                Iterable<Path> iterable2 = $receiver$iv = iterable;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string = location.getPath();
                    void v6 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                    DirectoryRoot directoryRoot = new DirectoryRoot(string, (Path)v6);
                    collection.add(directoryRoot);
                }
                list2 = (List)destination$iv$iv;
            }
            catch (ProviderNotFoundException e) {
                throw (Throwable)new IllegalArgumentException("expected a directory, archive (.zip / .jar / etc.), or .proto: " + $receiver);
            }
            list = list2;
        }
        return list;
    }

    private static final boolean endsWithDotProto(@NotNull Path $receiver) {
        return StringsKt.endsWith$default((String)((Object)$receiver.getFileName()).toString(), (String)".proto", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ boolean access$endsWithDotProto(Path $receiver) {
        return RootKt.endsWithDotProto($receiver);
    }
}

