/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.JavaFile;
import com.squareup.wire.WireLogger;
import java.nio.file.Path;

final class ConsoleWireLogger
implements WireLogger {
    private boolean quiet;

    ConsoleWireLogger() {
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void info(String message) {
        if (!this.quiet) {
            System.out.println(message);
        }
    }

    @Override
    public void artifact(Path outputPath, JavaFile javaFile) {
        if (this.quiet) {
            System.out.printf("%s.%s%n", javaFile.packageName, javaFile.typeSpec.name);
        } else {
            System.out.printf("Writing %s.%s to %s%n", javaFile.packageName, javaFile.typeSpec.name, outputPath);
        }
    }
}

