/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.CommandLineOptions;
import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;

public final class WireCompiler {
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final FileSystem fs;
    private final CommandLineOptions options;
    private final WireLogger log;

    public static void main(String ... args) throws IOException {
        try {
            WireCompiler.create(new CommandLineOptions(args)).compile();
        }
        catch (WireException e) {
            System.err.print("Fatal: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static WireCompiler create(CommandLineOptions options) throws WireException {
        return new WireCompiler(options, FileSystems.getDefault(), new ConsoleWireLogger(options.quiet));
    }

    WireCompiler(CommandLineOptions options, FileSystem fs, WireLogger logger) throws WireException {
        this.options = options;
        this.fs = fs;
        this.log = logger;
        if (options.javaOut == null) {
            throw new WireException("Must specify --java_out= flag");
        }
    }

    public void compile() throws IOException {
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String protoPath : this.options.protoPaths) {
            schemaLoader.addDirectory(this.fs.getPath(protoPath, new String[0]));
        }
        for (String sourceFileName : this.options.sourceFileNames) {
            schemaLoader.addProto(this.fs.getPath(sourceFileName, new String[0]));
        }
        Schema schema = schemaLoader.load();
        if (!this.options.roots.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            schema = schema.retainRoots(this.options.roots);
        }
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withOptions(this.options.emitOptions, this.options.enumOptions);
        for (ProtoFile protoFile : schema.protoFiles()) {
            if (!this.options.sourceFileNames.contains(protoFile.location().path())) continue;
            for (Type type : protoFile.types()) {
                ClassName javaTypeName = (ClassName)javaGenerator.typeName(type.name());
                TypeSpec typeSpec = type instanceof MessageType ? javaGenerator.generateMessage((MessageType)type) : javaGenerator.generateEnum((EnumType)type);
                this.writeJavaFile(javaTypeName, typeSpec, type.location());
            }
            if (protoFile.extendList().isEmpty()) continue;
            ClassName javaTypeName = javaGenerator.extensionsClass(protoFile);
            TypeSpec typeSpec = javaGenerator.generateExtensionsClass(javaTypeName, protoFile);
            this.writeJavaFile(javaTypeName, typeSpec, protoFile.location());
        }
        if (this.options.registryClass != null) {
            ClassName className = ClassName.bestGuess((String)this.options.registryClass);
            TypeSpec typeSpec = javaGenerator.generateRegistry(className);
            this.writeJavaFile(className, typeSpec, null);
        }
    }

    private void writeJavaFile(ClassName javaTypeName, TypeSpec typeSpec, Location location) throws IOException {
        JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{CODE_GENERATED_BY_WIRE});
        if (location != null) {
            builder.addFileComment("\nSource file: $L", new Object[]{location});
        }
        JavaFile javaFile = builder.build();
        Path path = this.fs.getPath(this.options.javaOut, new String[0]);
        this.log.artifact(path, javaFile);
        try {
            if (!this.options.dryRun) {
                javaFile.writeTo(path);
            }
        }
        catch (IOException e) {
            throw new IOException("Error emitting " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + this.options.javaOut, e);
        }
    }
}

