/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TestWebhookSubscriptionRequest {
    private final String subscriptionId;
    private final Optional<String> eventType;
    private final Map<String, Object> additionalProperties;

    private TestWebhookSubscriptionRequest(String subscriptionId, Optional<String> eventType, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.eventType = eventType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getEventType() {
        if (this.eventType == null) {
            return Optional.empty();
        }
        return this.eventType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event_type")
    private Optional<String> _getEventType() {
        return this.eventType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TestWebhookSubscriptionRequest && this.equalTo((TestWebhookSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TestWebhookSubscriptionRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.eventType.equals(other.eventType);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.eventType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<String> eventType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TestWebhookSubscriptionRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.eventType(other.getEventType());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage eventType(Nullable<String> eventType) {
            this.eventType = eventType.isNull() ? null : (eventType.isEmpty() ? Optional.empty() : Optional.of(eventType.get()));
            return this;
        }

        @Override
        public _FinalStage eventType(String eventType) {
            this.eventType = Optional.ofNullable(eventType);
            return this;
        }

        @Override
        @JsonSetter(value="event_type", nulls=Nulls.SKIP)
        public _FinalStage eventType(Optional<String> eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public TestWebhookSubscriptionRequest build() {
            return new TestWebhookSubscriptionRequest(this.subscriptionId, this.eventType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TestWebhookSubscriptionRequest build();

        public _FinalStage eventType(Optional<String> var1);

        public _FinalStage eventType(String var1);

        public _FinalStage eventType(Nullable<String> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(TestWebhookSubscriptionRequest var1);
    }
}

