/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.webhooks.AsyncEventTypesClient;
import com.squareup.square.webhooks.AsyncSubscriptionsClient;
import java.util.function.Supplier;

public class AsyncWebhooksClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AsyncEventTypesClient> eventTypesClient;
    protected final Supplier<AsyncSubscriptionsClient> subscriptionsClient;

    public AsyncWebhooksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.eventTypesClient = Suppliers.memoize(() -> new AsyncEventTypesClient(clientOptions));
        this.subscriptionsClient = Suppliers.memoize(() -> new AsyncSubscriptionsClient(clientOptions));
    }

    public AsyncEventTypesClient eventTypes() {
        return this.eventTypesClient.get();
    }

    public AsyncSubscriptionsClient subscriptions() {
        return this.subscriptionsClient.get();
    }
}

