/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CreateWebhookSubscriptionResponse;
import com.squareup.square.types.DeleteWebhookSubscriptionResponse;
import com.squareup.square.types.GetWebhookSubscriptionResponse;
import com.squareup.square.types.TestWebhookSubscriptionResponse;
import com.squareup.square.types.UpdateWebhookSubscriptionResponse;
import com.squareup.square.types.UpdateWebhookSubscriptionSignatureKeyResponse;
import com.squareup.square.types.WebhookSubscription;
import com.squareup.square.webhooks.AsyncRawSubscriptionsClient;
import com.squareup.square.webhooks.types.CreateWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.DeleteSubscriptionsRequest;
import com.squareup.square.webhooks.types.GetSubscriptionsRequest;
import com.squareup.square.webhooks.types.ListSubscriptionsRequest;
import com.squareup.square.webhooks.types.TestWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.UpdateWebhookSubscriptionRequest;
import com.squareup.square.webhooks.types.UpdateWebhookSubscriptionSignatureKeyRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncSubscriptionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSubscriptionsClient rawClient;

    public AsyncSubscriptionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSubscriptionsClient(clientOptions);
    }

    public AsyncRawSubscriptionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<WebhookSubscription>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<WebhookSubscription>> list(ListSubscriptionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<WebhookSubscription>> list(ListSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateWebhookSubscriptionResponse> create(CreateWebhookSubscriptionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<CreateWebhookSubscriptionResponse> create(CreateWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<GetWebhookSubscriptionResponse> get(GetSubscriptionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<GetWebhookSubscriptionResponse> get(GetSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<UpdateWebhookSubscriptionResponse> update(UpdateWebhookSubscriptionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<UpdateWebhookSubscriptionResponse> update(UpdateWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<DeleteWebhookSubscriptionResponse> delete(DeleteSubscriptionsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<DeleteWebhookSubscriptionResponse> delete(DeleteSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<UpdateWebhookSubscriptionSignatureKeyResponse> updateSignatureKey(UpdateWebhookSubscriptionSignatureKeyRequest request) {
        return this.rawClient.updateSignatureKey(request).thenApply(response -> (UpdateWebhookSubscriptionSignatureKeyResponse)response.body());
    }

    public CompletableFuture<UpdateWebhookSubscriptionSignatureKeyResponse> updateSignatureKey(UpdateWebhookSubscriptionSignatureKeyRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateSignatureKey(request, requestOptions).thenApply(response -> (UpdateWebhookSubscriptionSignatureKeyResponse)response.body());
    }

    public CompletableFuture<TestWebhookSubscriptionResponse> test(TestWebhookSubscriptionRequest request) {
        return this.rawClient.test(request).thenApply(response -> (TestWebhookSubscriptionResponse)response.body());
    }

    public CompletableFuture<TestWebhookSubscriptionResponse> test(TestWebhookSubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.test(request, requestOptions).thenApply(response -> (TestWebhookSubscriptionResponse)response.body());
    }
}

