/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WebhookSubscription {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<Boolean> enabled;
    private final Optional<List<String>> eventTypes;
    private final Optional<String> notificationUrl;
    private final Optional<String> apiVersion;
    private final Optional<String> signatureKey;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private WebhookSubscription(Optional<String> id, Optional<String> name, Optional<Boolean> enabled, Optional<List<String>> eventTypes, Optional<String> notificationUrl, Optional<String> apiVersion, Optional<String> signatureKey, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.eventTypes = eventTypes;
        this.notificationUrl = notificationUrl;
        this.apiVersion = apiVersion;
        this.signatureKey = signatureKey;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        if (this.enabled == null) {
            return Optional.empty();
        }
        return this.enabled;
    }

    @JsonIgnore
    public Optional<List<String>> getEventTypes() {
        if (this.eventTypes == null) {
            return Optional.empty();
        }
        return this.eventTypes;
    }

    @JsonIgnore
    public Optional<String> getNotificationUrl() {
        if (this.notificationUrl == null) {
            return Optional.empty();
        }
        return this.notificationUrl;
    }

    @JsonIgnore
    public Optional<String> getApiVersion() {
        if (this.apiVersion == null) {
            return Optional.empty();
        }
        return this.apiVersion;
    }

    @JsonProperty(value="signature_key")
    public Optional<String> getSignatureKey() {
        return this.signatureKey;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enabled")
    private Optional<Boolean> _getEnabled() {
        return this.enabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event_types")
    private Optional<List<String>> _getEventTypes() {
        return this.eventTypes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="notification_url")
    private Optional<String> _getNotificationUrl() {
        return this.notificationUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="api_version")
    private Optional<String> _getApiVersion() {
        return this.apiVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhookSubscription && this.equalTo((WebhookSubscription)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookSubscription other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.enabled.equals(other.enabled) && this.eventTypes.equals(other.eventTypes) && this.notificationUrl.equals(other.notificationUrl) && this.apiVersion.equals(other.apiVersion) && this.signatureKey.equals(other.signatureKey) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.enabled, this.eventTypes, this.notificationUrl, this.apiVersion, this.signatureKey, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<List<String>> eventTypes = Optional.empty();
        private Optional<String> notificationUrl = Optional.empty();
        private Optional<String> apiVersion = Optional.empty();
        private Optional<String> signatureKey = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(WebhookSubscription other) {
            this.id(other.getId());
            this.name(other.getName());
            this.enabled(other.getEnabled());
            this.eventTypes(other.getEventTypes());
            this.notificationUrl(other.getNotificationUrl());
            this.apiVersion(other.getApiVersion());
            this.signatureKey(other.getSignatureKey());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        public Builder enabled(Nullable<Boolean> enabled) {
            this.enabled = enabled.isNull() ? null : (enabled.isEmpty() ? Optional.empty() : Optional.of(enabled.get()));
            return this;
        }

        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public Builder eventTypes(Optional<List<String>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(List<String> eventTypes) {
            this.eventTypes = Optional.ofNullable(eventTypes);
            return this;
        }

        public Builder eventTypes(Nullable<List<String>> eventTypes) {
            this.eventTypes = eventTypes.isNull() ? null : (eventTypes.isEmpty() ? Optional.empty() : Optional.of(eventTypes.get()));
            return this;
        }

        @JsonSetter(value="notification_url", nulls=Nulls.SKIP)
        public Builder notificationUrl(Optional<String> notificationUrl) {
            this.notificationUrl = notificationUrl;
            return this;
        }

        public Builder notificationUrl(String notificationUrl) {
            this.notificationUrl = Optional.ofNullable(notificationUrl);
            return this;
        }

        public Builder notificationUrl(Nullable<String> notificationUrl) {
            this.notificationUrl = notificationUrl.isNull() ? null : (notificationUrl.isEmpty() ? Optional.empty() : Optional.of(notificationUrl.get()));
            return this;
        }

        @JsonSetter(value="api_version", nulls=Nulls.SKIP)
        public Builder apiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = Optional.ofNullable(apiVersion);
            return this;
        }

        public Builder apiVersion(Nullable<String> apiVersion) {
            this.apiVersion = apiVersion.isNull() ? null : (apiVersion.isEmpty() ? Optional.empty() : Optional.of(apiVersion.get()));
            return this;
        }

        @JsonSetter(value="signature_key", nulls=Nulls.SKIP)
        public Builder signatureKey(Optional<String> signatureKey) {
            this.signatureKey = signatureKey;
            return this;
        }

        public Builder signatureKey(String signatureKey) {
            this.signatureKey = Optional.ofNullable(signatureKey);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public WebhookSubscription build() {
            return new WebhookSubscription(this.id, this.name, this.enabled, this.eventTypes, this.notificationUrl, this.apiVersion, this.signatureKey, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

