/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.VendorContact;
import com.squareup.square.types.VendorStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Vendor {
    private final Optional<String> id;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> name;
    private final Optional<Address> address;
    private final Optional<List<VendorContact>> contacts;
    private final Optional<String> accountNumber;
    private final Optional<String> note;
    private final Optional<Integer> version;
    private final Optional<VendorStatus> status;
    private final Map<String, Object> additionalProperties;

    private Vendor(Optional<String> id, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> name, Optional<Address> address, Optional<List<VendorContact>> contacts, Optional<String> accountNumber, Optional<String> note, Optional<Integer> version, Optional<VendorStatus> status, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.name = name;
        this.address = address;
        this.contacts = contacts;
        this.accountNumber = accountNumber;
        this.note = note;
        this.version = version;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonIgnore
    public Optional<List<VendorContact>> getContacts() {
        if (this.contacts == null) {
            return Optional.empty();
        }
        return this.contacts;
    }

    @JsonIgnore
    public Optional<String> getAccountNumber() {
        if (this.accountNumber == null) {
            return Optional.empty();
        }
        return this.accountNumber;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="status")
    public Optional<VendorStatus> getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="contacts")
    private Optional<List<VendorContact>> _getContacts() {
        return this.contacts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="account_number")
    private Optional<String> _getAccountNumber() {
        return this.accountNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Vendor && this.equalTo((Vendor)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Vendor other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.name.equals(other.name) && this.address.equals(other.address) && this.contacts.equals(other.contacts) && this.accountNumber.equals(other.accountNumber) && this.note.equals(other.note) && this.version.equals(other.version) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.name, this.address, this.contacts, this.accountNumber, this.note, this.version, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<List<VendorContact>> contacts = Optional.empty();
        private Optional<String> accountNumber = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<VendorStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Vendor other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.name(other.getName());
            this.address(other.getAddress());
            this.contacts(other.getContacts());
            this.accountNumber(other.getAccountNumber());
            this.note(other.getNote());
            this.version(other.getVersion());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @JsonSetter(value="contacts", nulls=Nulls.SKIP)
        public Builder contacts(Optional<List<VendorContact>> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(List<VendorContact> contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        public Builder contacts(Nullable<List<VendorContact>> contacts) {
            this.contacts = contacts.isNull() ? null : (contacts.isEmpty() ? Optional.empty() : Optional.of(contacts.get()));
            return this;
        }

        @JsonSetter(value="account_number", nulls=Nulls.SKIP)
        public Builder accountNumber(Optional<String> accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = Optional.ofNullable(accountNumber);
            return this;
        }

        public Builder accountNumber(Nullable<String> accountNumber) {
            this.accountNumber = accountNumber.isNull() ? null : (accountNumber.isEmpty() ? Optional.empty() : Optional.of(accountNumber.get()));
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        public Builder note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<VendorStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(VendorStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Vendor build() {
            return new Vendor(this.id, this.createdAt, this.updatedAt, this.name, this.address, this.contacts, this.accountNumber, this.note, this.version, this.status, this.additionalProperties);
        }
    }
}

