/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.V1Money;
import com.squareup.square.types.V1TenderCardBrand;
import com.squareup.square.types.V1TenderEntryMethod;
import com.squareup.square.types.V1TenderType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1Tender {
    private final Optional<String> id;
    private final Optional<V1TenderType> type;
    private final Optional<String> name;
    private final Optional<String> employeeId;
    private final Optional<String> receiptUrl;
    private final Optional<V1TenderCardBrand> cardBrand;
    private final Optional<String> panSuffix;
    private final Optional<V1TenderEntryMethod> entryMethod;
    private final Optional<String> paymentNote;
    private final Optional<V1Money> totalMoney;
    private final Optional<V1Money> tenderedMoney;
    private final Optional<String> tenderedAt;
    private final Optional<String> settledAt;
    private final Optional<V1Money> changeBackMoney;
    private final Optional<V1Money> refundedMoney;
    private final Optional<Boolean> isExchange;
    private final Map<String, Object> additionalProperties;

    private V1Tender(Optional<String> id, Optional<V1TenderType> type, Optional<String> name, Optional<String> employeeId, Optional<String> receiptUrl, Optional<V1TenderCardBrand> cardBrand, Optional<String> panSuffix, Optional<V1TenderEntryMethod> entryMethod, Optional<String> paymentNote, Optional<V1Money> totalMoney, Optional<V1Money> tenderedMoney, Optional<String> tenderedAt, Optional<String> settledAt, Optional<V1Money> changeBackMoney, Optional<V1Money> refundedMoney, Optional<Boolean> isExchange, Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.employeeId = employeeId;
        this.receiptUrl = receiptUrl;
        this.cardBrand = cardBrand;
        this.panSuffix = panSuffix;
        this.entryMethod = entryMethod;
        this.paymentNote = paymentNote;
        this.totalMoney = totalMoney;
        this.tenderedMoney = tenderedMoney;
        this.tenderedAt = tenderedAt;
        this.settledAt = settledAt;
        this.changeBackMoney = changeBackMoney;
        this.refundedMoney = refundedMoney;
        this.isExchange = isExchange;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public Optional<V1TenderType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getEmployeeId() {
        if (this.employeeId == null) {
            return Optional.empty();
        }
        return this.employeeId;
    }

    @JsonIgnore
    public Optional<String> getReceiptUrl() {
        if (this.receiptUrl == null) {
            return Optional.empty();
        }
        return this.receiptUrl;
    }

    @JsonProperty(value="card_brand")
    public Optional<V1TenderCardBrand> getCardBrand() {
        return this.cardBrand;
    }

    @JsonIgnore
    public Optional<String> getPanSuffix() {
        if (this.panSuffix == null) {
            return Optional.empty();
        }
        return this.panSuffix;
    }

    @JsonProperty(value="entry_method")
    public Optional<V1TenderEntryMethod> getEntryMethod() {
        return this.entryMethod;
    }

    @JsonIgnore
    public Optional<String> getPaymentNote() {
        if (this.paymentNote == null) {
            return Optional.empty();
        }
        return this.paymentNote;
    }

    @JsonProperty(value="total_money")
    public Optional<V1Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonProperty(value="tendered_money")
    public Optional<V1Money> getTenderedMoney() {
        return this.tenderedMoney;
    }

    @JsonIgnore
    public Optional<String> getTenderedAt() {
        if (this.tenderedAt == null) {
            return Optional.empty();
        }
        return this.tenderedAt;
    }

    @JsonIgnore
    public Optional<String> getSettledAt() {
        if (this.settledAt == null) {
            return Optional.empty();
        }
        return this.settledAt;
    }

    @JsonProperty(value="change_back_money")
    public Optional<V1Money> getChangeBackMoney() {
        return this.changeBackMoney;
    }

    @JsonProperty(value="refunded_money")
    public Optional<V1Money> getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonIgnore
    public Optional<Boolean> getIsExchange() {
        if (this.isExchange == null) {
            return Optional.empty();
        }
        return this.isExchange;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="employee_id")
    private Optional<String> _getEmployeeId() {
        return this.employeeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="receipt_url")
    private Optional<String> _getReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pan_suffix")
    private Optional<String> _getPanSuffix() {
        return this.panSuffix;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_note")
    private Optional<String> _getPaymentNote() {
        return this.paymentNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tendered_at")
    private Optional<String> _getTenderedAt() {
        return this.tenderedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="settled_at")
    private Optional<String> _getSettledAt() {
        return this.settledAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_exchange")
    private Optional<Boolean> _getIsExchange() {
        return this.isExchange;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1Tender && this.equalTo((V1Tender)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1Tender other) {
        return this.id.equals(other.id) && this.type.equals(other.type) && this.name.equals(other.name) && this.employeeId.equals(other.employeeId) && this.receiptUrl.equals(other.receiptUrl) && this.cardBrand.equals(other.cardBrand) && this.panSuffix.equals(other.panSuffix) && this.entryMethod.equals(other.entryMethod) && this.paymentNote.equals(other.paymentNote) && this.totalMoney.equals(other.totalMoney) && this.tenderedMoney.equals(other.tenderedMoney) && this.tenderedAt.equals(other.tenderedAt) && this.settledAt.equals(other.settledAt) && this.changeBackMoney.equals(other.changeBackMoney) && this.refundedMoney.equals(other.refundedMoney) && this.isExchange.equals(other.isExchange);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name, this.employeeId, this.receiptUrl, this.cardBrand, this.panSuffix, this.entryMethod, this.paymentNote, this.totalMoney, this.tenderedMoney, this.tenderedAt, this.settledAt, this.changeBackMoney, this.refundedMoney, this.isExchange);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<V1TenderType> type = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> receiptUrl = Optional.empty();
        private Optional<V1TenderCardBrand> cardBrand = Optional.empty();
        private Optional<String> panSuffix = Optional.empty();
        private Optional<V1TenderEntryMethod> entryMethod = Optional.empty();
        private Optional<String> paymentNote = Optional.empty();
        private Optional<V1Money> totalMoney = Optional.empty();
        private Optional<V1Money> tenderedMoney = Optional.empty();
        private Optional<String> tenderedAt = Optional.empty();
        private Optional<String> settledAt = Optional.empty();
        private Optional<V1Money> changeBackMoney = Optional.empty();
        private Optional<V1Money> refundedMoney = Optional.empty();
        private Optional<Boolean> isExchange = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(V1Tender other) {
            this.id(other.getId());
            this.type(other.getType());
            this.name(other.getName());
            this.employeeId(other.getEmployeeId());
            this.receiptUrl(other.getReceiptUrl());
            this.cardBrand(other.getCardBrand());
            this.panSuffix(other.getPanSuffix());
            this.entryMethod(other.getEntryMethod());
            this.paymentNote(other.getPaymentNote());
            this.totalMoney(other.getTotalMoney());
            this.tenderedMoney(other.getTenderedMoney());
            this.tenderedAt(other.getTenderedAt());
            this.settledAt(other.getSettledAt());
            this.changeBackMoney(other.getChangeBackMoney());
            this.refundedMoney(other.getRefundedMoney());
            this.isExchange(other.getIsExchange());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<V1TenderType> type) {
            this.type = type;
            return this;
        }

        public Builder type(V1TenderType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public Builder employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        public Builder employeeId(Nullable<String> employeeId) {
            this.employeeId = employeeId.isNull() ? null : (employeeId.isEmpty() ? Optional.empty() : Optional.of(employeeId.get()));
            return this;
        }

        @JsonSetter(value="receipt_url", nulls=Nulls.SKIP)
        public Builder receiptUrl(Optional<String> receiptUrl) {
            this.receiptUrl = receiptUrl;
            return this;
        }

        public Builder receiptUrl(String receiptUrl) {
            this.receiptUrl = Optional.ofNullable(receiptUrl);
            return this;
        }

        public Builder receiptUrl(Nullable<String> receiptUrl) {
            this.receiptUrl = receiptUrl.isNull() ? null : (receiptUrl.isEmpty() ? Optional.empty() : Optional.of(receiptUrl.get()));
            return this;
        }

        @JsonSetter(value="card_brand", nulls=Nulls.SKIP)
        public Builder cardBrand(Optional<V1TenderCardBrand> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder cardBrand(V1TenderCardBrand cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        @JsonSetter(value="pan_suffix", nulls=Nulls.SKIP)
        public Builder panSuffix(Optional<String> panSuffix) {
            this.panSuffix = panSuffix;
            return this;
        }

        public Builder panSuffix(String panSuffix) {
            this.panSuffix = Optional.ofNullable(panSuffix);
            return this;
        }

        public Builder panSuffix(Nullable<String> panSuffix) {
            this.panSuffix = panSuffix.isNull() ? null : (panSuffix.isEmpty() ? Optional.empty() : Optional.of(panSuffix.get()));
            return this;
        }

        @JsonSetter(value="entry_method", nulls=Nulls.SKIP)
        public Builder entryMethod(Optional<V1TenderEntryMethod> entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public Builder entryMethod(V1TenderEntryMethod entryMethod) {
            this.entryMethod = Optional.ofNullable(entryMethod);
            return this;
        }

        @JsonSetter(value="payment_note", nulls=Nulls.SKIP)
        public Builder paymentNote(Optional<String> paymentNote) {
            this.paymentNote = paymentNote;
            return this;
        }

        public Builder paymentNote(String paymentNote) {
            this.paymentNote = Optional.ofNullable(paymentNote);
            return this;
        }

        public Builder paymentNote(Nullable<String> paymentNote) {
            this.paymentNote = paymentNote.isNull() ? null : (paymentNote.isEmpty() ? Optional.empty() : Optional.of(paymentNote.get()));
            return this;
        }

        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public Builder totalMoney(Optional<V1Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalMoney(V1Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @JsonSetter(value="tendered_money", nulls=Nulls.SKIP)
        public Builder tenderedMoney(Optional<V1Money> tenderedMoney) {
            this.tenderedMoney = tenderedMoney;
            return this;
        }

        public Builder tenderedMoney(V1Money tenderedMoney) {
            this.tenderedMoney = Optional.ofNullable(tenderedMoney);
            return this;
        }

        @JsonSetter(value="tendered_at", nulls=Nulls.SKIP)
        public Builder tenderedAt(Optional<String> tenderedAt) {
            this.tenderedAt = tenderedAt;
            return this;
        }

        public Builder tenderedAt(String tenderedAt) {
            this.tenderedAt = Optional.ofNullable(tenderedAt);
            return this;
        }

        public Builder tenderedAt(Nullable<String> tenderedAt) {
            this.tenderedAt = tenderedAt.isNull() ? null : (tenderedAt.isEmpty() ? Optional.empty() : Optional.of(tenderedAt.get()));
            return this;
        }

        @JsonSetter(value="settled_at", nulls=Nulls.SKIP)
        public Builder settledAt(Optional<String> settledAt) {
            this.settledAt = settledAt;
            return this;
        }

        public Builder settledAt(String settledAt) {
            this.settledAt = Optional.ofNullable(settledAt);
            return this;
        }

        public Builder settledAt(Nullable<String> settledAt) {
            this.settledAt = settledAt.isNull() ? null : (settledAt.isEmpty() ? Optional.empty() : Optional.of(settledAt.get()));
            return this;
        }

        @JsonSetter(value="change_back_money", nulls=Nulls.SKIP)
        public Builder changeBackMoney(Optional<V1Money> changeBackMoney) {
            this.changeBackMoney = changeBackMoney;
            return this;
        }

        public Builder changeBackMoney(V1Money changeBackMoney) {
            this.changeBackMoney = Optional.ofNullable(changeBackMoney);
            return this;
        }

        @JsonSetter(value="refunded_money", nulls=Nulls.SKIP)
        public Builder refundedMoney(Optional<V1Money> refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder refundedMoney(V1Money refundedMoney) {
            this.refundedMoney = Optional.ofNullable(refundedMoney);
            return this;
        }

        @JsonSetter(value="is_exchange", nulls=Nulls.SKIP)
        public Builder isExchange(Optional<Boolean> isExchange) {
            this.isExchange = isExchange;
            return this;
        }

        public Builder isExchange(Boolean isExchange) {
            this.isExchange = Optional.ofNullable(isExchange);
            return this;
        }

        public Builder isExchange(Nullable<Boolean> isExchange) {
            this.isExchange = isExchange.isNull() ? null : (isExchange.isEmpty() ? Optional.empty() : Optional.of(isExchange.get()));
            return this;
        }

        public V1Tender build() {
            return new V1Tender(this.id, this.type, this.name, this.employeeId, this.receiptUrl, this.cardBrand, this.panSuffix, this.entryMethod, this.paymentNote, this.totalMoney, this.tenderedMoney, this.tenderedAt, this.settledAt, this.changeBackMoney, this.refundedMoney, this.isExchange, this.additionalProperties);
        }
    }
}

