/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1Money {
    private final Optional<Integer> amount;
    private final Optional<Currency> currencyCode;
    private final Map<String, Object> additionalProperties;

    private V1Money(Optional<Integer> amount, Optional<Currency> currencyCode, Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.currencyCode = currencyCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getAmount() {
        if (this.amount == null) {
            return Optional.empty();
        }
        return this.amount;
    }

    @JsonProperty(value="currency_code")
    public Optional<Currency> getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="amount")
    private Optional<Integer> _getAmount() {
        return this.amount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1Money && this.equalTo((V1Money)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1Money other) {
        return this.amount.equals(other.amount) && this.currencyCode.equals(other.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> amount = Optional.empty();
        private Optional<Currency> currencyCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(V1Money other) {
            this.amount(other.getAmount());
            this.currencyCode(other.getCurrencyCode());
            return this;
        }

        @JsonSetter(value="amount", nulls=Nulls.SKIP)
        public Builder amount(Optional<Integer> amount) {
            this.amount = amount;
            return this;
        }

        public Builder amount(Integer amount) {
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Nullable<Integer> amount) {
            this.amount = amount.isNull() ? null : (amount.isEmpty() ? Optional.empty() : Optional.of(amount.get()));
            return this;
        }

        @JsonSetter(value="currency_code", nulls=Nulls.SKIP)
        public Builder currencyCode(Optional<Currency> currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder currencyCode(Currency currencyCode) {
            this.currencyCode = Optional.ofNullable(currencyCode);
            return this;
        }

        public V1Money build() {
            return new V1Money(this.amount, this.currencyCode, this.additionalProperties);
        }
    }
}

