/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1ListOrdersRequest {
    private final String locationId;
    private final Optional<SortOrder> order;
    private final Optional<Integer> limit;
    private final Optional<String> batchToken;
    private final Map<String, Object> additionalProperties;

    private V1ListOrdersRequest(String locationId, Optional<SortOrder> order, Optional<Integer> limit, Optional<String> batchToken, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.order = order;
        this.limit = limit;
        this.batchToken = batchToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<SortOrder> getOrder() {
        if (this.order == null) {
            return Optional.empty();
        }
        return this.order;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getBatchToken() {
        if (this.batchToken == null) {
            return Optional.empty();
        }
        return this.batchToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order")
    private Optional<SortOrder> _getOrder() {
        return this.order;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="batch_token")
    private Optional<String> _getBatchToken() {
        return this.batchToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1ListOrdersRequest && this.equalTo((V1ListOrdersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1ListOrdersRequest other) {
        return this.locationId.equals(other.locationId) && this.order.equals(other.order) && this.limit.equals(other.limit) && this.batchToken.equals(other.batchToken);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.order, this.limit, this.batchToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    _FinalStage {
        private String locationId;
        private Optional<String> batchToken = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<SortOrder> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V1ListOrdersRequest other) {
            this.locationId(other.getLocationId());
            this.order(other.getOrder());
            this.limit(other.getLimit());
            this.batchToken(other.getBatchToken());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage batchToken(Nullable<String> batchToken) {
            this.batchToken = batchToken.isNull() ? null : (batchToken.isEmpty() ? Optional.empty() : Optional.of(batchToken.get()));
            return this;
        }

        @Override
        public _FinalStage batchToken(String batchToken) {
            this.batchToken = Optional.ofNullable(batchToken);
            return this;
        }

        @Override
        @JsonSetter(value="batch_token", nulls=Nulls.SKIP)
        public _FinalStage batchToken(Optional<String> batchToken) {
            this.batchToken = batchToken;
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage order(Nullable<SortOrder> order) {
            this.order = order.isNull() ? null : (order.isEmpty() ? Optional.empty() : Optional.of(order.get()));
            return this;
        }

        @Override
        public _FinalStage order(SortOrder order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @Override
        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public _FinalStage order(Optional<SortOrder> order) {
            this.order = order;
            return this;
        }

        @Override
        public V1ListOrdersRequest build() {
            return new V1ListOrdersRequest(this.locationId, this.order, this.limit, this.batchToken, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V1ListOrdersRequest build();

        public _FinalStage order(Optional<SortOrder> var1);

        public _FinalStage order(SortOrder var1);

        public _FinalStage order(Nullable<SortOrder> var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);

        public _FinalStage batchToken(Optional<String> var1);

        public _FinalStage batchToken(String var1);

        public _FinalStage batchToken(Nullable<String> var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);

        public Builder from(V1ListOrdersRequest var1);
    }
}

