/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Snippet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertSnippetResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Snippet> snippet;
    private final Map<String, Object> additionalProperties;

    private UpsertSnippetResponse(Optional<List<Error>> errors, Optional<Snippet> snippet, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.snippet = snippet;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="snippet")
    public Optional<Snippet> getSnippet() {
        return this.snippet;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertSnippetResponse && this.equalTo((UpsertSnippetResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertSnippetResponse other) {
        return this.errors.equals(other.errors) && this.snippet.equals(other.snippet);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.snippet);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Snippet> snippet = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpsertSnippetResponse other) {
            this.errors(other.getErrors());
            this.snippet(other.getSnippet());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="snippet", nulls=Nulls.SKIP)
        public Builder snippet(Optional<Snippet> snippet) {
            this.snippet = snippet;
            return this;
        }

        public Builder snippet(Snippet snippet) {
            this.snippet = Optional.ofNullable(snippet);
            return this;
        }

        public UpsertSnippetResponse build() {
            return new UpsertSnippetResponse(this.errors, this.snippet, this.additionalProperties);
        }
    }
}

