/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Vendor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateVendorRequest {
    private final Optional<String> idempotencyKey;
    private final Vendor vendor;
    private final Map<String, Object> additionalProperties;

    private UpdateVendorRequest(Optional<String> idempotencyKey, Vendor vendor, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.vendor = vendor;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonProperty(value="vendor")
    public Vendor getVendor() {
        return this.vendor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateVendorRequest && this.equalTo((UpdateVendorRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateVendorRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.vendor.equals(other.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.vendor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VendorStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VendorStage,
    _FinalStage {
        private Vendor vendor;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateVendorRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.vendor(other.getVendor());
            return this;
        }

        @Override
        @JsonSetter(value="vendor")
        public _FinalStage vendor(@NotNull Vendor vendor) {
            this.vendor = Objects.requireNonNull(vendor, "vendor must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpdateVendorRequest build() {
            return new UpdateVendorRequest(this.idempotencyKey, this.vendor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateVendorRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface VendorStage {
        public _FinalStage vendor(@NotNull Vendor var1);

        public Builder from(UpdateVendorRequest var1);
    }
}

