/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Subscription;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateSubscriptionRequest {
    private final String subscriptionId;
    private final Optional<Subscription> subscription;
    private final Map<String, Object> additionalProperties;

    private UpdateSubscriptionRequest(String subscriptionId, Optional<Subscription> subscription, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.subscription = subscription;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonProperty(value="subscription")
    public Optional<Subscription> getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateSubscriptionRequest && this.equalTo((UpdateSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateSubscriptionRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.subscription.equals(other.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.subscription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<Subscription> subscription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateSubscriptionRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.subscription(other.getSubscription());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage subscription(Subscription subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        @Override
        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public _FinalStage subscription(Optional<Subscription> subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public UpdateSubscriptionRequest build() {
            return new UpdateSubscriptionRequest(this.subscriptionId, this.subscription, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateSubscriptionRequest build();

        public _FinalStage subscription(Optional<Subscription> var1);

        public _FinalStage subscription(Subscription var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(UpdateSubscriptionRequest var1);
    }
}

