/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShift;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateScheduledShiftRequest {
    private final String id;
    private final ScheduledShift scheduledShift;
    private final Map<String, Object> additionalProperties;

    private UpdateScheduledShiftRequest(String id, ScheduledShift scheduledShift, Map<String, Object> additionalProperties) {
        this.id = id;
        this.scheduledShift = scheduledShift;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="scheduled_shift")
    public ScheduledShift getScheduledShift() {
        return this.scheduledShift;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateScheduledShiftRequest && this.equalTo((UpdateScheduledShiftRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateScheduledShiftRequest other) {
        return this.id.equals(other.id) && this.scheduledShift.equals(other.scheduledShift);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.scheduledShift);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ScheduledShiftStage,
    _FinalStage {
        private String id;
        private ScheduledShift scheduledShift;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateScheduledShiftRequest other) {
            this.id(other.getId());
            this.scheduledShift(other.getScheduledShift());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ScheduledShiftStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="scheduled_shift")
        public _FinalStage scheduledShift(@NotNull ScheduledShift scheduledShift) {
            this.scheduledShift = Objects.requireNonNull(scheduledShift, "scheduledShift must not be null");
            return this;
        }

        @Override
        public UpdateScheduledShiftRequest build() {
            return new UpdateScheduledShiftRequest(this.id, this.scheduledShift, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateScheduledShiftRequest build();
    }

    public static interface ScheduledShiftStage {
        public _FinalStage scheduledShift(@NotNull ScheduledShift var1);
    }

    public static interface IdStage {
        public ScheduledShiftStage id(@NotNull String var1);

        public Builder from(UpdateScheduledShiftRequest var1);
    }
}

