/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Payment;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePaymentRequest {
    private final String paymentId;
    private final Optional<Payment> payment;
    private final String idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpdatePaymentRequest(String paymentId, Optional<Payment> payment, String idempotencyKey, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.payment = payment;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonProperty(value="payment")
    public Optional<Payment> getPayment() {
        return this.payment;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePaymentRequest && this.equalTo((UpdatePaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePaymentRequest other) {
        return this.paymentId.equals(other.paymentId) && this.payment.equals(other.payment) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.payment, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentIdStage,
    IdempotencyKeyStage,
    _FinalStage {
        private String paymentId;
        private String idempotencyKey;
        private Optional<Payment> payment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePaymentRequest other) {
            this.paymentId(other.getPaymentId());
            this.payment(other.getPayment());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="payment_id")
        public IdempotencyKeyStage paymentId(@NotNull String paymentId) {
            this.paymentId = Objects.requireNonNull(paymentId, "paymentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage payment(Payment payment) {
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        @Override
        @JsonSetter(value="payment", nulls=Nulls.SKIP)
        public _FinalStage payment(Optional<Payment> payment) {
            this.payment = payment;
            return this;
        }

        @Override
        public UpdatePaymentRequest build() {
            return new UpdatePaymentRequest(this.paymentId, this.payment, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePaymentRequest build();

        public _FinalStage payment(Optional<Payment> var1);

        public _FinalStage payment(Payment var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface PaymentIdStage {
        public IdempotencyKeyStage paymentId(@NotNull String var1);

        public Builder from(UpdatePaymentRequest var1);
    }
}

