/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutLocationSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateLocationSettingsRequest {
    private final String locationId;
    private final CheckoutLocationSettings locationSettings;
    private final Map<String, Object> additionalProperties;

    private UpdateLocationSettingsRequest(String locationId, CheckoutLocationSettings locationSettings, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.locationSettings = locationSettings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="location_settings")
    public CheckoutLocationSettings getLocationSettings() {
        return this.locationSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateLocationSettingsRequest && this.equalTo((UpdateLocationSettingsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateLocationSettingsRequest other) {
        return this.locationId.equals(other.locationId) && this.locationSettings.equals(other.locationSettings);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.locationSettings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    LocationSettingsStage,
    _FinalStage {
        private String locationId;
        private CheckoutLocationSettings locationSettings;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateLocationSettingsRequest other) {
            this.locationId(other.getLocationId());
            this.locationSettings(other.getLocationSettings());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public LocationSettingsStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_settings")
        public _FinalStage locationSettings(@NotNull CheckoutLocationSettings locationSettings) {
            this.locationSettings = Objects.requireNonNull(locationSettings, "locationSettings must not be null");
            return this;
        }

        @Override
        public UpdateLocationSettingsRequest build() {
            return new UpdateLocationSettingsRequest(this.locationId, this.locationSettings, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateLocationSettingsRequest build();
    }

    public static interface LocationSettingsStage {
        public _FinalStage locationSettings(@NotNull CheckoutLocationSettings var1);
    }

    public static interface LocationIdStage {
        public LocationSettingsStage locationId(@NotNull String var1);

        public Builder from(UpdateLocationSettingsRequest var1);
    }
}

