/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateLocationRequest {
    private final String locationId;
    private final Optional<Location> location;
    private final Map<String, Object> additionalProperties;

    private UpdateLocationRequest(String locationId, Optional<Location> location, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="location")
    public Optional<Location> getLocation() {
        return this.location;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateLocationRequest && this.equalTo((UpdateLocationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateLocationRequest other) {
        return this.locationId.equals(other.locationId) && this.location.equals(other.location);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.location);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    _FinalStage {
        private String locationId;
        private Optional<Location> location = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateLocationRequest other) {
            this.locationId(other.getLocationId());
            this.location(other.getLocation());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage location(Location location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @Override
        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public _FinalStage location(Optional<Location> location) {
            this.location = location;
            return this;
        }

        @Override
        public UpdateLocationRequest build() {
            return new UpdateLocationRequest(this.locationId, this.location, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateLocationRequest build();

        public _FinalStage location(Optional<Location> var1);

        public _FinalStage location(Location var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);

        public Builder from(UpdateLocationRequest var1);
    }
}

