/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Job;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateJobRequest {
    private final String jobId;
    private final Job job;
    private final Map<String, Object> additionalProperties;

    private UpdateJobRequest(String jobId, Job job, Map<String, Object> additionalProperties) {
        this.jobId = jobId;
        this.job = job;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job_id")
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="job")
    public Job getJob() {
        return this.job;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateJobRequest && this.equalTo((UpdateJobRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateJobRequest other) {
        return this.jobId.equals(other.jobId) && this.job.equals(other.job);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.job);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobIdStage,
    JobStage,
    _FinalStage {
        private String jobId;
        private Job job;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateJobRequest other) {
            this.jobId(other.getJobId());
            this.job(other.getJob());
            return this;
        }

        @Override
        @JsonSetter(value="job_id")
        public JobStage jobId(@NotNull String jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="job")
        public _FinalStage job(@NotNull Job job) {
            this.job = Objects.requireNonNull(job, "job must not be null");
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this.jobId, this.job, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateJobRequest build();
    }

    public static interface JobStage {
        public _FinalStage job(@NotNull Job var1);
    }

    public static interface JobIdStage {
        public JobStage jobId(@NotNull String var1);

        public Builder from(UpdateJobRequest var1);
    }
}

