/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateItemTaxesRequest {
    private final List<String> itemIds;
    private final Optional<List<String>> taxesToEnable;
    private final Optional<List<String>> taxesToDisable;
    private final Map<String, Object> additionalProperties;

    private UpdateItemTaxesRequest(List<String> itemIds, Optional<List<String>> taxesToEnable, Optional<List<String>> taxesToDisable, Map<String, Object> additionalProperties) {
        this.itemIds = itemIds;
        this.taxesToEnable = taxesToEnable;
        this.taxesToDisable = taxesToDisable;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonIgnore
    public Optional<List<String>> getTaxesToEnable() {
        if (this.taxesToEnable == null) {
            return Optional.empty();
        }
        return this.taxesToEnable;
    }

    @JsonIgnore
    public Optional<List<String>> getTaxesToDisable() {
        if (this.taxesToDisable == null) {
            return Optional.empty();
        }
        return this.taxesToDisable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="taxes_to_enable")
    private Optional<List<String>> _getTaxesToEnable() {
        return this.taxesToEnable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="taxes_to_disable")
    private Optional<List<String>> _getTaxesToDisable() {
        return this.taxesToDisable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateItemTaxesRequest && this.equalTo((UpdateItemTaxesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateItemTaxesRequest other) {
        return this.itemIds.equals(other.itemIds) && this.taxesToEnable.equals(other.taxesToEnable) && this.taxesToDisable.equals(other.taxesToDisable);
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.taxesToEnable, this.taxesToDisable);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> itemIds = new ArrayList<String>();
        private Optional<List<String>> taxesToEnable = Optional.empty();
        private Optional<List<String>> taxesToDisable = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateItemTaxesRequest other) {
            this.itemIds(other.getItemIds());
            this.taxesToEnable(other.getTaxesToEnable());
            this.taxesToDisable(other.getTaxesToDisable());
            return this;
        }

        @JsonSetter(value="item_ids", nulls=Nulls.SKIP)
        public Builder itemIds(List<String> itemIds) {
            this.itemIds.clear();
            this.itemIds.addAll(itemIds);
            return this;
        }

        public Builder addItemIds(String itemIds) {
            this.itemIds.add(itemIds);
            return this;
        }

        public Builder addAllItemIds(List<String> itemIds) {
            this.itemIds.addAll(itemIds);
            return this;
        }

        @JsonSetter(value="taxes_to_enable", nulls=Nulls.SKIP)
        public Builder taxesToEnable(Optional<List<String>> taxesToEnable) {
            this.taxesToEnable = taxesToEnable;
            return this;
        }

        public Builder taxesToEnable(List<String> taxesToEnable) {
            this.taxesToEnable = Optional.ofNullable(taxesToEnable);
            return this;
        }

        public Builder taxesToEnable(Nullable<List<String>> taxesToEnable) {
            this.taxesToEnable = taxesToEnable.isNull() ? null : (taxesToEnable.isEmpty() ? Optional.empty() : Optional.of(taxesToEnable.get()));
            return this;
        }

        @JsonSetter(value="taxes_to_disable", nulls=Nulls.SKIP)
        public Builder taxesToDisable(Optional<List<String>> taxesToDisable) {
            this.taxesToDisable = taxesToDisable;
            return this;
        }

        public Builder taxesToDisable(List<String> taxesToDisable) {
            this.taxesToDisable = Optional.ofNullable(taxesToDisable);
            return this;
        }

        public Builder taxesToDisable(Nullable<List<String>> taxesToDisable) {
            this.taxesToDisable = taxesToDisable.isNull() ? null : (taxesToDisable.isEmpty() ? Optional.empty() : Optional.of(taxesToDisable.get()));
            return this;
        }

        public UpdateItemTaxesRequest build() {
            return new UpdateItemTaxesRequest(this.itemIds, this.taxesToEnable, this.taxesToDisable, this.additionalProperties);
        }
    }
}

