/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Invoice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateInvoiceRequest {
    private final String invoiceId;
    private final Invoice invoice;
    private final Optional<String> idempotencyKey;
    private final Optional<List<String>> fieldsToClear;
    private final Map<String, Object> additionalProperties;

    private UpdateInvoiceRequest(String invoiceId, Invoice invoice, Optional<String> idempotencyKey, Optional<List<String>> fieldsToClear, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.invoice = invoice;
        this.idempotencyKey = idempotencyKey;
        this.fieldsToClear = fieldsToClear;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="invoice")
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonIgnore
    public Optional<List<String>> getFieldsToClear() {
        if (this.fieldsToClear == null) {
            return Optional.empty();
        }
        return this.fieldsToClear;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fields_to_clear")
    private Optional<List<String>> _getFieldsToClear() {
        return this.fieldsToClear;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateInvoiceRequest && this.equalTo((UpdateInvoiceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateInvoiceRequest other) {
        return this.invoiceId.equals(other.invoiceId) && this.invoice.equals(other.invoice) && this.idempotencyKey.equals(other.idempotencyKey) && this.fieldsToClear.equals(other.fieldsToClear);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.invoice, this.idempotencyKey, this.fieldsToClear);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    InvoiceStage,
    _FinalStage {
        private String invoiceId;
        private Invoice invoice;
        private Optional<List<String>> fieldsToClear = Optional.empty();
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateInvoiceRequest other) {
            this.invoiceId(other.getInvoiceId());
            this.invoice(other.getInvoice());
            this.idempotencyKey(other.getIdempotencyKey());
            this.fieldsToClear(other.getFieldsToClear());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public InvoiceStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="invoice")
        public _FinalStage invoice(@NotNull Invoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice must not be null");
            return this;
        }

        @Override
        public _FinalStage fieldsToClear(Nullable<List<String>> fieldsToClear) {
            this.fieldsToClear = fieldsToClear.isNull() ? null : (fieldsToClear.isEmpty() ? Optional.empty() : Optional.of(fieldsToClear.get()));
            return this;
        }

        @Override
        public _FinalStage fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = Optional.ofNullable(fieldsToClear);
            return this;
        }

        @Override
        @JsonSetter(value="fields_to_clear", nulls=Nulls.SKIP)
        public _FinalStage fieldsToClear(Optional<List<String>> fieldsToClear) {
            this.fieldsToClear = fieldsToClear;
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpdateInvoiceRequest build() {
            return new UpdateInvoiceRequest(this.invoiceId, this.invoice, this.idempotencyKey, this.fieldsToClear, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateInvoiceRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);

        public _FinalStage fieldsToClear(Optional<List<String>> var1);

        public _FinalStage fieldsToClear(List<String> var1);

        public _FinalStage fieldsToClear(Nullable<List<String>> var1);
    }

    public static interface InvoiceStage {
        public _FinalStage invoice(@NotNull Invoice var1);
    }

    public static interface InvoiceIdStage {
        public InvoiceStage invoiceId(@NotNull String var1);

        public Builder from(UpdateInvoiceRequest var1);
    }
}

