/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TimeRange;
import com.squareup.square.types.TimecardFilterStatus;
import com.squareup.square.types.TimecardWorkday;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TimecardFilter {
    private final Optional<List<String>> locationIds;
    private final Optional<TimecardFilterStatus> status;
    private final Optional<TimeRange> start;
    private final Optional<TimeRange> end;
    private final Optional<TimecardWorkday> workday;
    private final Optional<List<String>> teamMemberIds;
    private final Map<String, Object> additionalProperties;

    private TimecardFilter(Optional<List<String>> locationIds, Optional<TimecardFilterStatus> status, Optional<TimeRange> start, Optional<TimeRange> end, Optional<TimecardWorkday> workday, Optional<List<String>> teamMemberIds, Map<String, Object> additionalProperties) {
        this.locationIds = locationIds;
        this.status = status;
        this.start = start;
        this.end = end;
        this.workday = workday;
        this.teamMemberIds = teamMemberIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="status")
    public Optional<TimecardFilterStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="start")
    public Optional<TimeRange> getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public Optional<TimeRange> getEnd() {
        return this.end;
    }

    @JsonProperty(value="workday")
    public Optional<TimecardWorkday> getWorkday() {
        return this.workday;
    }

    @JsonIgnore
    public Optional<List<String>> getTeamMemberIds() {
        if (this.teamMemberIds == null) {
            return Optional.empty();
        }
        return this.teamMemberIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_ids")
    private Optional<List<String>> _getTeamMemberIds() {
        return this.teamMemberIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimecardFilter && this.equalTo((TimecardFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimecardFilter other) {
        return this.locationIds.equals(other.locationIds) && this.status.equals(other.status) && this.start.equals(other.start) && this.end.equals(other.end) && this.workday.equals(other.workday) && this.teamMemberIds.equals(other.teamMemberIds);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.status, this.start, this.end, this.workday, this.teamMemberIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<TimecardFilterStatus> status = Optional.empty();
        private Optional<TimeRange> start = Optional.empty();
        private Optional<TimeRange> end = Optional.empty();
        private Optional<TimecardWorkday> workday = Optional.empty();
        private Optional<List<String>> teamMemberIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimecardFilter other) {
            this.locationIds(other.getLocationIds());
            this.status(other.getStatus());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.workday(other.getWorkday());
            this.teamMemberIds(other.getTeamMemberIds());
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TimecardFilterStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TimecardFilterStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="start", nulls=Nulls.SKIP)
        public Builder start(Optional<TimeRange> start) {
            this.start = start;
            return this;
        }

        public Builder start(TimeRange start) {
            this.start = Optional.ofNullable(start);
            return this;
        }

        @JsonSetter(value="end", nulls=Nulls.SKIP)
        public Builder end(Optional<TimeRange> end) {
            this.end = end;
            return this;
        }

        public Builder end(TimeRange end) {
            this.end = Optional.ofNullable(end);
            return this;
        }

        @JsonSetter(value="workday", nulls=Nulls.SKIP)
        public Builder workday(Optional<TimecardWorkday> workday) {
            this.workday = workday;
            return this;
        }

        public Builder workday(TimecardWorkday workday) {
            this.workday = Optional.ofNullable(workday);
            return this;
        }

        @JsonSetter(value="team_member_ids", nulls=Nulls.SKIP)
        public Builder teamMemberIds(Optional<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = Optional.ofNullable(teamMemberIds);
            return this;
        }

        public Builder teamMemberIds(Nullable<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds.isNull() ? null : (teamMemberIds.isEmpty() ? Optional.empty() : Optional.of(teamMemberIds.get()));
            return this;
        }

        public TimecardFilter build() {
            return new TimecardFilter(this.locationIds, this.status, this.start, this.end, this.workday, this.teamMemberIds, this.additionalProperties);
        }
    }
}

