/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Break;
import com.squareup.square.types.Money;
import com.squareup.square.types.TimecardStatus;
import com.squareup.square.types.TimecardWage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Timecard {
    private final Optional<String> id;
    private final String locationId;
    private final Optional<String> timezone;
    private final String startAt;
    private final Optional<String> endAt;
    private final Optional<TimecardWage> wage;
    private final Optional<List<Break>> breaks;
    private final Optional<TimecardStatus> status;
    private final Optional<Integer> version;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final String teamMemberId;
    private final Optional<Money> declaredCashTipMoney;
    private final Map<String, Object> additionalProperties;

    private Timecard(Optional<String> id, String locationId, Optional<String> timezone, String startAt, Optional<String> endAt, Optional<TimecardWage> wage, Optional<List<Break>> breaks, Optional<TimecardStatus> status, Optional<Integer> version, Optional<String> createdAt, Optional<String> updatedAt, String teamMemberId, Optional<Money> declaredCashTipMoney, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.timezone = timezone;
        this.startAt = startAt;
        this.endAt = endAt;
        this.wage = wage;
        this.breaks = breaks;
        this.status = status;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
        this.declaredCashTipMoney = declaredCashTipMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getTimezone() {
        if (this.timezone == null) {
            return Optional.empty();
        }
        return this.timezone;
    }

    @JsonProperty(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getEndAt() {
        if (this.endAt == null) {
            return Optional.empty();
        }
        return this.endAt;
    }

    @JsonProperty(value="wage")
    public Optional<TimecardWage> getWage() {
        return this.wage;
    }

    @JsonIgnore
    public Optional<List<Break>> getBreaks() {
        if (this.breaks == null) {
            return Optional.empty();
        }
        return this.breaks;
    }

    @JsonProperty(value="status")
    public Optional<TimecardStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="declared_cash_tip_money")
    public Optional<Money> getDeclaredCashTipMoney() {
        return this.declaredCashTipMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="timezone")
    private Optional<String> _getTimezone() {
        return this.timezone;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_at")
    private Optional<String> _getEndAt() {
        return this.endAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="breaks")
    private Optional<List<Break>> _getBreaks() {
        return this.breaks;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Timecard && this.equalTo((Timecard)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Timecard other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.timezone.equals(other.timezone) && this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt) && this.wage.equals(other.wage) && this.breaks.equals(other.breaks) && this.status.equals(other.status) && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.teamMemberId.equals(other.teamMemberId) && this.declaredCashTipMoney.equals(other.declaredCashTipMoney);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    StartAtStage,
    TeamMemberIdStage,
    _FinalStage {
        private String locationId;
        private String startAt;
        private String teamMemberId;
        private Optional<Money> declaredCashTipMoney = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<TimecardStatus> status = Optional.empty();
        private Optional<List<Break>> breaks = Optional.empty();
        private Optional<TimecardWage> wage = Optional.empty();
        private Optional<String> endAt = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Timecard other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.timezone(other.getTimezone());
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            this.wage(other.getWage());
            this.breaks(other.getBreaks());
            this.status(other.getStatus());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.teamMemberId(other.getTeamMemberId());
            this.declaredCashTipMoney(other.getDeclaredCashTipMoney());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public StartAtStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="start_at")
        public TeamMemberIdStage startAt(@NotNull String startAt) {
            this.startAt = Objects.requireNonNull(startAt, "startAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id")
        public _FinalStage teamMemberId(@NotNull String teamMemberId) {
            this.teamMemberId = Objects.requireNonNull(teamMemberId, "teamMemberId must not be null");
            return this;
        }

        @Override
        public _FinalStage declaredCashTipMoney(Money declaredCashTipMoney) {
            this.declaredCashTipMoney = Optional.ofNullable(declaredCashTipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="declared_cash_tip_money", nulls=Nulls.SKIP)
        public _FinalStage declaredCashTipMoney(Optional<Money> declaredCashTipMoney) {
            this.declaredCashTipMoney = declaredCashTipMoney;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage status(TimecardStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<TimecardStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage breaks(Nullable<List<Break>> breaks) {
            this.breaks = breaks.isNull() ? null : (breaks.isEmpty() ? Optional.empty() : Optional.of(breaks.get()));
            return this;
        }

        @Override
        public _FinalStage breaks(List<Break> breaks) {
            this.breaks = Optional.ofNullable(breaks);
            return this;
        }

        @Override
        @JsonSetter(value="breaks", nulls=Nulls.SKIP)
        public _FinalStage breaks(Optional<List<Break>> breaks) {
            this.breaks = breaks;
            return this;
        }

        @Override
        public _FinalStage wage(TimecardWage wage) {
            this.wage = Optional.ofNullable(wage);
            return this;
        }

        @Override
        @JsonSetter(value="wage", nulls=Nulls.SKIP)
        public _FinalStage wage(Optional<TimecardWage> wage) {
            this.wage = wage;
            return this;
        }

        @Override
        public _FinalStage endAt(Nullable<String> endAt) {
            this.endAt = endAt.isNull() ? null : (endAt.isEmpty() ? Optional.empty() : Optional.of(endAt.get()));
            return this;
        }

        @Override
        public _FinalStage endAt(String endAt) {
            this.endAt = Optional.ofNullable(endAt);
            return this;
        }

        @Override
        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public _FinalStage endAt(Optional<String> endAt) {
            this.endAt = endAt;
            return this;
        }

        @Override
        public _FinalStage timezone(Nullable<String> timezone) {
            this.timezone = timezone.isNull() ? null : (timezone.isEmpty() ? Optional.empty() : Optional.of(timezone.get()));
            return this;
        }

        @Override
        public _FinalStage timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @Override
        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public _FinalStage timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Timecard build() {
            return new Timecard(this.id, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Timecard build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage timezone(Optional<String> var1);

        public _FinalStage timezone(String var1);

        public _FinalStage timezone(Nullable<String> var1);

        public _FinalStage endAt(Optional<String> var1);

        public _FinalStage endAt(String var1);

        public _FinalStage endAt(Nullable<String> var1);

        public _FinalStage wage(Optional<TimecardWage> var1);

        public _FinalStage wage(TimecardWage var1);

        public _FinalStage breaks(Optional<List<Break>> var1);

        public _FinalStage breaks(List<Break> var1);

        public _FinalStage breaks(Nullable<List<Break>> var1);

        public _FinalStage status(Optional<TimecardStatus> var1);

        public _FinalStage status(TimecardStatus var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage declaredCashTipMoney(Optional<Money> var1);

        public _FinalStage declaredCashTipMoney(Money var1);
    }

    public static interface TeamMemberIdStage {
        public _FinalStage teamMemberId(@NotNull String var1);
    }

    public static interface StartAtStage {
        public TeamMemberIdStage startAt(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public StartAtStage locationId(@NotNull String var1);

        public Builder from(Timecard var1);
    }
}

