/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.SubscriptionTestResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TestWebhookSubscriptionResponse {
    private final Optional<List<Error>> errors;
    private final Optional<SubscriptionTestResult> subscriptionTestResult;
    private final Map<String, Object> additionalProperties;

    private TestWebhookSubscriptionResponse(Optional<List<Error>> errors, Optional<SubscriptionTestResult> subscriptionTestResult, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.subscriptionTestResult = subscriptionTestResult;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="subscription_test_result")
    public Optional<SubscriptionTestResult> getSubscriptionTestResult() {
        return this.subscriptionTestResult;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TestWebhookSubscriptionResponse && this.equalTo((TestWebhookSubscriptionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TestWebhookSubscriptionResponse other) {
        return this.errors.equals(other.errors) && this.subscriptionTestResult.equals(other.subscriptionTestResult);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptionTestResult);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<SubscriptionTestResult> subscriptionTestResult = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TestWebhookSubscriptionResponse other) {
            this.errors(other.getErrors());
            this.subscriptionTestResult(other.getSubscriptionTestResult());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="subscription_test_result", nulls=Nulls.SKIP)
        public Builder subscriptionTestResult(Optional<SubscriptionTestResult> subscriptionTestResult) {
            this.subscriptionTestResult = subscriptionTestResult;
            return this;
        }

        public Builder subscriptionTestResult(SubscriptionTestResult subscriptionTestResult) {
            this.subscriptionTestResult = Optional.ofNullable(subscriptionTestResult);
            return this;
        }

        public TestWebhookSubscriptionResponse build() {
            return new TestWebhookSubscriptionResponse(this.errors, this.subscriptionTestResult, this.additionalProperties);
        }
    }
}

