/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ActionCancelReason;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalRefund {
    private final Optional<String> id;
    private final Optional<String> refundId;
    private final String paymentId;
    private final Optional<String> orderId;
    private final Money amountMoney;
    private final String reason;
    private final String deviceId;
    private final Optional<String> deadlineDuration;
    private final Optional<String> status;
    private final Optional<ActionCancelReason> cancelReason;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> appId;
    private final Optional<String> locationId;
    private final Map<String, Object> additionalProperties;

    private TerminalRefund(Optional<String> id, Optional<String> refundId, String paymentId, Optional<String> orderId, Money amountMoney, String reason, String deviceId, Optional<String> deadlineDuration, Optional<String> status, Optional<ActionCancelReason> cancelReason, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> appId, Optional<String> locationId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.refundId = refundId;
        this.paymentId = paymentId;
        this.orderId = orderId;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.deviceId = deviceId;
        this.deadlineDuration = deadlineDuration;
        this.status = status;
        this.cancelReason = cancelReason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.appId = appId;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="refund_id")
    public Optional<String> getRefundId() {
        return this.refundId;
    }

    @JsonProperty(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonProperty(value="order_id")
    public Optional<String> getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonIgnore
    public Optional<String> getDeadlineDuration() {
        if (this.deadlineDuration == null) {
            return Optional.empty();
        }
        return this.deadlineDuration;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="cancel_reason")
    public Optional<ActionCancelReason> getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="app_id")
    public Optional<String> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="deadline_duration")
    private Optional<String> _getDeadlineDuration() {
        return this.deadlineDuration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalRefund && this.equalTo((TerminalRefund)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalRefund other) {
        return this.id.equals(other.id) && this.refundId.equals(other.refundId) && this.paymentId.equals(other.paymentId) && this.orderId.equals(other.orderId) && this.amountMoney.equals(other.amountMoney) && this.reason.equals(other.reason) && this.deviceId.equals(other.deviceId) && this.deadlineDuration.equals(other.deadlineDuration) && this.status.equals(other.status) && this.cancelReason.equals(other.cancelReason) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.appId.equals(other.appId) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.refundId, this.paymentId, this.orderId, this.amountMoney, this.reason, this.deviceId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentIdStage,
    AmountMoneyStage,
    ReasonStage,
    DeviceIdStage,
    _FinalStage {
        private String paymentId;
        private Money amountMoney;
        private String reason;
        private String deviceId;
        private Optional<String> locationId = Optional.empty();
        private Optional<String> appId = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<ActionCancelReason> cancelReason = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<String> deadlineDuration = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> refundId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TerminalRefund other) {
            this.id(other.getId());
            this.refundId(other.getRefundId());
            this.paymentId(other.getPaymentId());
            this.orderId(other.getOrderId());
            this.amountMoney(other.getAmountMoney());
            this.reason(other.getReason());
            this.deviceId(other.getDeviceId());
            this.deadlineDuration(other.getDeadlineDuration());
            this.status(other.getStatus());
            this.cancelReason(other.getCancelReason());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.appId(other.getAppId());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="payment_id")
        public AmountMoneyStage paymentId(@NotNull String paymentId) {
            this.paymentId = Objects.requireNonNull(paymentId, "paymentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public ReasonStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public DeviceIdStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(@NotNull String deviceId) {
            this.deviceId = Objects.requireNonNull(deviceId, "deviceId must not be null");
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @Override
        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public _FinalStage appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage cancelReason(ActionCancelReason cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        @Override
        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public _FinalStage cancelReason(Optional<ActionCancelReason> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        @Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage deadlineDuration(Nullable<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration.isNull() ? null : (deadlineDuration.isEmpty() ? Optional.empty() : Optional.of(deadlineDuration.get()));
            return this;
        }

        @Override
        public _FinalStage deadlineDuration(String deadlineDuration) {
            this.deadlineDuration = Optional.ofNullable(deadlineDuration);
            return this;
        }

        @Override
        @JsonSetter(value="deadline_duration", nulls=Nulls.SKIP)
        public _FinalStage deadlineDuration(Optional<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration;
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage refundId(String refundId) {
            this.refundId = Optional.ofNullable(refundId);
            return this;
        }

        @Override
        @JsonSetter(value="refund_id", nulls=Nulls.SKIP)
        public _FinalStage refundId(Optional<String> refundId) {
            this.refundId = refundId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public TerminalRefund build() {
            return new TerminalRefund(this.id, this.refundId, this.paymentId, this.orderId, this.amountMoney, this.reason, this.deviceId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TerminalRefund build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage refundId(Optional<String> var1);

        public _FinalStage refundId(String var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage deadlineDuration(Optional<String> var1);

        public _FinalStage deadlineDuration(String var1);

        public _FinalStage deadlineDuration(Nullable<String> var1);

        public _FinalStage status(Optional<String> var1);

        public _FinalStage status(String var1);

        public _FinalStage cancelReason(Optional<ActionCancelReason> var1);

        public _FinalStage cancelReason(ActionCancelReason var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage appId(Optional<String> var1);

        public _FinalStage appId(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(@NotNull String var1);
    }

    public static interface ReasonStage {
        public DeviceIdStage reason(@NotNull String var1);
    }

    public static interface AmountMoneyStage {
        public ReasonStage amountMoney(@NotNull Money var1);
    }

    public static interface PaymentIdStage {
        public AmountMoneyStage paymentId(@NotNull String var1);

        public Builder from(TerminalRefund var1);
    }
}

