/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalCheckoutQueryFilter;
import com.squareup.square.types.TerminalCheckoutQuerySort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalCheckoutQuery {
    private final Optional<TerminalCheckoutQueryFilter> filter;
    private final Optional<TerminalCheckoutQuerySort> sort;
    private final Map<String, Object> additionalProperties;

    private TerminalCheckoutQuery(Optional<TerminalCheckoutQueryFilter> filter, Optional<TerminalCheckoutQuerySort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<TerminalCheckoutQueryFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<TerminalCheckoutQuerySort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalCheckoutQuery && this.equalTo((TerminalCheckoutQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalCheckoutQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TerminalCheckoutQueryFilter> filter = Optional.empty();
        private Optional<TerminalCheckoutQuerySort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TerminalCheckoutQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<TerminalCheckoutQueryFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(TerminalCheckoutQueryFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<TerminalCheckoutQuerySort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(TerminalCheckoutQuerySort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        public TerminalCheckoutQuery build() {
            return new TerminalCheckoutQuery(this.filter, this.sort, this.additionalProperties);
        }
    }
}

