/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TenderType {
    public static final TenderType CARD = new TenderType(Value.CARD, "CARD");
    public static final TenderType WALLET = new TenderType(Value.WALLET, "WALLET");
    public static final TenderType BUY_NOW_PAY_LATER = new TenderType(Value.BUY_NOW_PAY_LATER, "BUY_NOW_PAY_LATER");
    public static final TenderType BANK_ACCOUNT = new TenderType(Value.BANK_ACCOUNT, "BANK_ACCOUNT");
    public static final TenderType OTHER = new TenderType(Value.OTHER, "OTHER");
    public static final TenderType THIRD_PARTY_CARD = new TenderType(Value.THIRD_PARTY_CARD, "THIRD_PARTY_CARD");
    public static final TenderType NO_SALE = new TenderType(Value.NO_SALE, "NO_SALE");
    public static final TenderType CASH = new TenderType(Value.CASH, "CASH");
    public static final TenderType SQUARE_ACCOUNT = new TenderType(Value.SQUARE_ACCOUNT, "SQUARE_ACCOUNT");
    public static final TenderType SQUARE_GIFT_CARD = new TenderType(Value.SQUARE_GIFT_CARD, "SQUARE_GIFT_CARD");
    private final Value value;
    private final String string;

    TenderType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TenderType && this.string.equals(((TenderType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CARD: {
                return visitor.visitCard();
            }
            case WALLET: {
                return visitor.visitWallet();
            }
            case BUY_NOW_PAY_LATER: {
                return visitor.visitBuyNowPayLater();
            }
            case BANK_ACCOUNT: {
                return visitor.visitBankAccount();
            }
            case OTHER: {
                return visitor.visitOther();
            }
            case THIRD_PARTY_CARD: {
                return visitor.visitThirdPartyCard();
            }
            case NO_SALE: {
                return visitor.visitNoSale();
            }
            case CASH: {
                return visitor.visitCash();
            }
            case SQUARE_ACCOUNT: {
                return visitor.visitSquareAccount();
            }
            case SQUARE_GIFT_CARD: {
                return visitor.visitSquareGiftCard();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TenderType valueOf(String value) {
        switch (value) {
            case "CARD": {
                return CARD;
            }
            case "WALLET": {
                return WALLET;
            }
            case "BUY_NOW_PAY_LATER": {
                return BUY_NOW_PAY_LATER;
            }
            case "BANK_ACCOUNT": {
                return BANK_ACCOUNT;
            }
            case "OTHER": {
                return OTHER;
            }
            case "THIRD_PARTY_CARD": {
                return THIRD_PARTY_CARD;
            }
            case "NO_SALE": {
                return NO_SALE;
            }
            case "CASH": {
                return CASH;
            }
            case "SQUARE_ACCOUNT": {
                return SQUARE_ACCOUNT;
            }
            case "SQUARE_GIFT_CARD": {
                return SQUARE_GIFT_CARD;
            }
        }
        return new TenderType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitCard();

        public T visitCash();

        public T visitThirdPartyCard();

        public T visitSquareGiftCard();

        public T visitNoSale();

        public T visitBankAccount();

        public T visitWallet();

        public T visitBuyNowPayLater();

        public T visitSquareAccount();

        public T visitOther();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        CARD,
        CASH,
        THIRD_PARTY_CARD,
        SQUARE_GIFT_CARD,
        NO_SALE,
        BANK_ACCOUNT,
        WALLET,
        BUY_NOW_PAY_LATER,
        SQUARE_ACCOUNT,
        OTHER,
        UNKNOWN;

    }
}

