/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamMemberBookingProfile {
    private final Optional<String> teamMemberId;
    private final Optional<String> description;
    private final Optional<String> displayName;
    private final Optional<Boolean> isBookable;
    private final Optional<String> profileImageUrl;
    private final Map<String, Object> additionalProperties;

    private TeamMemberBookingProfile(Optional<String> teamMemberId, Optional<String> description, Optional<String> displayName, Optional<Boolean> isBookable, Optional<String> profileImageUrl, Map<String, Object> additionalProperties) {
        this.teamMemberId = teamMemberId;
        this.description = description;
        this.displayName = displayName;
        this.isBookable = isBookable;
        this.profileImageUrl = profileImageUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_member_id")
    public Optional<String> getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonIgnore
    public Optional<Boolean> getIsBookable() {
        if (this.isBookable == null) {
            return Optional.empty();
        }
        return this.isBookable;
    }

    @JsonProperty(value="profile_image_url")
    public Optional<String> getProfileImageUrl() {
        return this.profileImageUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_bookable")
    private Optional<Boolean> _getIsBookable() {
        return this.isBookable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamMemberBookingProfile && this.equalTo((TeamMemberBookingProfile)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamMemberBookingProfile other) {
        return this.teamMemberId.equals(other.teamMemberId) && this.description.equals(other.description) && this.displayName.equals(other.displayName) && this.isBookable.equals(other.isBookable) && this.profileImageUrl.equals(other.profileImageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.description, this.displayName, this.isBookable, this.profileImageUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<Boolean> isBookable = Optional.empty();
        private Optional<String> profileImageUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamMemberBookingProfile other) {
            this.teamMemberId(other.getTeamMemberId());
            this.description(other.getDescription());
            this.displayName(other.getDisplayName());
            this.isBookable(other.getIsBookable());
            this.profileImageUrl(other.getProfileImageUrl());
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        @JsonSetter(value="is_bookable", nulls=Nulls.SKIP)
        public Builder isBookable(Optional<Boolean> isBookable) {
            this.isBookable = isBookable;
            return this;
        }

        public Builder isBookable(Boolean isBookable) {
            this.isBookable = Optional.ofNullable(isBookable);
            return this;
        }

        public Builder isBookable(Nullable<Boolean> isBookable) {
            this.isBookable = isBookable.isNull() ? null : (isBookable.isEmpty() ? Optional.empty() : Optional.of(isBookable.get()));
            return this;
        }

        @JsonSetter(value="profile_image_url", nulls=Nulls.SKIP)
        public Builder profileImageUrl(Optional<String> profileImageUrl) {
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        public Builder profileImageUrl(String profileImageUrl) {
            this.profileImageUrl = Optional.ofNullable(profileImageUrl);
            return this;
        }

        public TeamMemberBookingProfile build() {
            return new TeamMemberBookingProfile(this.teamMemberId, this.description, this.displayName, this.isBookable, this.profileImageUrl, this.additionalProperties);
        }
    }
}

