/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TeamMemberAssignedLocationsAssignmentType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamMemberAssignedLocations {
    private final Optional<TeamMemberAssignedLocationsAssignmentType> assignmentType;
    private final Optional<List<String>> locationIds;
    private final Map<String, Object> additionalProperties;

    private TeamMemberAssignedLocations(Optional<TeamMemberAssignedLocationsAssignmentType> assignmentType, Optional<List<String>> locationIds, Map<String, Object> additionalProperties) {
        this.assignmentType = assignmentType;
        this.locationIds = locationIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="assignment_type")
    public Optional<TeamMemberAssignedLocationsAssignmentType> getAssignmentType() {
        return this.assignmentType;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamMemberAssignedLocations && this.equalTo((TeamMemberAssignedLocations)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamMemberAssignedLocations other) {
        return this.assignmentType.equals(other.assignmentType) && this.locationIds.equals(other.locationIds);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentType, this.locationIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TeamMemberAssignedLocationsAssignmentType> assignmentType = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamMemberAssignedLocations other) {
            this.assignmentType(other.getAssignmentType());
            this.locationIds(other.getLocationIds());
            return this;
        }

        @JsonSetter(value="assignment_type", nulls=Nulls.SKIP)
        public Builder assignmentType(Optional<TeamMemberAssignedLocationsAssignmentType> assignmentType) {
            this.assignmentType = assignmentType;
            return this;
        }

        public Builder assignmentType(TeamMemberAssignedLocationsAssignmentType assignmentType) {
            this.assignmentType = Optional.ofNullable(assignmentType);
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        public TeamMemberAssignedLocations build() {
            return new TeamMemberAssignedLocations(this.assignmentType, this.locationIds, this.additionalProperties);
        }
    }
}

