/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TeamMemberAssignedLocations;
import com.squareup.square.types.TeamMemberStatus;
import com.squareup.square.types.WageSetting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamMember {
    private final Optional<String> id;
    private final Optional<String> referenceId;
    private final Optional<Boolean> isOwner;
    private final Optional<TeamMemberStatus> status;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<TeamMemberAssignedLocations> assignedLocations;
    private final Optional<WageSetting> wageSetting;
    private final Map<String, Object> additionalProperties;

    private TeamMember(Optional<String> id, Optional<String> referenceId, Optional<Boolean> isOwner, Optional<TeamMemberStatus> status, Optional<String> givenName, Optional<String> familyName, Optional<String> emailAddress, Optional<String> phoneNumber, Optional<String> createdAt, Optional<String> updatedAt, Optional<TeamMemberAssignedLocations> assignedLocations, Optional<WageSetting> wageSetting, Map<String, Object> additionalProperties) {
        this.id = id;
        this.referenceId = referenceId;
        this.isOwner = isOwner;
        this.status = status;
        this.givenName = givenName;
        this.familyName = familyName;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedLocations = assignedLocations;
        this.wageSetting = wageSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="is_owner")
    public Optional<Boolean> getIsOwner() {
        return this.isOwner;
    }

    @JsonProperty(value="status")
    public Optional<TeamMemberStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getGivenName() {
        if (this.givenName == null) {
            return Optional.empty();
        }
        return this.givenName;
    }

    @JsonIgnore
    public Optional<String> getFamilyName() {
        if (this.familyName == null) {
            return Optional.empty();
        }
        return this.familyName;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="assigned_locations")
    public Optional<TeamMemberAssignedLocations> getAssignedLocations() {
        return this.assignedLocations;
    }

    @JsonProperty(value="wage_setting")
    public Optional<WageSetting> getWageSetting() {
        return this.wageSetting;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="given_name")
    private Optional<String> _getGivenName() {
        return this.givenName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="family_name")
    private Optional<String> _getFamilyName() {
        return this.familyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamMember && this.equalTo((TeamMember)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamMember other) {
        return this.id.equals(other.id) && this.referenceId.equals(other.referenceId) && this.isOwner.equals(other.isOwner) && this.status.equals(other.status) && this.givenName.equals(other.givenName) && this.familyName.equals(other.familyName) && this.emailAddress.equals(other.emailAddress) && this.phoneNumber.equals(other.phoneNumber) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.assignedLocations.equals(other.assignedLocations) && this.wageSetting.equals(other.wageSetting);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.isOwner, this.status, this.givenName, this.familyName, this.emailAddress, this.phoneNumber, this.createdAt, this.updatedAt, this.assignedLocations, this.wageSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<Boolean> isOwner = Optional.empty();
        private Optional<TeamMemberStatus> status = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<TeamMemberAssignedLocations> assignedLocations = Optional.empty();
        private Optional<WageSetting> wageSetting = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamMember other) {
            this.id(other.getId());
            this.referenceId(other.getReferenceId());
            this.isOwner(other.getIsOwner());
            this.status(other.getStatus());
            this.givenName(other.getGivenName());
            this.familyName(other.getFamilyName());
            this.emailAddress(other.getEmailAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.assignedLocations(other.getAssignedLocations());
            this.wageSetting(other.getWageSetting());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="is_owner", nulls=Nulls.SKIP)
        public Builder isOwner(Optional<Boolean> isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = Optional.ofNullable(isOwner);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TeamMemberStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TeamMemberStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="given_name", nulls=Nulls.SKIP)
        public Builder givenName(Optional<String> givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        public Builder givenName(Nullable<String> givenName) {
            this.givenName = givenName.isNull() ? null : (givenName.isEmpty() ? Optional.empty() : Optional.of(givenName.get()));
            return this;
        }

        @JsonSetter(value="family_name", nulls=Nulls.SKIP)
        public Builder familyName(Optional<String> familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        public Builder familyName(Nullable<String> familyName) {
            this.familyName = familyName.isNull() ? null : (familyName.isEmpty() ? Optional.empty() : Optional.of(familyName.get()));
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="assigned_locations", nulls=Nulls.SKIP)
        public Builder assignedLocations(Optional<TeamMemberAssignedLocations> assignedLocations) {
            this.assignedLocations = assignedLocations;
            return this;
        }

        public Builder assignedLocations(TeamMemberAssignedLocations assignedLocations) {
            this.assignedLocations = Optional.ofNullable(assignedLocations);
            return this;
        }

        @JsonSetter(value="wage_setting", nulls=Nulls.SKIP)
        public Builder wageSetting(Optional<WageSetting> wageSetting) {
            this.wageSetting = wageSetting;
            return this;
        }

        public Builder wageSetting(WageSetting wageSetting) {
            this.wageSetting = Optional.ofNullable(wageSetting);
            return this;
        }

        public TeamMember build() {
            return new TeamMember(this.id, this.referenceId, this.isOwner, this.status, this.givenName, this.familyName, this.emailAddress, this.phoneNumber, this.createdAt, this.updatedAt, this.assignedLocations, this.wageSetting, this.additionalProperties);
        }
    }
}

