/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionTestResult {
    private final Optional<String> id;
    private final Optional<Integer> statusCode;
    private final Optional<String> payload;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private SubscriptionTestResult(Optional<String> id, Optional<Integer> statusCode, Optional<String> payload, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.statusCode = statusCode;
        this.payload = payload;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Integer> getStatusCode() {
        if (this.statusCode == null) {
            return Optional.empty();
        }
        return this.statusCode;
    }

    @JsonIgnore
    public Optional<String> getPayload() {
        if (this.payload == null) {
            return Optional.empty();
        }
        return this.payload;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status_code")
    private Optional<Integer> _getStatusCode() {
        return this.statusCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payload")
    private Optional<String> _getPayload() {
        return this.payload;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionTestResult && this.equalTo((SubscriptionTestResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionTestResult other) {
        return this.id.equals(other.id) && this.statusCode.equals(other.statusCode) && this.payload.equals(other.payload) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.statusCode, this.payload, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Integer> statusCode = Optional.empty();
        private Optional<String> payload = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubscriptionTestResult other) {
            this.id(other.getId());
            this.statusCode(other.getStatusCode());
            this.payload(other.getPayload());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="status_code", nulls=Nulls.SKIP)
        public Builder statusCode(Optional<Integer> statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder statusCode(Integer statusCode) {
            this.statusCode = Optional.ofNullable(statusCode);
            return this;
        }

        public Builder statusCode(Nullable<Integer> statusCode) {
            this.statusCode = statusCode.isNull() ? null : (statusCode.isEmpty() ? Optional.empty() : Optional.of(statusCode.get()));
            return this;
        }

        @JsonSetter(value="payload", nulls=Nulls.SKIP)
        public Builder payload(Optional<String> payload) {
            this.payload = payload;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = Optional.ofNullable(payload);
            return this;
        }

        public Builder payload(Nullable<String> payload) {
            this.payload = payload.isNull() ? null : (payload.isEmpty() ? Optional.empty() : Optional.of(payload.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public SubscriptionTestResult build() {
            return new SubscriptionTestResult(this.id, this.statusCode, this.payload, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

