/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.SubscriptionCadence;
import com.squareup.square.types.SubscriptionPricing;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionPhase {
    private final Optional<String> uid;
    private final SubscriptionCadence cadence;
    private final Optional<Integer> periods;
    private final Optional<Money> recurringPriceMoney;
    private final Optional<Long> ordinal;
    private final Optional<SubscriptionPricing> pricing;
    private final Map<String, Object> additionalProperties;

    private SubscriptionPhase(Optional<String> uid, SubscriptionCadence cadence, Optional<Integer> periods, Optional<Money> recurringPriceMoney, Optional<Long> ordinal, Optional<SubscriptionPricing> pricing, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.cadence = cadence;
        this.periods = periods;
        this.recurringPriceMoney = recurringPriceMoney;
        this.ordinal = ordinal;
        this.pricing = pricing;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="cadence")
    public SubscriptionCadence getCadence() {
        return this.cadence;
    }

    @JsonIgnore
    public Optional<Integer> getPeriods() {
        if (this.periods == null) {
            return Optional.empty();
        }
        return this.periods;
    }

    @JsonProperty(value="recurring_price_money")
    public Optional<Money> getRecurringPriceMoney() {
        return this.recurringPriceMoney;
    }

    @JsonIgnore
    public Optional<Long> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonProperty(value="pricing")
    public Optional<SubscriptionPricing> getPricing() {
        return this.pricing;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="periods")
    private Optional<Integer> _getPeriods() {
        return this.periods;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Long> _getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionPhase && this.equalTo((SubscriptionPhase)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionPhase other) {
        return this.uid.equals(other.uid) && this.cadence.equals(other.cadence) && this.periods.equals(other.periods) && this.recurringPriceMoney.equals(other.recurringPriceMoney) && this.ordinal.equals(other.ordinal) && this.pricing.equals(other.pricing);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.cadence, this.periods, this.recurringPriceMoney, this.ordinal, this.pricing);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CadenceStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CadenceStage,
    _FinalStage {
        private SubscriptionCadence cadence;
        private Optional<SubscriptionPricing> pricing = Optional.empty();
        private Optional<Long> ordinal = Optional.empty();
        private Optional<Money> recurringPriceMoney = Optional.empty();
        private Optional<Integer> periods = Optional.empty();
        private Optional<String> uid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubscriptionPhase other) {
            this.uid(other.getUid());
            this.cadence(other.getCadence());
            this.periods(other.getPeriods());
            this.recurringPriceMoney(other.getRecurringPriceMoney());
            this.ordinal(other.getOrdinal());
            this.pricing(other.getPricing());
            return this;
        }

        @Override
        @JsonSetter(value="cadence")
        public _FinalStage cadence(@NotNull SubscriptionCadence cadence) {
            this.cadence = Objects.requireNonNull(cadence, "cadence must not be null");
            return this;
        }

        @Override
        public _FinalStage pricing(SubscriptionPricing pricing) {
            this.pricing = Optional.ofNullable(pricing);
            return this;
        }

        @Override
        @JsonSetter(value="pricing", nulls=Nulls.SKIP)
        public _FinalStage pricing(Optional<SubscriptionPricing> pricing) {
            this.pricing = pricing;
            return this;
        }

        @Override
        public _FinalStage ordinal(Nullable<Long> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @Override
        public _FinalStage ordinal(Long ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        @Override
        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public _FinalStage ordinal(Optional<Long> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        @Override
        public _FinalStage recurringPriceMoney(Money recurringPriceMoney) {
            this.recurringPriceMoney = Optional.ofNullable(recurringPriceMoney);
            return this;
        }

        @Override
        @JsonSetter(value="recurring_price_money", nulls=Nulls.SKIP)
        public _FinalStage recurringPriceMoney(Optional<Money> recurringPriceMoney) {
            this.recurringPriceMoney = recurringPriceMoney;
            return this;
        }

        @Override
        public _FinalStage periods(Nullable<Integer> periods) {
            this.periods = periods.isNull() ? null : (periods.isEmpty() ? Optional.empty() : Optional.of(periods.get()));
            return this;
        }

        @Override
        public _FinalStage periods(Integer periods) {
            this.periods = Optional.ofNullable(periods);
            return this;
        }

        @Override
        @JsonSetter(value="periods", nulls=Nulls.SKIP)
        public _FinalStage periods(Optional<Integer> periods) {
            this.periods = periods;
            return this;
        }

        @Override
        public _FinalStage uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @Override
        public _FinalStage uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        @Override
        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public _FinalStage uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public SubscriptionPhase build() {
            return new SubscriptionPhase(this.uid, this.cadence, this.periods, this.recurringPriceMoney, this.ordinal, this.pricing, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubscriptionPhase build();

        public _FinalStage uid(Optional<String> var1);

        public _FinalStage uid(String var1);

        public _FinalStage uid(Nullable<String> var1);

        public _FinalStage periods(Optional<Integer> var1);

        public _FinalStage periods(Integer var1);

        public _FinalStage periods(Nullable<Integer> var1);

        public _FinalStage recurringPriceMoney(Optional<Money> var1);

        public _FinalStage recurringPriceMoney(Money var1);

        public _FinalStage ordinal(Optional<Long> var1);

        public _FinalStage ordinal(Long var1);

        public _FinalStage ordinal(Nullable<Long> var1);

        public _FinalStage pricing(Optional<SubscriptionPricing> var1);

        public _FinalStage pricing(SubscriptionPricing var1);
    }

    public static interface CadenceStage {
        public _FinalStage cadence(@NotNull SubscriptionCadence var1);

        public Builder from(SubscriptionPhase var1);
    }
}

