/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.Phase;
import com.squareup.square.types.SubscriptionAction;
import com.squareup.square.types.SubscriptionSource;
import com.squareup.square.types.SubscriptionStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Subscription {
    private final Optional<String> id;
    private final Optional<String> locationId;
    private final Optional<String> planVariationId;
    private final Optional<String> customerId;
    private final Optional<String> startDate;
    private final Optional<String> canceledDate;
    private final Optional<String> chargedThroughDate;
    private final Optional<SubscriptionStatus> status;
    private final Optional<String> taxPercentage;
    private final Optional<List<String>> invoiceIds;
    private final Optional<Money> priceOverrideMoney;
    private final Optional<Long> version;
    private final Optional<String> createdAt;
    private final Optional<String> cardId;
    private final Optional<String> timezone;
    private final Optional<SubscriptionSource> source;
    private final Optional<List<SubscriptionAction>> actions;
    private final Optional<Integer> monthlyBillingAnchorDate;
    private final Optional<List<Phase>> phases;
    private final Map<String, Object> additionalProperties;

    private Subscription(Optional<String> id, Optional<String> locationId, Optional<String> planVariationId, Optional<String> customerId, Optional<String> startDate, Optional<String> canceledDate, Optional<String> chargedThroughDate, Optional<SubscriptionStatus> status, Optional<String> taxPercentage, Optional<List<String>> invoiceIds, Optional<Money> priceOverrideMoney, Optional<Long> version, Optional<String> createdAt, Optional<String> cardId, Optional<String> timezone, Optional<SubscriptionSource> source, Optional<List<SubscriptionAction>> actions, Optional<Integer> monthlyBillingAnchorDate, Optional<List<Phase>> phases, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.planVariationId = planVariationId;
        this.customerId = customerId;
        this.startDate = startDate;
        this.canceledDate = canceledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.status = status;
        this.taxPercentage = taxPercentage;
        this.invoiceIds = invoiceIds;
        this.priceOverrideMoney = priceOverrideMoney;
        this.version = version;
        this.createdAt = createdAt;
        this.cardId = cardId;
        this.timezone = timezone;
        this.source = source;
        this.actions = actions;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.phases = phases;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="plan_variation_id")
    public Optional<String> getPlanVariationId() {
        return this.planVariationId;
    }

    @JsonProperty(value="customer_id")
    public Optional<String> getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="start_date")
    public Optional<String> getStartDate() {
        return this.startDate;
    }

    @JsonIgnore
    public Optional<String> getCanceledDate() {
        if (this.canceledDate == null) {
            return Optional.empty();
        }
        return this.canceledDate;
    }

    @JsonProperty(value="charged_through_date")
    public Optional<String> getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    @JsonProperty(value="status")
    public Optional<SubscriptionStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getTaxPercentage() {
        if (this.taxPercentage == null) {
            return Optional.empty();
        }
        return this.taxPercentage;
    }

    @JsonProperty(value="invoice_ids")
    public Optional<List<String>> getInvoiceIds() {
        return this.invoiceIds;
    }

    @JsonProperty(value="price_override_money")
    public Optional<Money> getPriceOverrideMoney() {
        return this.priceOverrideMoney;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getCardId() {
        if (this.cardId == null) {
            return Optional.empty();
        }
        return this.cardId;
    }

    @JsonProperty(value="timezone")
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="source")
    public Optional<SubscriptionSource> getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<List<SubscriptionAction>> getActions() {
        if (this.actions == null) {
            return Optional.empty();
        }
        return this.actions;
    }

    @JsonProperty(value="monthly_billing_anchor_date")
    public Optional<Integer> getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonProperty(value="phases")
    public Optional<List<Phase>> getPhases() {
        return this.phases;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="canceled_date")
    private Optional<String> _getCanceledDate() {
        return this.canceledDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tax_percentage")
    private Optional<String> _getTaxPercentage() {
        return this.taxPercentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="card_id")
    private Optional<String> _getCardId() {
        return this.cardId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="actions")
    private Optional<List<SubscriptionAction>> _getActions() {
        return this.actions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Subscription && this.equalTo((Subscription)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Subscription other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.planVariationId.equals(other.planVariationId) && this.customerId.equals(other.customerId) && this.startDate.equals(other.startDate) && this.canceledDate.equals(other.canceledDate) && this.chargedThroughDate.equals(other.chargedThroughDate) && this.status.equals(other.status) && this.taxPercentage.equals(other.taxPercentage) && this.invoiceIds.equals(other.invoiceIds) && this.priceOverrideMoney.equals(other.priceOverrideMoney) && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.cardId.equals(other.cardId) && this.timezone.equals(other.timezone) && this.source.equals(other.source) && this.actions.equals(other.actions) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.phases.equals(other.phases);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.chargedThroughDate, this.status, this.taxPercentage, this.invoiceIds, this.priceOverrideMoney, this.version, this.createdAt, this.cardId, this.timezone, this.source, this.actions, this.monthlyBillingAnchorDate, this.phases);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> planVariationId = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> startDate = Optional.empty();
        private Optional<String> canceledDate = Optional.empty();
        private Optional<String> chargedThroughDate = Optional.empty();
        private Optional<SubscriptionStatus> status = Optional.empty();
        private Optional<String> taxPercentage = Optional.empty();
        private Optional<List<String>> invoiceIds = Optional.empty();
        private Optional<Money> priceOverrideMoney = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> cardId = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<SubscriptionSource> source = Optional.empty();
        private Optional<List<SubscriptionAction>> actions = Optional.empty();
        private Optional<Integer> monthlyBillingAnchorDate = Optional.empty();
        private Optional<List<Phase>> phases = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Subscription other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.planVariationId(other.getPlanVariationId());
            this.customerId(other.getCustomerId());
            this.startDate(other.getStartDate());
            this.canceledDate(other.getCanceledDate());
            this.chargedThroughDate(other.getChargedThroughDate());
            this.status(other.getStatus());
            this.taxPercentage(other.getTaxPercentage());
            this.invoiceIds(other.getInvoiceIds());
            this.priceOverrideMoney(other.getPriceOverrideMoney());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.cardId(other.getCardId());
            this.timezone(other.getTimezone());
            this.source(other.getSource());
            this.actions(other.getActions());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.phases(other.getPhases());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @JsonSetter(value="plan_variation_id", nulls=Nulls.SKIP)
        public Builder planVariationId(Optional<String> planVariationId) {
            this.planVariationId = planVariationId;
            return this;
        }

        public Builder planVariationId(String planVariationId) {
            this.planVariationId = Optional.ofNullable(planVariationId);
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public Builder startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        @JsonSetter(value="canceled_date", nulls=Nulls.SKIP)
        public Builder canceledDate(Optional<String> canceledDate) {
            this.canceledDate = canceledDate;
            return this;
        }

        public Builder canceledDate(String canceledDate) {
            this.canceledDate = Optional.ofNullable(canceledDate);
            return this;
        }

        public Builder canceledDate(Nullable<String> canceledDate) {
            this.canceledDate = canceledDate.isNull() ? null : (canceledDate.isEmpty() ? Optional.empty() : Optional.of(canceledDate.get()));
            return this;
        }

        @JsonSetter(value="charged_through_date", nulls=Nulls.SKIP)
        public Builder chargedThroughDate(Optional<String> chargedThroughDate) {
            this.chargedThroughDate = chargedThroughDate;
            return this;
        }

        public Builder chargedThroughDate(String chargedThroughDate) {
            this.chargedThroughDate = Optional.ofNullable(chargedThroughDate);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<SubscriptionStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(SubscriptionStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="tax_percentage", nulls=Nulls.SKIP)
        public Builder taxPercentage(Optional<String> taxPercentage) {
            this.taxPercentage = taxPercentage;
            return this;
        }

        public Builder taxPercentage(String taxPercentage) {
            this.taxPercentage = Optional.ofNullable(taxPercentage);
            return this;
        }

        public Builder taxPercentage(Nullable<String> taxPercentage) {
            this.taxPercentage = taxPercentage.isNull() ? null : (taxPercentage.isEmpty() ? Optional.empty() : Optional.of(taxPercentage.get()));
            return this;
        }

        @JsonSetter(value="invoice_ids", nulls=Nulls.SKIP)
        public Builder invoiceIds(Optional<List<String>> invoiceIds) {
            this.invoiceIds = invoiceIds;
            return this;
        }

        public Builder invoiceIds(List<String> invoiceIds) {
            this.invoiceIds = Optional.ofNullable(invoiceIds);
            return this;
        }

        @JsonSetter(value="price_override_money", nulls=Nulls.SKIP)
        public Builder priceOverrideMoney(Optional<Money> priceOverrideMoney) {
            this.priceOverrideMoney = priceOverrideMoney;
            return this;
        }

        public Builder priceOverrideMoney(Money priceOverrideMoney) {
            this.priceOverrideMoney = Optional.ofNullable(priceOverrideMoney);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        public Builder version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="card_id", nulls=Nulls.SKIP)
        public Builder cardId(Optional<String> cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = Optional.ofNullable(cardId);
            return this;
        }

        public Builder cardId(Nullable<String> cardId) {
            this.cardId = cardId.isNull() ? null : (cardId.isEmpty() ? Optional.empty() : Optional.of(cardId.get()));
            return this;
        }

        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public Builder timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<SubscriptionSource> source) {
            this.source = source;
            return this;
        }

        public Builder source(SubscriptionSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="actions", nulls=Nulls.SKIP)
        public Builder actions(Optional<List<SubscriptionAction>> actions) {
            this.actions = actions;
            return this;
        }

        public Builder actions(List<SubscriptionAction> actions) {
            this.actions = Optional.ofNullable(actions);
            return this;
        }

        public Builder actions(Nullable<List<SubscriptionAction>> actions) {
            this.actions = actions.isNull() ? null : (actions.isEmpty() ? Optional.empty() : Optional.of(actions.get()));
            return this;
        }

        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public Builder monthlyBillingAnchorDate(Optional<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        public Builder monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public Builder phases(Optional<List<Phase>> phases) {
            this.phases = phases;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        public Subscription build() {
            return new Subscription(this.id, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.chargedThroughDate, this.status, this.taxPercentage, this.invoiceIds, this.priceOverrideMoney, this.version, this.createdAt, this.cardId, this.timezone, this.source, this.actions, this.monthlyBillingAnchorDate, this.phases, this.additionalProperties);
        }
    }
}

